# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from testit_api_client.models.background_job_attachment_model import BackgroundJobAttachmentModel
from testit_api_client.models.background_job_state import BackgroundJobState
from testit_api_client.models.background_job_type import BackgroundJobType

class BackgroundJobGetModel(BaseModel):
    """
    BackgroundJobGetModel
    """
    id: StrictStr = Field(...)
    job_id: StrictStr = Field(default=..., alias="jobId")
    job_type: BackgroundJobType = Field(default=..., alias="jobType")
    state: BackgroundJobState = Field(...)
    is_deleted: StrictBool = Field(default=..., alias="isDeleted")
    progress: StrictInt = Field(...)
    created_date: datetime = Field(default=..., alias="createdDate")
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    error: Optional[StrictStr] = None
    attachments: conlist(BackgroundJobAttachmentModel) = Field(...)
    __properties = ["id", "jobId", "jobType", "state", "isDeleted", "progress", "createdDate", "startDate", "endDate", "error", "attachments"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BackgroundJobGetModel:
        """Create an instance of BackgroundJobGetModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attachments'] = _items
        # set to None if start_date (nullable) is None
        # and __fields_set__ contains the field
        if self.start_date is None and "start_date" in self.__fields_set__:
            _dict['startDate'] = None

        # set to None if end_date (nullable) is None
        # and __fields_set__ contains the field
        if self.end_date is None and "end_date" in self.__fields_set__:
            _dict['endDate'] = None

        # set to None if error (nullable) is None
        # and __fields_set__ contains the field
        if self.error is None and "error" in self.__fields_set__:
            _dict['error'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BackgroundJobGetModel:
        """Create an instance of BackgroundJobGetModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BackgroundJobGetModel.parse_obj(obj)

        _obj = BackgroundJobGetModel.parse_obj({
            "id": obj.get("id"),
            "job_id": obj.get("jobId"),
            "job_type": obj.get("jobType"),
            "state": obj.get("state"),
            "is_deleted": obj.get("isDeleted"),
            "progress": obj.get("progress"),
            "created_date": obj.get("createdDate"),
            "start_date": obj.get("startDate"),
            "end_date": obj.get("endDate"),
            "error": obj.get("error"),
            "attachments": [BackgroundJobAttachmentModel.from_dict(_item) for _item in obj.get("attachments")] if obj.get("attachments") is not None else None
        })
        return _obj


