# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictStr, conint, conlist
from testit_api_client.models.attachment_update_request import AttachmentUpdateRequest
from testit_api_client.models.available_test_result_outcome import AvailableTestResultOutcome

class AutoTestStepResultUpdateRequest(BaseModel):
    """
    AutoTestStepResultUpdateRequest
    """
    title: Optional[StrictStr] = Field(default=None, description="The name of the step.")
    description: Optional[StrictStr] = Field(default=None, description="Description of the step result.")
    info: Optional[StrictStr] = Field(default=None, description="Extended description of the step result.")
    started_on: Optional[datetime] = Field(default=None, alias="startedOn", description="Step start date.")
    completed_on: Optional[datetime] = Field(default=None, alias="completedOn", description="Step end date.")
    duration: Optional[conint(strict=True, le=43200000000, ge=0)] = Field(default=None, description="Expected or actual duration of the test run execution in milliseconds.")
    outcome: Optional[AvailableTestResultOutcome] = Field(default=None, description="Specifies the result of the autotest execution.")
    step_results: Optional[conlist(AutoTestStepResultUpdateRequest)] = Field(default=None, alias="stepResults", description="Nested step results. The maximum nesting level is 15.")
    attachments: Optional[conlist(AttachmentUpdateRequest)] = Field(default=None, description="/// <summary>  Specifies an attachment GUID. Multiple values can be sent.  </summary>")
    parameters: Optional[Dict[str, StrictStr]] = Field(default=None, description="\"<b>parameter</b>\": \"<b>value</b>\" pair with arbitrary custom parameters. Multiple parameters can be sent.")
    __properties = ["title", "description", "info", "startedOn", "completedOn", "duration", "outcome", "stepResults", "attachments", "parameters"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AutoTestStepResultUpdateRequest:
        """Create an instance of AutoTestStepResultUpdateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in step_results (list)
        _items = []
        if self.step_results:
            for _item in self.step_results:
                if _item:
                    _items.append(_item.to_dict())
            _dict['stepResults'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attachments'] = _items
        # set to None if title (nullable) is None
        # and __fields_set__ contains the field
        if self.title is None and "title" in self.__fields_set__:
            _dict['title'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if info (nullable) is None
        # and __fields_set__ contains the field
        if self.info is None and "info" in self.__fields_set__:
            _dict['info'] = None

        # set to None if started_on (nullable) is None
        # and __fields_set__ contains the field
        if self.started_on is None and "started_on" in self.__fields_set__:
            _dict['startedOn'] = None

        # set to None if completed_on (nullable) is None
        # and __fields_set__ contains the field
        if self.completed_on is None and "completed_on" in self.__fields_set__:
            _dict['completedOn'] = None

        # set to None if duration (nullable) is None
        # and __fields_set__ contains the field
        if self.duration is None and "duration" in self.__fields_set__:
            _dict['duration'] = None

        # set to None if outcome (nullable) is None
        # and __fields_set__ contains the field
        if self.outcome is None and "outcome" in self.__fields_set__:
            _dict['outcome'] = None

        # set to None if step_results (nullable) is None
        # and __fields_set__ contains the field
        if self.step_results is None and "step_results" in self.__fields_set__:
            _dict['stepResults'] = None

        # set to None if attachments (nullable) is None
        # and __fields_set__ contains the field
        if self.attachments is None and "attachments" in self.__fields_set__:
            _dict['attachments'] = None

        # set to None if parameters (nullable) is None
        # and __fields_set__ contains the field
        if self.parameters is None and "parameters" in self.__fields_set__:
            _dict['parameters'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AutoTestStepResultUpdateRequest:
        """Create an instance of AutoTestStepResultUpdateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AutoTestStepResultUpdateRequest.parse_obj(obj)

        _obj = AutoTestStepResultUpdateRequest.parse_obj({
            "title": obj.get("title"),
            "description": obj.get("description"),
            "info": obj.get("info"),
            "started_on": obj.get("startedOn"),
            "completed_on": obj.get("completedOn"),
            "duration": obj.get("duration"),
            "outcome": obj.get("outcome"),
            "step_results": [AutoTestStepResultUpdateRequest.from_dict(_item) for _item in obj.get("stepResults")] if obj.get("stepResults") is not None else None,
            "attachments": [AttachmentUpdateRequest.from_dict(_item) for _item in obj.get("attachments")] if obj.get("attachments") is not None else None,
            "parameters": obj.get("parameters")
        })
        return _obj

AutoTestStepResultUpdateRequest.update_forward_refs()

