# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictStr, conint, conlist, constr
from testit_api_client.models.attachment_put_model import AttachmentPutModel
from testit_api_client.models.attachment_put_model_auto_test_step_results_model import AttachmentPutModelAutoTestStepResultsModel
from testit_api_client.models.available_test_result_outcome import AvailableTestResultOutcome
from testit_api_client.models.failure_category_model import FailureCategoryModel
from testit_api_client.models.link_post_model import LinkPostModel

class AutoTestResultsForTestRunModel(BaseModel):
    """
    AutoTestResultsForTestRunModel
    """
    configuration_id: StrictStr = Field(default=..., alias="configurationId", description="Specifies the GUID of the autotest configuration, which was specified when the test run was created.")
    links: Optional[conlist(LinkPostModel)] = Field(default=None, description="Specifies the links in the autotest.")
    failure_reason_names: Optional[conlist(FailureCategoryModel)] = Field(default=None, alias="failureReasonNames", description="Specifies the cause of autotest failure.")
    auto_test_external_id: constr(strict=True, min_length=1) = Field(default=..., alias="autoTestExternalId", description="Specifies the external ID of the autotest, which was specified when the test run was created.")
    outcome: AvailableTestResultOutcome = Field(default=..., description="Specifies the result of the autotest execution.")
    message: Optional[StrictStr] = Field(default=None, description="A comment for the result.")
    traces: Optional[StrictStr] = Field(default=None, description="An extended comment or a stack trace.")
    started_on: Optional[datetime] = Field(default=None, alias="startedOn", description="Test run start date.")
    completed_on: Optional[datetime] = Field(default=None, alias="completedOn", description="Test run end date.")
    duration: Optional[conint(strict=True, le=43200000000, ge=0)] = Field(default=None, description="Expected or actual duration of the test run execution in milliseconds.")
    attachments: Optional[conlist(AttachmentPutModel)] = Field(default=None, description="Specifies an attachment GUID. Multiple values can be sent.")
    parameters: Optional[Dict[str, StrictStr]] = Field(default=None, description="\"<b>parameter</b>\": \"<b>value</b>\" pair with arbitrary custom parameters. Multiple parameters can be sent.")
    properties: Optional[Dict[str, StrictStr]] = Field(default=None, description="\"<b>property</b>\": \"<b>value</b>\" pair with arbitrary custom properties. Multiple properties can be sent.")
    step_results: Optional[conlist(AttachmentPutModelAutoTestStepResultsModel)] = Field(default=None, alias="stepResults", description="Specifies the results of individual steps.")
    setup_results: Optional[conlist(AttachmentPutModelAutoTestStepResultsModel)] = Field(default=None, alias="setupResults", description="Specifies the results of setup steps. For information on supported values, see the `stepResults` parameter above.")
    teardown_results: Optional[conlist(AttachmentPutModelAutoTestStepResultsModel)] = Field(default=None, alias="teardownResults", description="Specifies the results of the teardown steps. For information on supported values, see the `stepResults` parameter above.")
    __properties = ["configurationId", "links", "failureReasonNames", "autoTestExternalId", "outcome", "message", "traces", "startedOn", "completedOn", "duration", "attachments", "parameters", "properties", "stepResults", "setupResults", "teardownResults"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AutoTestResultsForTestRunModel:
        """Create an instance of AutoTestResultsForTestRunModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attachments (list)
        _items = []
        if self.attachments:
            for _item in self.attachments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attachments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in step_results (list)
        _items = []
        if self.step_results:
            for _item in self.step_results:
                if _item:
                    _items.append(_item.to_dict())
            _dict['stepResults'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in setup_results (list)
        _items = []
        if self.setup_results:
            for _item in self.setup_results:
                if _item:
                    _items.append(_item.to_dict())
            _dict['setupResults'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in teardown_results (list)
        _items = []
        if self.teardown_results:
            for _item in self.teardown_results:
                if _item:
                    _items.append(_item.to_dict())
            _dict['teardownResults'] = _items
        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        # set to None if failure_reason_names (nullable) is None
        # and __fields_set__ contains the field
        if self.failure_reason_names is None and "failure_reason_names" in self.__fields_set__:
            _dict['failureReasonNames'] = None

        # set to None if message (nullable) is None
        # and __fields_set__ contains the field
        if self.message is None and "message" in self.__fields_set__:
            _dict['message'] = None

        # set to None if traces (nullable) is None
        # and __fields_set__ contains the field
        if self.traces is None and "traces" in self.__fields_set__:
            _dict['traces'] = None

        # set to None if started_on (nullable) is None
        # and __fields_set__ contains the field
        if self.started_on is None and "started_on" in self.__fields_set__:
            _dict['startedOn'] = None

        # set to None if completed_on (nullable) is None
        # and __fields_set__ contains the field
        if self.completed_on is None and "completed_on" in self.__fields_set__:
            _dict['completedOn'] = None

        # set to None if duration (nullable) is None
        # and __fields_set__ contains the field
        if self.duration is None and "duration" in self.__fields_set__:
            _dict['duration'] = None

        # set to None if attachments (nullable) is None
        # and __fields_set__ contains the field
        if self.attachments is None and "attachments" in self.__fields_set__:
            _dict['attachments'] = None

        # set to None if parameters (nullable) is None
        # and __fields_set__ contains the field
        if self.parameters is None and "parameters" in self.__fields_set__:
            _dict['parameters'] = None

        # set to None if properties (nullable) is None
        # and __fields_set__ contains the field
        if self.properties is None and "properties" in self.__fields_set__:
            _dict['properties'] = None

        # set to None if step_results (nullable) is None
        # and __fields_set__ contains the field
        if self.step_results is None and "step_results" in self.__fields_set__:
            _dict['stepResults'] = None

        # set to None if setup_results (nullable) is None
        # and __fields_set__ contains the field
        if self.setup_results is None and "setup_results" in self.__fields_set__:
            _dict['setupResults'] = None

        # set to None if teardown_results (nullable) is None
        # and __fields_set__ contains the field
        if self.teardown_results is None and "teardown_results" in self.__fields_set__:
            _dict['teardownResults'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AutoTestResultsForTestRunModel:
        """Create an instance of AutoTestResultsForTestRunModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AutoTestResultsForTestRunModel.parse_obj(obj)

        _obj = AutoTestResultsForTestRunModel.parse_obj({
            "configuration_id": obj.get("configurationId"),
            "links": [LinkPostModel.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None,
            "failure_reason_names": obj.get("failureReasonNames"),
            "auto_test_external_id": obj.get("autoTestExternalId"),
            "outcome": obj.get("outcome"),
            "message": obj.get("message"),
            "traces": obj.get("traces"),
            "started_on": obj.get("startedOn"),
            "completed_on": obj.get("completedOn"),
            "duration": obj.get("duration"),
            "attachments": [AttachmentPutModel.from_dict(_item) for _item in obj.get("attachments")] if obj.get("attachments") is not None else None,
            "parameters": obj.get("parameters"),
            "properties": obj.get("properties"),
            "step_results": [AttachmentPutModelAutoTestStepResultsModel.from_dict(_item) for _item in obj.get("stepResults")] if obj.get("stepResults") is not None else None,
            "setup_results": [AttachmentPutModelAutoTestStepResultsModel.from_dict(_item) for _item in obj.get("setupResults")] if obj.get("setupResults") is not None else None,
            "teardown_results": [AttachmentPutModelAutoTestStepResultsModel.from_dict(_item) for _item in obj.get("teardownResults")] if obj.get("teardownResults") is not None else None
        })
        return _obj


