# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist
from testit_api_client.models.autotest_result_outcome import AutotestResultOutcome
from testit_api_client.models.rerun_test_result_api_result import RerunTestResultApiResult
from testit_api_client.models.test_status_api_result import TestStatusApiResult

class AutoTestResultHistoryApiResult(BaseModel):
    """
    AutoTestResultHistoryApiResult
    """
    id: StrictStr = Field(...)
    test_plan_id: Optional[StrictStr] = Field(default=None, alias="testPlanId")
    test_plan_global_id: Optional[StrictInt] = Field(default=None, alias="testPlanGlobalId")
    test_plan_name: Optional[StrictStr] = Field(default=None, alias="testPlanName")
    duration: Optional[StrictInt] = None
    test_run_id: StrictStr = Field(default=..., alias="testRunId")
    test_run_name: Optional[StrictStr] = Field(default=None, alias="testRunName")
    configuration_id: StrictStr = Field(default=..., alias="configurationId")
    configuration_name: StrictStr = Field(default=..., alias="configurationName")
    outcome: AutotestResultOutcome = Field(...)
    status: TestStatusApiResult = Field(...)
    launch_source: Optional[StrictStr] = Field(default=None, alias="launchSource")
    rerun_count: StrictInt = Field(default=..., alias="rerunCount")
    rerun_test_results: conlist(RerunTestResultApiResult) = Field(default=..., alias="rerunTestResults")
    created_date: datetime = Field(default=..., alias="createdDate")
    created_by_id: StrictStr = Field(default=..., alias="createdById")
    created_by_name: Optional[StrictStr] = Field(default=None, alias="createdByName")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById")
    __properties = ["id", "testPlanId", "testPlanGlobalId", "testPlanName", "duration", "testRunId", "testRunName", "configurationId", "configurationName", "outcome", "status", "launchSource", "rerunCount", "rerunTestResults", "createdDate", "createdById", "createdByName", "modifiedDate", "modifiedById"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AutoTestResultHistoryApiResult:
        """Create an instance of AutoTestResultHistoryApiResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in rerun_test_results (list)
        _items = []
        if self.rerun_test_results:
            for _item in self.rerun_test_results:
                if _item:
                    _items.append(_item.to_dict())
            _dict['rerunTestResults'] = _items
        # set to None if test_plan_id (nullable) is None
        # and __fields_set__ contains the field
        if self.test_plan_id is None and "test_plan_id" in self.__fields_set__:
            _dict['testPlanId'] = None

        # set to None if test_plan_global_id (nullable) is None
        # and __fields_set__ contains the field
        if self.test_plan_global_id is None and "test_plan_global_id" in self.__fields_set__:
            _dict['testPlanGlobalId'] = None

        # set to None if test_plan_name (nullable) is None
        # and __fields_set__ contains the field
        if self.test_plan_name is None and "test_plan_name" in self.__fields_set__:
            _dict['testPlanName'] = None

        # set to None if duration (nullable) is None
        # and __fields_set__ contains the field
        if self.duration is None and "duration" in self.__fields_set__:
            _dict['duration'] = None

        # set to None if test_run_name (nullable) is None
        # and __fields_set__ contains the field
        if self.test_run_name is None and "test_run_name" in self.__fields_set__:
            _dict['testRunName'] = None

        # set to None if launch_source (nullable) is None
        # and __fields_set__ contains the field
        if self.launch_source is None and "launch_source" in self.__fields_set__:
            _dict['launchSource'] = None

        # set to None if created_by_name (nullable) is None
        # and __fields_set__ contains the field
        if self.created_by_name is None and "created_by_name" in self.__fields_set__:
            _dict['createdByName'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_id is None and "modified_by_id" in self.__fields_set__:
            _dict['modifiedById'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AutoTestResultHistoryApiResult:
        """Create an instance of AutoTestResultHistoryApiResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AutoTestResultHistoryApiResult.parse_obj(obj)

        _obj = AutoTestResultHistoryApiResult.parse_obj({
            "id": obj.get("id"),
            "test_plan_id": obj.get("testPlanId"),
            "test_plan_global_id": obj.get("testPlanGlobalId"),
            "test_plan_name": obj.get("testPlanName"),
            "duration": obj.get("duration"),
            "test_run_id": obj.get("testRunId"),
            "test_run_name": obj.get("testRunName"),
            "configuration_id": obj.get("configurationId"),
            "configuration_name": obj.get("configurationName"),
            "outcome": obj.get("outcome"),
            "status": TestStatusApiResult.from_dict(obj.get("status")) if obj.get("status") is not None else None,
            "launch_source": obj.get("launchSource"),
            "rerun_count": obj.get("rerunCount"),
            "rerun_test_results": [RerunTestResultApiResult.from_dict(_item) for _item in obj.get("rerunTestResults")] if obj.get("rerunTestResults") is not None else None,
            "created_date": obj.get("createdDate"),
            "created_by_id": obj.get("createdById"),
            "created_by_name": obj.get("createdByName"),
            "modified_date": obj.get("modifiedDate"),
            "modified_by_id": obj.get("modifiedById")
        })
        return _obj


