# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, constr
from testit_api_client.models.auto_test_step_model import AutoTestStepModel
from testit_api_client.models.label_post_model import LabelPostModel
from testit_api_client.models.link_put_model import LinkPutModel

class AutoTestPutModel(BaseModel):
    """
    AutoTestPutModel
    """
    id: Optional[StrictStr] = Field(default=None, description="Used for search autotest. If value is null or equals Guid mask filled with zeros, search will be executed using ExternalId")
    work_item_ids_for_link_with_auto_test: Optional[conlist(StrictStr, unique_items=True)] = Field(default=None, alias="workItemIdsForLinkWithAutoTest")
    external_id: constr(strict=True, min_length=1) = Field(default=..., alias="externalId", description="External ID of the autotest")
    links: Optional[conlist(LinkPutModel)] = Field(default=None, description="Collection of the autotest links")
    project_id: StrictStr = Field(default=..., alias="projectId", description="Unique ID of the autotest project")
    name: constr(strict=True, min_length=1) = Field(default=..., description="Name of the autotest")
    namespace: Optional[StrictStr] = Field(default=None, description="Name of the autotest namespace")
    classname: Optional[StrictStr] = Field(default=None, description="Name of the autotest class")
    steps: Optional[conlist(AutoTestStepModel)] = Field(default=None, description="Collection of the autotest steps")
    setup: Optional[conlist(AutoTestStepModel)] = Field(default=None, description="Collection of the autotest setup steps")
    teardown: Optional[conlist(AutoTestStepModel)] = Field(default=None, description="Collection of the autotest teardown steps")
    title: Optional[StrictStr] = Field(default=None, description="Name of the autotest in autotest's card")
    description: Optional[StrictStr] = Field(default=None, description="Description of the autotest in autotest's card")
    labels: Optional[conlist(LabelPostModel)] = Field(default=None, description="Collection of the autotest labels")
    is_flaky: Optional[StrictBool] = Field(default=None, alias="isFlaky", description="Indicates if the autotest is marked as flaky")
    external_key: Optional[StrictStr] = Field(default=None, alias="externalKey", description="External key of the autotest")
    __properties = ["id", "workItemIdsForLinkWithAutoTest", "externalId", "links", "projectId", "name", "namespace", "classname", "steps", "setup", "teardown", "title", "description", "labels", "isFlaky", "externalKey"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AutoTestPutModel:
        """Create an instance of AutoTestPutModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in steps (list)
        _items = []
        if self.steps:
            for _item in self.steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['steps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in setup (list)
        _items = []
        if self.setup:
            for _item in self.setup:
                if _item:
                    _items.append(_item.to_dict())
            _dict['setup'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in teardown (list)
        _items = []
        if self.teardown:
            for _item in self.teardown:
                if _item:
                    _items.append(_item.to_dict())
            _dict['teardown'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item in self.labels:
                if _item:
                    _items.append(_item.to_dict())
            _dict['labels'] = _items
        # set to None if id (nullable) is None
        # and __fields_set__ contains the field
        if self.id is None and "id" in self.__fields_set__:
            _dict['id'] = None

        # set to None if work_item_ids_for_link_with_auto_test (nullable) is None
        # and __fields_set__ contains the field
        if self.work_item_ids_for_link_with_auto_test is None and "work_item_ids_for_link_with_auto_test" in self.__fields_set__:
            _dict['workItemIdsForLinkWithAutoTest'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        # set to None if namespace (nullable) is None
        # and __fields_set__ contains the field
        if self.namespace is None and "namespace" in self.__fields_set__:
            _dict['namespace'] = None

        # set to None if classname (nullable) is None
        # and __fields_set__ contains the field
        if self.classname is None and "classname" in self.__fields_set__:
            _dict['classname'] = None

        # set to None if steps (nullable) is None
        # and __fields_set__ contains the field
        if self.steps is None and "steps" in self.__fields_set__:
            _dict['steps'] = None

        # set to None if setup (nullable) is None
        # and __fields_set__ contains the field
        if self.setup is None and "setup" in self.__fields_set__:
            _dict['setup'] = None

        # set to None if teardown (nullable) is None
        # and __fields_set__ contains the field
        if self.teardown is None and "teardown" in self.__fields_set__:
            _dict['teardown'] = None

        # set to None if title (nullable) is None
        # and __fields_set__ contains the field
        if self.title is None and "title" in self.__fields_set__:
            _dict['title'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if labels (nullable) is None
        # and __fields_set__ contains the field
        if self.labels is None and "labels" in self.__fields_set__:
            _dict['labels'] = None

        # set to None if is_flaky (nullable) is None
        # and __fields_set__ contains the field
        if self.is_flaky is None and "is_flaky" in self.__fields_set__:
            _dict['isFlaky'] = None

        # set to None if external_key (nullable) is None
        # and __fields_set__ contains the field
        if self.external_key is None and "external_key" in self.__fields_set__:
            _dict['externalKey'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AutoTestPutModel:
        """Create an instance of AutoTestPutModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AutoTestPutModel.parse_obj(obj)

        _obj = AutoTestPutModel.parse_obj({
            "id": obj.get("id"),
            "work_item_ids_for_link_with_auto_test": obj.get("workItemIdsForLinkWithAutoTest"),
            "external_id": obj.get("externalId"),
            "links": [LinkPutModel.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None,
            "project_id": obj.get("projectId"),
            "name": obj.get("name"),
            "namespace": obj.get("namespace"),
            "classname": obj.get("classname"),
            "steps": [AutoTestStepModel.from_dict(_item) for _item in obj.get("steps")] if obj.get("steps") is not None else None,
            "setup": [AutoTestStepModel.from_dict(_item) for _item in obj.get("setup")] if obj.get("setup") is not None else None,
            "teardown": [AutoTestStepModel.from_dict(_item) for _item in obj.get("teardown")] if obj.get("teardown") is not None else None,
            "title": obj.get("title"),
            "description": obj.get("description"),
            "labels": [LabelPostModel.from_dict(_item) for _item in obj.get("labels")] if obj.get("labels") is not None else None,
            "is_flaky": obj.get("isFlaky"),
            "external_key": obj.get("externalKey")
        })
        return _obj


