# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, conint

class AutoTestProjectSettingsPostModel(BaseModel):
    """
    AutoTestProjectSettingsPostModel
    """
    is_flaky_auto: Optional[StrictBool] = Field(default=False, alias="isFlakyAuto", description="Indicates if the status \"Flaky/Stable\" sets automatically")
    flaky_stability_percentage: Optional[conint(strict=True, le=100, ge=0)] = Field(default=100, alias="flakyStabilityPercentage", description="Stability percentage for autotest flaky computing")
    flaky_test_run_count: Optional[conint(strict=True, le=1000, ge=1)] = Field(default=100, alias="flakyTestRunCount", description="Last test run count for autotest flaky computing")
    rerun_enabled: StrictBool = Field(default=..., alias="rerunEnabled", description="Auto rerun enabled")
    rerun_attempts_count: conint(strict=True, le=10, ge=1) = Field(default=..., alias="rerunAttemptsCount", description="Auto rerun attempt count")
    __properties = ["isFlakyAuto", "flakyStabilityPercentage", "flakyTestRunCount", "rerunEnabled", "rerunAttemptsCount"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AutoTestProjectSettingsPostModel:
        """Create an instance of AutoTestProjectSettingsPostModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AutoTestProjectSettingsPostModel:
        """Create an instance of AutoTestProjectSettingsPostModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AutoTestProjectSettingsPostModel.parse_obj(obj)

        _obj = AutoTestProjectSettingsPostModel.parse_obj({
            "is_flaky_auto": obj.get("isFlakyAuto") if obj.get("isFlakyAuto") is not None else False,
            "flaky_stability_percentage": obj.get("flakyStabilityPercentage") if obj.get("flakyStabilityPercentage") is not None else 100,
            "flaky_test_run_count": obj.get("flakyTestRunCount") if obj.get("flakyTestRunCount") is not None else 100,
            "rerun_enabled": obj.get("rerunEnabled"),
            "rerun_attempts_count": obj.get("rerunAttemptsCount")
        })
        return _obj


