# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from testit_api_client.models.auto_test_step_model import AutoTestStepModel
from testit_api_client.models.label_short_model import LabelShortModel
from testit_api_client.models.link_model import LinkModel

class AutoTestModelV2GetModel(BaseModel):
    """
    AutoTestModelV2GetModel
    """
    external_id: StrictStr = Field(default=..., alias="externalId", description="This property is used to set autotest identifier from client system")
    links: Optional[conlist(LinkModel)] = None
    project_id: StrictStr = Field(default=..., alias="projectId", description="This property is used to link autotest with project")
    name: StrictStr = Field(...)
    namespace: Optional[StrictStr] = None
    classname: Optional[StrictStr] = None
    steps: Optional[conlist(AutoTestStepModel)] = None
    setup: Optional[conlist(AutoTestStepModel)] = None
    teardown: Optional[conlist(AutoTestStepModel)] = None
    global_id: StrictInt = Field(default=..., alias="globalId")
    created_date: Optional[datetime] = Field(default=None, alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate")
    created_by_id: StrictStr = Field(default=..., alias="createdById")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById")
    labels: Optional[conlist(LabelShortModel)] = None
    external_key: Optional[StrictStr] = Field(default=None, alias="externalKey")
    id: StrictStr = Field(default=..., description="Unique ID of the entity")
    is_deleted: StrictBool = Field(default=..., alias="isDeleted", description="Indicates if the entity is deleted")
    __properties = ["externalId", "links", "projectId", "name", "namespace", "classname", "steps", "setup", "teardown", "globalId", "createdDate", "modifiedDate", "createdById", "modifiedById", "labels", "externalKey", "id", "isDeleted"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AutoTestModelV2GetModel:
        """Create an instance of AutoTestModelV2GetModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in steps (list)
        _items = []
        if self.steps:
            for _item in self.steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['steps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in setup (list)
        _items = []
        if self.setup:
            for _item in self.setup:
                if _item:
                    _items.append(_item.to_dict())
            _dict['setup'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in teardown (list)
        _items = []
        if self.teardown:
            for _item in self.teardown:
                if _item:
                    _items.append(_item.to_dict())
            _dict['teardown'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item in self.labels:
                if _item:
                    _items.append(_item.to_dict())
            _dict['labels'] = _items
        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        # set to None if namespace (nullable) is None
        # and __fields_set__ contains the field
        if self.namespace is None and "namespace" in self.__fields_set__:
            _dict['namespace'] = None

        # set to None if classname (nullable) is None
        # and __fields_set__ contains the field
        if self.classname is None and "classname" in self.__fields_set__:
            _dict['classname'] = None

        # set to None if steps (nullable) is None
        # and __fields_set__ contains the field
        if self.steps is None and "steps" in self.__fields_set__:
            _dict['steps'] = None

        # set to None if setup (nullable) is None
        # and __fields_set__ contains the field
        if self.setup is None and "setup" in self.__fields_set__:
            _dict['setup'] = None

        # set to None if teardown (nullable) is None
        # and __fields_set__ contains the field
        if self.teardown is None and "teardown" in self.__fields_set__:
            _dict['teardown'] = None

        # set to None if created_date (nullable) is None
        # and __fields_set__ contains the field
        if self.created_date is None and "created_date" in self.__fields_set__:
            _dict['createdDate'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_id is None and "modified_by_id" in self.__fields_set__:
            _dict['modifiedById'] = None

        # set to None if labels (nullable) is None
        # and __fields_set__ contains the field
        if self.labels is None and "labels" in self.__fields_set__:
            _dict['labels'] = None

        # set to None if external_key (nullable) is None
        # and __fields_set__ contains the field
        if self.external_key is None and "external_key" in self.__fields_set__:
            _dict['externalKey'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AutoTestModelV2GetModel:
        """Create an instance of AutoTestModelV2GetModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AutoTestModelV2GetModel.parse_obj(obj)

        _obj = AutoTestModelV2GetModel.parse_obj({
            "external_id": obj.get("externalId"),
            "links": [LinkModel.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None,
            "project_id": obj.get("projectId"),
            "name": obj.get("name"),
            "namespace": obj.get("namespace"),
            "classname": obj.get("classname"),
            "steps": [AutoTestStepModel.from_dict(_item) for _item in obj.get("steps")] if obj.get("steps") is not None else None,
            "setup": [AutoTestStepModel.from_dict(_item) for _item in obj.get("setup")] if obj.get("setup") is not None else None,
            "teardown": [AutoTestStepModel.from_dict(_item) for _item in obj.get("teardown")] if obj.get("teardown") is not None else None,
            "global_id": obj.get("globalId"),
            "created_date": obj.get("createdDate"),
            "modified_date": obj.get("modifiedDate"),
            "created_by_id": obj.get("createdById"),
            "modified_by_id": obj.get("modifiedById"),
            "labels": [LabelShortModel.from_dict(_item) for _item in obj.get("labels")] if obj.get("labels") is not None else None,
            "external_key": obj.get("externalKey"),
            "id": obj.get("id"),
            "is_deleted": obj.get("isDeleted")
        })
        return _obj


