# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from testit_api_client.models.auto_test_step_api_result import AutoTestStepApiResult
from testit_api_client.models.configuration_short_api_result import ConfigurationShortApiResult
from testit_api_client.models.label_api_result import LabelApiResult
from testit_api_client.models.link_api_result import LinkApiResult
from testit_api_client.models.test_status_api_result import TestStatusApiResult

class AutoTestApiResult(BaseModel):
    """
    AutoTestApiResult
    """
    id: StrictStr = Field(...)
    project_id: StrictStr = Field(default=..., alias="projectId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    name: StrictStr = Field(...)
    namespace: Optional[StrictStr] = None
    classname: Optional[StrictStr] = None
    steps: Optional[conlist(AutoTestStepApiResult)] = None
    setup: Optional[conlist(AutoTestStepApiResult)] = None
    teardown: Optional[conlist(AutoTestStepApiResult)] = None
    title: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    is_flaky: StrictBool = Field(default=..., alias="isFlaky")
    external_key: Optional[StrictStr] = Field(default=None, alias="externalKey")
    global_id: StrictInt = Field(default=..., alias="globalId")
    is_deleted: StrictBool = Field(default=..., alias="isDeleted")
    must_be_approved: StrictBool = Field(default=..., alias="mustBeApproved")
    created_date: datetime = Field(default=..., alias="createdDate")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate")
    created_by_id: StrictStr = Field(default=..., alias="createdById")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById")
    last_test_run_id: Optional[StrictStr] = Field(default=None, alias="lastTestRunId")
    last_test_run_name: Optional[StrictStr] = Field(default=None, alias="lastTestRunName")
    last_test_result_id: Optional[StrictStr] = Field(default=None, alias="lastTestResultId")
    last_test_result_configuration: Optional[ConfigurationShortApiResult] = Field(default=None, alias="lastTestResultConfiguration")
    last_test_result_outcome: Optional[StrictStr] = Field(default=None, alias="lastTestResultOutcome")
    last_test_result_status: Optional[TestStatusApiResult] = Field(default=None, alias="lastTestResultStatus")
    stability_percentage: Optional[StrictInt] = Field(default=None, alias="stabilityPercentage")
    links: Optional[conlist(LinkApiResult)] = None
    labels: Optional[conlist(LabelApiResult)] = None
    __properties = ["id", "projectId", "externalId", "name", "namespace", "classname", "steps", "setup", "teardown", "title", "description", "isFlaky", "externalKey", "globalId", "isDeleted", "mustBeApproved", "createdDate", "modifiedDate", "createdById", "modifiedById", "lastTestRunId", "lastTestRunName", "lastTestResultId", "lastTestResultConfiguration", "lastTestResultOutcome", "lastTestResultStatus", "stabilityPercentage", "links", "labels"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AutoTestApiResult:
        """Create an instance of AutoTestApiResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in steps (list)
        _items = []
        if self.steps:
            for _item in self.steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['steps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in setup (list)
        _items = []
        if self.setup:
            for _item in self.setup:
                if _item:
                    _items.append(_item.to_dict())
            _dict['setup'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in teardown (list)
        _items = []
        if self.teardown:
            for _item in self.teardown:
                if _item:
                    _items.append(_item.to_dict())
            _dict['teardown'] = _items
        # override the default output from pydantic by calling `to_dict()` of last_test_result_configuration
        if self.last_test_result_configuration:
            _dict['lastTestResultConfiguration'] = self.last_test_result_configuration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_test_result_status
        if self.last_test_result_status:
            _dict['lastTestResultStatus'] = self.last_test_result_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in labels (list)
        _items = []
        if self.labels:
            for _item in self.labels:
                if _item:
                    _items.append(_item.to_dict())
            _dict['labels'] = _items
        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict['externalId'] = None

        # set to None if namespace (nullable) is None
        # and __fields_set__ contains the field
        if self.namespace is None and "namespace" in self.__fields_set__:
            _dict['namespace'] = None

        # set to None if classname (nullable) is None
        # and __fields_set__ contains the field
        if self.classname is None and "classname" in self.__fields_set__:
            _dict['classname'] = None

        # set to None if steps (nullable) is None
        # and __fields_set__ contains the field
        if self.steps is None and "steps" in self.__fields_set__:
            _dict['steps'] = None

        # set to None if setup (nullable) is None
        # and __fields_set__ contains the field
        if self.setup is None and "setup" in self.__fields_set__:
            _dict['setup'] = None

        # set to None if teardown (nullable) is None
        # and __fields_set__ contains the field
        if self.teardown is None and "teardown" in self.__fields_set__:
            _dict['teardown'] = None

        # set to None if title (nullable) is None
        # and __fields_set__ contains the field
        if self.title is None and "title" in self.__fields_set__:
            _dict['title'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if external_key (nullable) is None
        # and __fields_set__ contains the field
        if self.external_key is None and "external_key" in self.__fields_set__:
            _dict['externalKey'] = None

        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_id is None and "modified_by_id" in self.__fields_set__:
            _dict['modifiedById'] = None

        # set to None if last_test_run_id (nullable) is None
        # and __fields_set__ contains the field
        if self.last_test_run_id is None and "last_test_run_id" in self.__fields_set__:
            _dict['lastTestRunId'] = None

        # set to None if last_test_run_name (nullable) is None
        # and __fields_set__ contains the field
        if self.last_test_run_name is None and "last_test_run_name" in self.__fields_set__:
            _dict['lastTestRunName'] = None

        # set to None if last_test_result_id (nullable) is None
        # and __fields_set__ contains the field
        if self.last_test_result_id is None and "last_test_result_id" in self.__fields_set__:
            _dict['lastTestResultId'] = None

        # set to None if last_test_result_configuration (nullable) is None
        # and __fields_set__ contains the field
        if self.last_test_result_configuration is None and "last_test_result_configuration" in self.__fields_set__:
            _dict['lastTestResultConfiguration'] = None

        # set to None if last_test_result_outcome (nullable) is None
        # and __fields_set__ contains the field
        if self.last_test_result_outcome is None and "last_test_result_outcome" in self.__fields_set__:
            _dict['lastTestResultOutcome'] = None

        # set to None if last_test_result_status (nullable) is None
        # and __fields_set__ contains the field
        if self.last_test_result_status is None and "last_test_result_status" in self.__fields_set__:
            _dict['lastTestResultStatus'] = None

        # set to None if stability_percentage (nullable) is None
        # and __fields_set__ contains the field
        if self.stability_percentage is None and "stability_percentage" in self.__fields_set__:
            _dict['stabilityPercentage'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        # set to None if labels (nullable) is None
        # and __fields_set__ contains the field
        if self.labels is None and "labels" in self.__fields_set__:
            _dict['labels'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AutoTestApiResult:
        """Create an instance of AutoTestApiResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AutoTestApiResult.parse_obj(obj)

        _obj = AutoTestApiResult.parse_obj({
            "id": obj.get("id"),
            "project_id": obj.get("projectId"),
            "external_id": obj.get("externalId"),
            "name": obj.get("name"),
            "namespace": obj.get("namespace"),
            "classname": obj.get("classname"),
            "steps": [AutoTestStepApiResult.from_dict(_item) for _item in obj.get("steps")] if obj.get("steps") is not None else None,
            "setup": [AutoTestStepApiResult.from_dict(_item) for _item in obj.get("setup")] if obj.get("setup") is not None else None,
            "teardown": [AutoTestStepApiResult.from_dict(_item) for _item in obj.get("teardown")] if obj.get("teardown") is not None else None,
            "title": obj.get("title"),
            "description": obj.get("description"),
            "is_flaky": obj.get("isFlaky"),
            "external_key": obj.get("externalKey"),
            "global_id": obj.get("globalId"),
            "is_deleted": obj.get("isDeleted"),
            "must_be_approved": obj.get("mustBeApproved"),
            "created_date": obj.get("createdDate"),
            "modified_date": obj.get("modifiedDate"),
            "created_by_id": obj.get("createdById"),
            "modified_by_id": obj.get("modifiedById"),
            "last_test_run_id": obj.get("lastTestRunId"),
            "last_test_run_name": obj.get("lastTestRunName"),
            "last_test_result_id": obj.get("lastTestResultId"),
            "last_test_result_configuration": ConfigurationShortApiResult.from_dict(obj.get("lastTestResultConfiguration")) if obj.get("lastTestResultConfiguration") is not None else None,
            "last_test_result_outcome": obj.get("lastTestResultOutcome"),
            "last_test_result_status": TestStatusApiResult.from_dict(obj.get("lastTestResultStatus")) if obj.get("lastTestResultStatus") is not None else None,
            "stability_percentage": obj.get("stabilityPercentage"),
            "links": [LinkApiResult.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None,
            "labels": [LabelApiResult.from_dict(_item) for _item in obj.get("labels")] if obj.get("labels") is not None else None
        })
        return _obj


