# coding: utf-8

"""
    API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr

class AttachmentModel(BaseModel):
    """
    AttachmentModel
    """
    file_id: StrictStr = Field(default=..., alias="fileId", description="Unique ID of the attachment file")
    type: StrictStr = Field(default=..., description="MIME type of the attachment")
    size: Union[StrictFloat, StrictInt] = Field(default=..., description="Size in bytes of the attachment file")
    created_date: datetime = Field(default=..., alias="createdDate", description="Creation date of the attachment")
    modified_date: Optional[datetime] = Field(default=None, alias="modifiedDate", description="Last modification date of the attachment")
    created_by_id: StrictStr = Field(default=..., alias="createdById", description="Unique ID of the attachment creator")
    modified_by_id: Optional[StrictStr] = Field(default=None, alias="modifiedById", description="Unique ID of the attachment last editor")
    name: StrictStr = Field(default=..., description="Name of the attachment file")
    id: StrictStr = Field(default=..., description="Unique ID of the attachment")
    __properties = ["fileId", "type", "size", "createdDate", "modifiedDate", "createdById", "modifiedById", "name", "id"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AttachmentModel:
        """Create an instance of AttachmentModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if modified_date (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_date is None and "modified_date" in self.__fields_set__:
            _dict['modifiedDate'] = None

        # set to None if modified_by_id (nullable) is None
        # and __fields_set__ contains the field
        if self.modified_by_id is None and "modified_by_id" in self.__fields_set__:
            _dict['modifiedById'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AttachmentModel:
        """Create an instance of AttachmentModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AttachmentModel.parse_obj(obj)

        _obj = AttachmentModel.parse_obj({
            "file_id": obj.get("fileId"),
            "type": obj.get("type"),
            "size": obj.get("size"),
            "created_date": obj.get("createdDate"),
            "modified_date": obj.get("modifiedDate"),
            "created_by_id": obj.get("createdById"),
            "modified_by_id": obj.get("modifiedById"),
            "name": obj.get("name"),
            "id": obj.get("id")
        })
        return _obj


