import { Eslint, EslintOptions } from './eslint';
import { JsonFile } from './json';
import { NodeProject, NodeProjectOptions } from './node-project';
import { Task } from './tasks';
/**
 * @experimental
 */
export interface TypeScriptProjectOptions extends NodeProjectOptions {
    /**
     * (experimental) Typescript  artifacts output directory.
     *
     * @default "lib"
     * @experimental
     */
    readonly libdir?: string;
    /**
     * (experimental) Typescript sources directory.
     *
     * @default "src"
     * @experimental
     */
    readonly srcdir?: string;
    /**
     * (experimental) Jest tests directory. Tests files should be named `xxx.test.ts`.
     *
     * If this directory is under `srcdir` (e.g. `src/test`, `src/__tests__`),
     * then tests are going to be compiled into `lib/` and executed as javascript.
     * If the test directory is outside of `src`, then we configure jest to
     * compile the code in-memory.
     *
     * @default "test"
     * @experimental
     */
    readonly testdir?: string;
    /**
     * (experimental) Setup eslint.
     *
     * @default true
     * @experimental
     */
    readonly eslint?: boolean;
    /**
     * (experimental) Eslint options.
     *
     * @default - opinionated default options
     * @experimental
     */
    readonly eslintOptions?: EslintOptions;
    /**
     * (experimental) TypeScript version to use.
     *
     * NOTE: Typescript is not semantically versioned and should remain on the
     * same minor, so we recommend using a `~` dependency (e.g. `~1.2.3`).
     *
     * @default "latest"
     * @experimental
     */
    readonly typescriptVersion?: string;
    /**
     * (experimental) Docgen by Typedoc.
     *
     * @default false
     * @experimental
     */
    readonly docgen?: boolean;
    /**
     * (experimental) Docs directory.
     *
     * @default "docs"
     * @experimental
     */
    readonly docsDirectory?: string;
    /**
     * (experimental) Custom TSConfig.
     *
     * @experimental
     */
    readonly tsconfig?: TypescriptConfigOptions;
    /**
     * (experimental) Do not generate a `tsconfig.json` file (used by jsii projects since tsconfig.json is generated by the jsii compiler).
     *
     * @default false
     * @experimental
     */
    readonly disableTsconfig?: boolean;
    /**
     * (experimental) Compile the code before running tests.
     *
     * @default - if `testdir` is under `src/**`, the default is `true`, otherwise the default is `false.
     * @experimental
     */
    readonly compileBeforeTest?: boolean;
    /**
     * (experimental) Generate one-time sample in `src/` and `test/` if there are no files there.
     *
     * @default true
     * @experimental
     */
    readonly sampleCode?: boolean;
    /**
     * (experimental) The .d.ts file that includes the type declarations for this module.
     *
     * @default - .d.ts file derived from the project's entrypoint (usually lib/index.d.ts)
     * @experimental
     */
    readonly entrypointTypes?: string;
    /**
     * (experimental) Defines a `yarn package` command that will produce a tarball and place it under `dist/js`.
     *
     * @default true
     * @experimental
     */
    readonly package?: boolean;
}
/**
 * (experimental) TypeScript project.
 *
 * @experimental
 * @pjid typescript
 */
export declare class TypeScriptProject extends NodeProject {
    /**
     * @experimental
     */
    readonly docgen?: boolean;
    /**
     * @experimental
     */
    readonly docsDirectory: string;
    /**
     * @experimental
     */
    readonly eslint?: Eslint;
    /**
     * @experimental
     */
    readonly tsconfig?: TypescriptConfig;
    /**
     * (experimental) The directory in which the .ts sources reside.
     *
     * @experimental
     */
    readonly srcdir: string;
    /**
     * (experimental) The directory in which compiled .js files reside.
     *
     * @experimental
     */
    readonly libdir: string;
    /**
     * (experimental) The directory in which tests reside.
     *
     * @experimental
     */
    readonly testdir: string;
    /**
     * (experimental) The "watch" task.
     *
     * @experimental
     */
    readonly watchTask: Task;
    /**
     * (experimental) The "package" task (or undefined if `package` is set to `false`).
     *
     * @experimental
     */
    readonly packageTask?: Task;
    /**
     * @experimental
     */
    constructor(options: TypeScriptProjectOptions);
}
/**
 * @experimental
 */
export interface TypescriptConfigOptions {
    /**
     * @default "tsconfig.json"
     * @experimental
     */
    readonly fileName?: string;
    /**
     * (experimental) Specifies a list of glob patterns that match TypeScript files to be included in compilation.
     *
     * @default - all .ts files recursively
     * @experimental
     */
    readonly include?: string[];
    /**
     * (experimental) Filters results from the "include" option.
     *
     * @default - node_modules is excluded by default
     * @experimental
     */
    readonly exclude?: string[];
    /**
     * (experimental) Compiler options to use.
     *
     * @experimental
     */
    readonly compilerOptions: TypeScriptCompilerOptions;
}
/**
 * (experimental) Determines how modules get resolved.
 *
 * @see https://www.typescriptlang.org/docs/handbook/module-resolution.html
 * @experimental
 */
export declare enum TypeScriptModuleResolution {
    /**
     * (experimental) TypeScript's former default resolution strategy.
     *
     * @see https://www.typescriptlang.org/docs/handbook/module-resolution.html#classic
     * @experimental
     */
    CLASSIC = "classic",
    /**
     * (experimental) Resolution strategy which attempts to mimic the Node.js module resolution strategy at runtime.
     *
     * @see https://www.typescriptlang.org/docs/handbook/module-resolution.html#node
     * @experimental
     */
    NODE = "node"
}
/**
 * (experimental) Determines how JSX should get transformed into valid JavaScript.
 *
 * @see https://www.typescriptlang.org/docs/handbook/jsx.html
 * @experimental
 */
export declare enum TypeScriptJsxMode {
    /**
     * (experimental) Keeps the JSX as part of the output to be further consumed by another transform step (e.g. Babel).
     *
     * @experimental
     */
    PRESERVE = "preserve",
    /**
     * (experimental) Converts JSX syntax into React.createElement, does not need to go through a JSX transformation before use, and the output will have a .js file extension.
     *
     * @experimental
     */
    REACT = "react",
    /**
     * (experimental) Keeps all JSX like 'preserve' mode, but output will have a .js extension.
     *
     * @experimental
     */
    REACT_NATIVE = "react-native",
    /**
     * (experimental) Passes `key` separately from props and always passes `children` as props (since React 17).
     *
     * @see https://www.typescriptlang.org/docs/handbook/release-notes/typescript-4-1.html#react-17-jsx-factories
     * @experimental
     */
    REACT_JSX = "react-jsx",
    /**
     * (experimental) Same as `REACT_JSX` with additional debug data.
     *
     * @experimental
     */
    REACT_JSXDEV = "react-jsxdev"
}
/**
 * @experimental
 */
export interface TypeScriptCompilerOptions {
    /**
     * (experimental) Allow JavaScript files to be compiled.
     *
     * @default false
     * @experimental
     */
    readonly allowJs?: boolean;
    /**
     * (experimental) Ensures that your files are parsed in the ECMAScript strict mode, and emit “use strict” for each source file.
     *
     * @default true
     * @experimental
     */
    readonly alwaysStrict?: boolean;
    /**
     * (experimental) Offers a way to configure the root directory for where declaration files are emitted.
     *
     * @experimental
     */
    readonly declarationDir?: string;
    /**
     * (experimental) To be specified along with the above.
     *
     * @experimental
     */
    readonly declaration?: boolean;
    /**
     * (experimental) Emit __importStar and __importDefault helpers for runtime babel ecosystem compatibility and enable --allowSyntheticDefaultImports for typesystem compatibility.
     *
     * @default false
     * @experimental
     */
    readonly esModuleInterop?: boolean;
    /**
     * (experimental) Enables experimental support for decorators, which is in stage 2 of the TC39 standardization process.
     *
     * @default true
     * @experimental
     */
    readonly experimentalDecorators?: boolean;
    /**
     * (experimental) Disallow inconsistently-cased references to the same file.
     *
     * @default false
     * @experimental
     */
    readonly forceConsistentCasingInFileNames?: boolean;
    /**
     * (experimental) When set, instead of writing out a .js.map file to provide source maps, TypeScript will embed the source map content in the .js files.
     *
     * @default true
     * @experimental
     */
    readonly inlineSourceMap?: boolean;
    /**
     * (experimental) When set, TypeScript will include the original content of the .ts file as an embedded string in the source map. This is often useful in the same cases as inlineSourceMap.
     *
     * @default true
     * @experimental
     */
    readonly inlineSources?: boolean;
    /**
     * (experimental) Perform additional checks to ensure that separate compilation (such as with transpileModule or @babel/plugin-transform-typescript) would be safe.
     *
     * @default false
     * @experimental
     */
    readonly isolatedModules?: boolean;
    /**
     * (experimental) Support JSX in .tsx files: "react", "preserve", "react-native" etc.
     *
     * @default undefined
     * @experimental
     */
    readonly jsx?: TypeScriptJsxMode;
    /**
     * (experimental) Reference for type definitions / libraries to use (eg.
     *
     * ES2016, ES5, ES2018).
     *
     * @default [ "es2018" ]
     * @experimental
     */
    readonly lib?: string[];
    /**
     * (experimental) Sets the module system for the program.
     *
     * See https://www.typescriptlang.org/docs/handbook/modules.html#ambient-modules.
     *
     * @default "CommonJS"
     * @experimental
     */
    readonly module?: string;
    /**
     * (experimental) Determine how modules get resolved.
     *
     * Either "Node" for Node.js/io.js style resolution, or "Classic".
     *
     * @default "node"
     * @experimental
     */
    readonly moduleResolution?: TypeScriptModuleResolution;
    /**
     * (experimental) Do not emit outputs.
     *
     * @default false
     * @experimental
     */
    readonly noEmit?: boolean;
    /**
     * (experimental) Do not emit compiler output files like JavaScript source code, source-maps or declarations if any errors were reported.
     *
     * @default true
     * @experimental
     */
    readonly noEmitOnError?: boolean;
    /**
     * (experimental) Report errors for fallthrough cases in switch statements.
     *
     * Ensures that any non-empty
     * case inside a switch statement includes either break or return. This means you won’t
     * accidentally ship a case fallthrough bug.
     *
     * @default true
     * @experimental
     */
    readonly noFallthroughCasesInSwitch?: boolean;
    /**
     * (experimental) In some cases where no type annotations are present, TypeScript will fall back to a type of any for a variable when it cannot infer the type.
     *
     * @default true
     * @experimental
     */
    readonly noImplicitAny?: boolean;
    /**
     * (experimental) When enabled, TypeScript will check all code paths in a function to ensure they return a value.
     *
     * @default true
     * @experimental
     */
    readonly noImplicitReturns?: boolean;
    /**
     * (experimental) Raise error on ‘this’ expressions with an implied ‘any’ type.
     *
     * @default true
     * @experimental
     */
    readonly noImplicitThis?: boolean;
    /**
     * (experimental) Report errors on unused local variables.
     *
     * @default true
     * @experimental
     */
    readonly noUnusedLocals?: boolean;
    /**
     * (experimental) Report errors on unused parameters in functions.
     *
     * @default true
     * @experimental
     */
    readonly noUnusedParameters?: boolean;
    /**
     * (experimental) Allows importing modules with a ‘.json’ extension, which is a common practice in node projects. This includes generating a type for the import based on the static JSON shape.
     *
     * @default true
     * @experimental
     */
    readonly resolveJsonModule?: boolean;
    /**
     * (experimental) Skip type checking of all declaration files (*.d.ts).
     *
     * @default false
     * @experimental
     */
    readonly skipLibCheck?: boolean;
    /**
     * (experimental) The strict flag enables a wide range of type checking behavior that results in stronger guarantees of program correctness.
     *
     * Turning this on is equivalent to enabling all of the strict mode family
     * options, which are outlined below. You can then turn off individual strict mode family checks as
     * needed.
     *
     * @default true
     * @experimental
     */
    readonly strict?: boolean;
    /**
     * (experimental) When strictNullChecks is false, null and undefined are effectively ignored by the language.
     *
     * This can lead to unexpected errors at runtime.
     * When strictNullChecks is true, null and undefined have their own distinct types and you’ll
     * get a type error if you try to use them where a concrete value is expected.
     *
     * @default true
     * @experimental
     */
    readonly strictNullChecks?: boolean;
    /**
     * (experimental) When set to true, TypeScript will raise an error when a class property was declared but not set in the constructor.
     *
     * @default true
     * @experimental
     */
    readonly strictPropertyInitialization?: boolean;
    /**
     * (experimental) Do not emit declarations for code that has an @internal annotation in it’s JSDoc comment.
     *
     * @default true
     * @experimental
     */
    readonly stripInternal?: boolean;
    /**
     * (experimental) Modern browsers support all ES6 features, so ES6 is a good choice.
     *
     * You might choose to set
     * a lower target if your code is deployed to older environments, or a higher target if your
     * code is guaranteed to run in newer environments.
     *
     * @default "ES2018"
     * @experimental
     */
    readonly target?: string;
    /**
     * (experimental) Output directory for the compiled files.
     *
     * @experimental
     */
    readonly outDir?: string;
    /**
     * (experimental) Specifies the root directory of input files.
     *
     * Only use to control the output directory structure with `outDir`.
     *
     * @experimental
     */
    readonly rootDir?: string;
    /**
     * (experimental) Allow default imports from modules with no default export.
     *
     * This does not affect code emit, just typechecking.
     *
     * @experimental
     */
    readonly allowSyntheticDefaultImports?: boolean;
}
/**
 * @experimental
 */
export declare class TypescriptConfig {
    /**
     * @experimental
     */
    readonly compilerOptions: TypeScriptCompilerOptions;
    /**
     * @experimental
     */
    readonly include: string[];
    /**
     * @experimental
     */
    readonly exclude: string[];
    /**
     * @experimental
     */
    readonly fileName: string;
    /**
     * @experimental
     */
    readonly file: JsonFile;
    /**
     * @experimental
     */
    constructor(project: NodeProject, options: TypescriptConfigOptions);
}
/**
 * (experimental) TypeScript app.
 *
 * @experimental
 * @pjid typescript-app
 */
export declare class TypeScriptAppProject extends TypeScriptProject {
    /**
     * @experimental
     */
    constructor(options: TypeScriptProjectOptions);
}
/**
 * @deprecated use `TypeScriptProject`
 */
export declare class TypeScriptLibraryProject extends TypeScriptProject {
}
/**
 * @deprecated use TypeScriptProjectOptions
 */
export interface TypeScriptLibraryProjectOptions extends TypeScriptProjectOptions {
}
/**
 * @internal
 */
export declare function mergeTsconfigOptions(options: (TypescriptConfigOptions | undefined)[]): TypescriptConfigOptions;
