"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const util_1 = require("./util");
const PULL_REQUEST_TEMPLATE_FILE = '.github/pull_request_template.md';
test('default', () => {
    var _a;
    // GIVEN
    const project = new util_1.TestProject();
    // WHEN
    (_a = project.github) === null || _a === void 0 ? void 0 : _a.addPullRequestTemplate();
    // THEN
    expect(util_1.synthSnapshot(project)[PULL_REQUEST_TEMPLATE_FILE]).toStrictEqual('Fixes #');
});
test('custom content', () => {
    var _a;
    // GIVEN
    const project = new util_1.TestProject();
    // WHEN
    (_a = project.github) === null || _a === void 0 ? void 0 : _a.addPullRequestTemplate('hello', 'world', '', 'foobar');
    // THEN
    expect(util_1.synthSnapshot(project)[PULL_REQUEST_TEMPLATE_FILE]).toStrictEqual([
        'hello',
        'world',
        '',
        'foobar',
    ].join('\n'));
});
//# sourceMappingURL=data:application/json;base64,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