"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const path = require("path");
const cdk = require("@aws-cdk/core");
const _1 = require(".");
class IntegTesting {
    constructor() {
        const devEnv = {
            account: process.env.CDK_DEFAULT_ACCOUNT,
            region: process.env.CDK_DEFAULT_REGION,
        };
        const app = new cdk.App();
        const stack = new cdk.Stack(app, 'lambda-bash-dev', { env: devEnv });
        const fn = new _1.BashExecFunction(stack, 'Demo', {
            script: path.join(__dirname, '../demo.sh'),
            dockerfile: path.join(__dirname, '../Dockerfile'),
            environment: {
                FOO: 'BAR',
            },
        });
        fn.run({ runOnUpdate: true });
        app.synth();
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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