# Generated by Django 3.1.6 on 2021-09-21 14:21

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Gift',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100)),
                ('desc', models.TextField(blank=True, default='', help_text='Specific details of this item, such as preferred model.', verbose_name='description')),
                ('url', models.URLField(blank=True, default='', help_text='A website showing the item.')),
                ('image', models.ImageField(blank=True, help_text='A photo or illustration.', null=True, upload_to='gift_registry/images')),
                ('one_only', models.BooleanField(default=True, help_text='When checked, remove item from list someone has chosen it. For some items, you may be happy to receive multiple.')),
                ('live', models.BooleanField(default=False, help_text='Make this item visible to public.')),
            ],
            options={
                'ordering': ['title'],
            },
        ),
        migrations.CreateModel(
            name='Giver',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.EmailField(max_length=254)),
                ('gift', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='gift_registry.gift')),
            ],
            options={
                'ordering': ['id'],
                'unique_together': {('gift', 'email')},
            },
        ),
    ]
