from .base_model import *


class HltSmTap(BaseModel):
    id = models.AutoField(db_column="SMTAPID", primary_key=True)
    tap = models.ForeignKey("HltTap", db_column="rf_TAPID", **FK_DEFAULT)
    reg_s = models.SmallIntegerField(db_column="REG_S")
    uuid = models.CharField(db_column="SMTAPGuid", max_length=36)
    is_fake = models.BooleanField(db_column="IsFake")
    lpu_doctor = models.ForeignKey("HltLpuDoctor", db_column="rf_LPUDoctorID", **FK_DEFAULT)
    count = models.DecimalField(db_column="Count", max_digits=9, decimal_places=2)
    date_p = models.DateTimeField(db_column="DATE_P")
    doctor_visit_table = models.ForeignKey("HltDoctorVisitTable", db_column="rf_DoctorVisitTableID", **FK_DEFAULT)
    flags = models.IntegerField(db_column="FLAGS")
    lpu = models.ForeignKey("OmsLpu", db_column="rf_LPUID", **FK_DEFAULT)
    mkb = models.ForeignKey("OmsMkb", db_column="rf_MKBID", **FK_DEFAULT)
    description = models.CharField(db_column="Description", max_length=1000)
    service_medical = models.ForeignKey("OmsServiceMedical", db_column="rf_omsServiceMedicalID", **FK_DEFAULT)
    tariff_id = models.IntegerField(db_column="rf_TariffID")
    department = models.ForeignKey("OmsDepartment", db_column="rf_DepartmentID", **FK_DEFAULT)
    create_user_name = models.CharField(db_column="CreateUserName", max_length=255)
    edit_user_name = models.CharField(db_column="EditUserName", max_length=255)
    flag_bill = models.BooleanField(db_column="FlagBill")
    flag_complete = models.BooleanField(db_column="FlagComplete")
    flag_pay = models.BooleanField(db_column="FlagPay")
    flag_statist = models.BooleanField(db_column="FlagStatist")
    create_user = models.ForeignKey("XUser", db_column="rf_CreateUserID", **FK_DEFAULT)
    edit_user = models.ForeignKey("XUser", db_column="rf_EditUserID", **FK_DEFAULT)
    invoice_id = models.IntegerField(db_column="rf_InvoiceID")
    doc_prvd = models.ForeignKey("HltDocPrvd", db_column="rf_DocPRVDID", **FK_DEFAULT)
    sum_opl = models.DecimalField(db_column="Sum_Opl", max_digits=18, decimal_places=2)
    sum_v = models.DecimalField(db_column="Sum_V", max_digits=18, decimal_places=2)
    date_e = models.DateTimeField(db_column="DATE_E")
    visit_place = models.ForeignKey("OmsKlVisitPlace", db_column="rf_kl_VisitPlaceID", **FK_DEFAULT)
    lpu_doctor_sid = models.IntegerField(db_column="rf_LPUDoctor_SID")
    bill_service_id = models.IntegerField(db_column="rf_BillServiceID")
    root_sm_tap = models.ForeignKey("HltSmTap", db_column="rf_RootSMTAPID", **FK_DEFAULT)
    operation_id = models.IntegerField(db_column="rf_OperationID")
    teeth_id = models.IntegerField(db_column="rf_kl_TeethID")
    action_teeth_id = models.IntegerField(db_column="rf_kl_ActionTeethID")
    usl_profit_type_id = models.IntegerField(db_column="rf_usl_ProfitTypeID")
    date_warranty = models.DateTimeField(db_column="DateWarranty")
    is_fail_warranty = models.BooleanField(db_column="IsFailWarranty")
    assistant_doc_prvd_id = models.IntegerField(db_column="rf_AssistantDocPRVDID")
    nom_service_id = models.IntegerField(db_column="rf_kl_NomServiceID")
    dogovor_paying_id = models.IntegerField(db_column="rf_DogovorPayingID")

    class Meta:
        managed = False
        db_table = "hlt_SMTAP"
