# IODATA is an input and output module for quantum chemistry.
# Copyright (C) 2011-2019 The IODATA Development Team
#
# This file is part of IODATA.
#
# IODATA is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.
#
# IODATA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see <http://www.gnu.org/licenses/>
# --
"""Transformation matrices from Cartesian to pure basis functions.

Both Cartesian and pure functions are assumed to be normalized. These matrices
were generated with:

.. code-block:: bash

    python tools/harmonics.py L2 python 7
"""

import numpy as np

__all__ = ["tfs"]

tf0 = np.array([
    [1.0],
])
tf1 = np.array([
    [0, 0, 1.0],
    [1.0, 0, 0],
    [0, 1.0, 0],
])
tf2 = np.array([
    [-0.5, 0, 0, -0.5, 0, 1.0],
    [0, 0, 1.0, 0, 0, 0],
    [0, 0, 0, 0, 1.0, 0],
    [0.86602540378443865, 0, 0, -0.86602540378443865, 0, 0],
    [0, 1.0, 0, 0, 0, 0],
])
tf3 = np.array([
    [0, 0, -0.67082039324993691, 0, 0, 0, 0, -0.67082039324993691, 0, 1.0],
    [-0.61237243569579452, 0, 0, -0.27386127875258306, 0, 1.0954451150103322, 0,
     0, 0, 0],
    [0, -0.27386127875258306, 0, 0, 0, 0, -0.61237243569579452, 0,
     1.0954451150103322, 0],
    [0, 0, 0.86602540378443865, 0, 0, 0, 0, -0.86602540378443865, 0, 0],
    [0, 0, 0, 0, 1.0, 0, 0, 0, 0, 0],
    [0.79056941504209483, 0, 0, -1.0606601717798213, 0, 0, 0, 0, 0, 0],
    [0, 1.0606601717798213, 0, 0, 0, 0, -0.79056941504209483, 0, 0, 0],
])
tf4 = np.array([
    [0.375, 0, 0, 0.21957751641341997, 0, -0.87831006565367986, 0, 0, 0, 0,
     0.375, 0, -0.87831006565367986, 0, 1.0],
    [0, 0, -0.89642145700079523, 0, 0, 0, 0, -0.40089186286863658, 0,
     1.1952286093343936, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, -0.40089186286863658, 0, 0, 0, 0, 0, 0, -0.89642145700079523,
     0, 1.1952286093343936, 0],
    [-0.55901699437494742, 0, 0, 0, 0, 0.98198050606196572, 0, 0, 0, 0,
     0.55901699437494742, 0, -0.98198050606196572, 0, 0],
    [0, -0.42257712736425829, 0, 0, 0, 0, -0.42257712736425829, 0,
     1.1338934190276817, 0, 0, 0, 0, 0, 0],
    [0, 0, 0.79056941504209483, 0, 0, 0, 0, -1.0606601717798213, 0, 0, 0, 0, 0,
     0, 0],
    [0, 0, 0, 0, 1.0606601717798213, 0, 0, 0, 0, 0, 0, -0.79056941504209483, 0,
     0, 0],
    [0.73950997288745201, 0, 0, -1.299038105676658, 0, 0, 0, 0, 0, 0,
     0.73950997288745201, 0, 0, 0, 0],
    [0, 1.1180339887498948, 0, 0, 0, 0, -1.1180339887498948, 0, 0, 0, 0, 0, 0,
     0, 0],
])
tf5 = np.array([
    [0, 0, 0.625, 0, 0, 0, 0, 0.36596252735569994, 0, -1.0910894511799619, 0, 0,
     0, 0, 0, 0, 0.625, 0, -1.0910894511799619, 0, 1.0],
    [0.48412291827592711, 0, 0, 0.21128856368212914, 0, -1.2677313820927749, 0,
     0, 0, 0, 0.1613743060919757, 0, -0.56694670951384084, 0,
     1.2909944487358056, 0, 0, 0, 0, 0, 0],
    [0, 0.1613743060919757, 0, 0, 0, 0, 0.21128856368212914, 0,
     -0.56694670951384084, 0, 0, 0, 0, 0, 0, 0.48412291827592711, 0,
     -1.2677313820927749, 0, 1.2909944487358056, 0],
    [0, 0, -0.85391256382996653, 0, 0, 0, 0, 0, 0, 1.1180339887498948, 0, 0, 0,
     0, 0, 0, 0.85391256382996653, 0, -1.1180339887498948, 0, 0],
    [0, 0, 0, 0, -0.64549722436790281, 0, 0, 0, 0, 0, 0, -0.64549722436790281,
     0, 1.2909944487358056, 0, 0, 0, 0, 0, 0, 0],
    [-0.52291251658379722, 0, 0, 0.22821773229381921, 0, 0.91287092917527686, 0,
     0, 0, 0, 0.52291251658379722, 0, -1.224744871391589, 0, 0, 0, 0, 0, 0, 0,
     0],
    [0, -0.52291251658379722, 0, 0, 0, 0, -0.22821773229381921, 0,
     1.224744871391589, 0, 0, 0, 0, 0, 0, 0.52291251658379722, 0,
     -0.91287092917527686, 0, 0, 0],
    [0, 0, 0.73950997288745201, 0, 0, 0, 0, -1.299038105676658, 0, 0, 0, 0, 0,
     0, 0, 0, 0.73950997288745201, 0, 0, 0, 0],
    [0, 0, 0, 0, 1.1180339887498948, 0, 0, 0, 0, 0, 0, -1.1180339887498948, 0,
     0, 0, 0, 0, 0, 0, 0, 0],
    [0.70156076002011401, 0, 0, -1.5309310892394863, 0, 0, 0, 0, 0, 0,
     1.1692679333668567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 1.1692679333668567, 0, 0, 0, 0, -1.5309310892394863, 0, 0, 0, 0, 0, 0,
     0, 0, 0.70156076002011401, 0, 0, 0, 0, 0],
])
tf6 = np.array([
    [-0.3125, 0, 0, -0.16319780245846672, 0, 0.97918681475080034, 0, 0, 0, 0,
     -0.16319780245846672, 0, 0.57335309036732874, 0, -1.3055824196677338, 0, 0,
     0, 0, 0, 0, -0.3125, 0, 0.97918681475080034, 0, -1.3055824196677338, 0,
     1.0],
    [0, 0, 0.8635615996346968, 0, 0, 0, 0, 0.37688918072220453, 0,
     -1.6854996561581052, 0, 0, 0, 0, 0, 0, 0.28785386654489893, 0,
     -0.75377836144440906, 0, 1.3816985594155149, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0.28785386654489893, 0, 0, 0, 0, 0, 0, 0.37688918072220453, 0,
     -0.75377836144440906, 0, 0, 0, 0, 0, 0, 0, 0, 0.8635615996346968, 0,
     -1.6854996561581052, 0, 1.3816985594155149, 0],
    [0.45285552331841996, 0, 0, 0.078832027985861409, 0, -1.2613124477737825, 0,
     0, 0, 0, -0.078832027985861409, 0, 0, 0, 1.2613124477737825, 0, 0, 0, 0, 0,
     0, -0.45285552331841996, 0, 1.2613124477737825, 0, -1.2613124477737825, 0,
     0],
    [0, 0.27308215547040718, 0, 0, 0, 0, 0.26650089544451304, 0,
     -0.95346258924559232, 0, 0, 0, 0, 0, 0, 0.27308215547040718, 0,
     -0.95346258924559232, 0, 1.4564381625088383, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, -0.81924646641122153, 0, 0, 0, 0, 0.35754847096709712, 0,
     1.0660035817780522, 0, 0, 0, 0, 0, 0, 0.81924646641122153, 0,
     -1.4301938838683885, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, -0.81924646641122153, 0, 0, 0, 0, 0, 0, -0.35754847096709712,
     0, 1.4301938838683885, 0, 0, 0, 0, 0, 0, 0, 0, 0.81924646641122153, 0,
     -1.0660035817780522, 0, 0, 0],
    [-0.49607837082461074, 0, 0, 0.4317807998173484, 0, 0.8635615996346968, 0,
     0, 0, 0, 0.4317807998173484, 0, -1.5169496905422947, 0, 0, 0, 0, 0, 0, 0, 0,
     -0.49607837082461074, 0, 0.8635615996346968, 0, 0, 0, 0],
    [0, -0.59829302641309923, 0, 0, 0, 0, 0, 0, 1.3055824196677338, 0, 0, 0, 0,
     0, 0, 0.59829302641309923, 0, -1.3055824196677338, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0],
    [0, 0, 0.70156076002011401, 0, 0, 0, 0, -1.5309310892394863, 0, 0, 0, 0, 0,
     0, 0, 0, 1.1692679333668567, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 1.1692679333668567, 0, 0, 0, 0, 0, 0, -1.5309310892394863, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0.70156076002011401, 0, 0, 0, 0, 0],
    [0.67169328938139616, 0, 0, -1.753901900050285, 0, 0, 0, 0, 0, 0,
     1.753901900050285, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.67169328938139616, 0, 0,
     0, 0, 0, 0],
    [0, 1.2151388809514738, 0, 0, 0, 0, -1.9764235376052371, 0, 0, 0, 0, 0, 0,
     0, 0, 1.2151388809514738, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
])
tf7 = np.array([
    [0, 0, -0.60670333962134435, 0, 0, 0, 0, -0.31684048566533185, 0,
     1.4169537279434594, 0, 0, 0, 0, 0, 0, -0.31684048566533185, 0,
     0.82968314787883083, 0, -1.5208343311935929, 0, 0, 0, 0, 0, 0, 0, 0,
     -0.60670333962134435, 0, 1.4169537279434594, 0, -1.5208343311935929, 0,
     1.0],
    [-0.41339864235384228, 0, 0, -0.17963167078872715, 0, 1.4370533663098172, 0,
     0, 0, 0, -0.13388954226515239, 0, 0.62718150750531808, 0,
     -2.1422326762424382, 0, 0, 0, 0, 0, 0, -0.11465615401645981, 0,
     0.47901778876993906, 0, -0.95803557753987813, 0, 1.4675987714106856, 0, 0,
     0, 0, 0, 0, 0, 0],
    [0, -0.11465615401645981, 0, 0, 0, 0, -0.13388954226515239, 0,
     0.47901778876993906, 0, 0, 0, 0, 0, 0, -0.17963167078872715, 0,
     0.62718150750531808, 0, -0.95803557753987813, 0, 0, 0, 0, 0, 0, 0, 0,
     -0.41339864235384228, 0, 1.4370533663098172, 0, -2.1422326762424382, 0,
     1.4675987714106856, 0],
    [0, 0, 0.8425472196308598, 0, 0, 0, 0, 0.1466686450253306, 0,
     -1.7491256557036031, 0, 0, 0, 0, 0, 0, -0.1466686450253306, 0, 0, 0,
     1.4080189922431737, 0, 0, 0, 0, 0, 0, 0, 0, -0.8425472196308598, 0,
     1.7491256557036031, 0, -1.4080189922431737, 0, 0],
    [0, 0, 0, 0, 0.50807509012231371, 0, 0, 0, 0, 0, 0, 0.49583051751369852, 0,
     -1.3222147133698627, 0, 0, 0, 0, 0, 0, 0, 0, 0.50807509012231371, 0,
     -1.3222147133698627, 0, 1.6258402883914039, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0.42961647140211, 0, 0, -0.062226236090912313, 0, -1.2445247218182463, 0,
     0, 0, 0, -0.23190348980538452, 0, 0.54315511828342603, 0,
     1.2368186122953841, 0, 0, 0, 0, 0, 0, -0.35746251148251143, 0,
     1.2445247218182463, 0, -1.6593662957576617, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0.35746251148251143, 0, 0, 0, 0, 0.23190348980538452, 0,
     -1.2445247218182463, 0, 0, 0, 0, 0, 0, 0.062226236090912313, 0,
     -0.54315511828342603, 0, 1.6593662957576617, 0, 0, 0, 0, 0, 0, 0, 0,
     -0.42961647140211, 0, 1.2445247218182463, 0, -1.2368186122953841, 0, 0, 0],
    [0, 0, -0.79037935147039945, 0, 0, 0, 0, 0.68793692409875888, 0,
     1.0255158176779587, 0, 0, 0, 0, 0, 0, 0.68793692409875888, 0,
     -1.8014417303072303, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.79037935147039945, 0,
     1.0255158176779587, 0, 0, 0, 0],
    [0, 0, 0, 0, -0.95323336395336381, 0, 0, 0, 0, 0, 0, 0, 0,
     1.5504341823651057, 0, 0, 0, 0, 0, 0, 0, 0, 0.95323336395336381, 0,
     -1.5504341823651057, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [-0.47495887979908324, 0, 0, 0.61914323168888299, 0, 0.82552430891851066, 0,
     0, 0, 0, 0.25637895441948968, 0, -1.8014417303072303, 0, 0, 0, 0, 0, 0, 0,
     0, -0.65864945955866621, 0, 1.3758738481975178, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0],
    [0, -0.65864945955866621, 0, 0, 0, 0, 0.25637895441948968, 0,
     1.3758738481975178, 0, 0, 0, 0, 0, 0, 0.61914323168888299, 0,
     -1.8014417303072303, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.47495887979908324, 0,
     0.82552430891851066, 0, 0, 0, 0, 0],
    [0, 0, 0.67169328938139616, 0, 0, 0, 0, -1.753901900050285, 0, 0, 0, 0, 0,
     0, 0, 0, 1.753901900050285, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     -0.67169328938139616, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 1.2151388809514738, 0, 0, 0, 0, 0, 0, -1.9764235376052371, 0,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 1.2151388809514738, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0],
    [0.64725984928774935, 0, 0, -1.96875, 0, 0, 0, 0, 0, 0, 2.445699350390395,
     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1.2566230789301938, 0, 0, 0, 0, 0, 0, 0, 0,
     0, 0, 0, 0, 0, 0],
    [0, 1.2566230789301938, 0, 0, 0, 0, -2.445699350390395, 0, 0, 0, 0, 0, 0, 0,
     0, 1.96875, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.64725984928774935, 0, 0,
     0, 0, 0, 0, 0],
])

tfs = [tf0, tf1, tf2, tf3, tf4, tf5, tf6, tf7]
