#  Copyright 2017-2023 John Snow Labs
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
"""Contains classes for OpenAIEmbeddings."""
from sparknlp.common import *

class OpenAIEmbeddings(AnnotatorModel):
    """Transformer that makes a request for OpenAI Embeddings API for each executor.
   
    See OpenAI API Doc: https://platform.openai.com/docs/api-reference/embeddings/create for reference

    ====================== =======================
    Input Annotation types Output Annotation type
    ====================== =======================
    ``DOCUMENT``           ``SENTENCE_EMBEDDINGS``
    ====================== =======================

    Parameters
    ----------
    model
        ID of the OpenAI model to use.
    user
        A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse.

    Examples
    --------
    >>> import sparknlp
    >>> from sparknlp.base import *
    >>> from sparknlp.annotator import *
    >>> from sparknlp.common import *
    >>> from pyspark.ml import Pipeline

    >>> documentAssembler = DocumentAssembler() \\
    ...     .setInputCol("text") \\
    ...     .setOutputCol("document")
    >>> openai_embeddings = OpenAIEmbeddings() \\
    ...     .setInputCols("document") \\
    ...     .setOutputCol("embeddings") \\
    ...     .setModel("text-embedding-ada-002")
    >>> pipeline = Pipeline().setStages([
    ...     documentAssembler,
    ...     openai_embeddings
    ... ])
    >>> empty_df = spark.createDataFrame([[""]], ["text"])
    >>> sample_text= [["The food was delicious and the waiter..."]]
    >>> sample_df = spark.createDataFrame(sample_text).toDF("text")
    >>> sample_df.select("embeddings").show()
    +-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
    |embeddings                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
    +-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
    |[{sentence_embeddings, 0, 39, The food was delicious and the waiter..., {sentence -> 0}, [0.002297497, -0.009297881, 0.015739758, -0.0076794787, -0.004737794, 0.01487661, -0.009856389, -0.03823238, -0.0069305706, -0.028610818, 0.025208998, 0.018138802, -0.0036271256, -0.025539026, 5.204275E-4, -0.016374426, 0.02828079, 0.0054073683, 0.009710415, -0.016399812, -0.015397037, 0.00427766, 0.006987691, -0.0072859847, -0.003874646, 0.018544989, 0.008752067, -0.022657635, 0.011493831, 0.023901584, 0.015638212, -0.0035192322, -0.034932107, -0.0041919798, -0.02612292, -0.021515233, -0.005715182, 0.011754045, 0.008453773, 0.004080913, 0.019179657, -0.014419649, 0.00893612, 0.0063911034, -0.045670684, 0.017884934, -0.005610462, -7.219344E-4, -0.02211182, -0.0039539794, 0.021007499, -0.017631067, -0.011696924, -0.02260686, 0.016336346, 0.017174106, -0.008466466, 0.0015922225, 0.025094759, -0.024967825, 0.007806412, 0.005794516, -0.022187982, 0.0029162979, -0.0060959826, -0.025564414, -0.008104706, 0.0010178483, 1.9823447E-4, 0.0046425937, 0.02074094, 0.013467647, 0.004626727, -0.016006319, 0.0166156, -0.008948814, -0.007616012, 0.013619968, -0.0069749975, 0.0052677416, 0.009881775, -0.04592455, 0.0030464048, 0.024003131, 0.02301305, 0.006981344, -0.023571556, 0.009938896, -0.006537077, -0.033332746, -0.002690991, 0.019928563, 0.0017596161, 0.001090835, -0.022683023, 0.005007528, 0.01540973, 0.031530287, -0.0054676617, -0.015980931, -0.0051471544, 0.019890483, -0.009386734, -0.0062133963, -0.031174876, -0.009405775, -0.015270104, -0.028864685, 0.021020193, -0.018303815, -0.0029210579, 0.012693353, 0.005102728, -0.049580235, -0.04300508, -4.1293065E-4, 0.0215787, -0.016894853, 0.0065434235, -0.041431103, 9.662815E-4, 0.03351045, 0.0128901, -0.010510096, -5.807209E-4, 0.01835459, 9.2869726E-5, -0.01309954, 0.011982525, 0.005813556, 0.0070194243, 0.008637827, 0.018456135, -8.5521466E-4, -0.019141577, 0.021896034, -0.02975322, -0.0043220865, 0.0015160623, -0.0052074483, 0.0149527695, 0.0213883, -0.018836936, 0.01105591, -0.0074636918, 0.022632249, 0.019141577, 0.0149527695, -0.0036810723, 0.006286383, 0.025678653, -0.027773056, 0.03668379, -0.00445854, 0.013911915, 0.008015852, -0.0056739287, 0.010281616, -0.0057659554, -0.00872668, 0.010649723, 2.0787844E-5, 0.032164957, -0.023838118, -0.002641804, 0.030387888, 0.029626286, 0.016602905, 0.0021784967, 0.0010519617, -0.0116524985, 0.018519603, -0.007552545, 0.007419265, -0.0011090817, 0.0044331537, 0.009989669, -0.007533505, -0.0061943564, -0.0057088356, -0.028230017, 0.0042554466, 0.029321646, 0.024790118, -0.015676292, -0.018202268, 0.0075017717, 0.00865052, -0.011696924, -0.0063942764, 0.0020118963, 0.036963046, -0.002335577, -0.020804405, -0.6888937, -0.019598536, 0.0034748053, 0.0067401705, 0.02835695, 0.023393849, 0.0071527045, 0.010586256, 0.0096088685, -0.009488282, -0.021337526, 3.6766098E-5, 0.019801632, 0.0022705235, -0.009558095, -0.0020753632, -3.708839E-4, 0.0066449703, -0.04130417, 0.011220924, -0.013391487, 0.027722282, -0.011366897, 2.4434706E-4, 0.015460504, -5.549375E-4, 0.01449581, -0.008529933, -0.018875016, -0.017745307, -0.009437508, 0.024587024, 0.013010687, -0.008993241, 0.034932107, -0.005093208, -0.024218917, 0.024066597, -0.0037857925, 0.031047942, -0.015003543, -0.023266915, 0.03021018, 0.0069115306, 0.010154682, 0.011430364, 0.030311726, 0.01764376, 0.0020975766, -0.006746517, 0.009748495, 0.01665368, 0.003658859, 0.02789999, 0.0040682196, 0.0031289116, 0.029905539, -0.016882159, 0.0021689767, 0.023228835, 0.011773085, 0.014292715, -0.019827018, -0.029575512, -0.0015803224, 0.018405361, -0.002776671, 0.019370057, 0.027569963, -0.008460119, 0.012445833, 0.0028322043, -0.0052804346, 0.006422837, 0.009335961, 0.02260686, 0.02354617, 0.0010345082, 0.018900402, -0.0029908712, -0.0068544107, -0.010148335, -0.007939693, -0.0072796377, 0.020537846, 0.010928977, -0.029880153, -0.0038492593, 0.002795711, -0.01892579, 0.029956313, 0.024612412, -0.00446806, 0.026452947, 0.017605681, 0.041177236, -0.02018243, 0.014648129, 0.021553313, -0.029956313, -0.0015017823, 0.0034874987, 0.034170505, 0.036125284, 0.02805231, 0.018430749, 0.003404992, 0.009329614, 0.020766325, -0.012560072, 0.01707256, 0.011538258, -0.007711212, 0.01332802, -0.007412918, -0.022492621, 0.0059055826, 0.025754813, -0.019141577, -0.01904003, -0.013353407, -0.0026005507, 0.022530701, -0.007895266, -7.842112E-4, 0.028103083, 0.013962688, -0.019979337, -0.02115982, -0.0029305778, 0.01340418, 0.01609517, 0.011880978, -0.016793307, 0.0048837676, -0.013036073, 0.025767507, -0.030337114, 0.017631067, -0.022454541, -0.018824242, 0.0019785764, -0.006146756, 0.0021055099, -0.0014525956, -0.011157458, -0.005293128, -0.011468444, -0.021591393, 0.0051535014, 0.005597769, -2.1935701E-4, -0.012731433, 0.0034208586, 0.024688572, -0.0018103895, 0.001299482, -0.005461315, -0.024878971, -0.030565593, -0.01609517, 0.016717145, -0.013226474, -0.008764761, 0.009488282, -0.007355798, 0.0070638508, -0.005734222, -0.012084072, -0.023749264, 0.028813912, -0.015892077, -0.0033573918, 0.0052201413, -0.01672984, 0.0014105488, -0.02184526, -0.019560456, -0.0063752364, 0.016717145, 0.008777454, 0.00418246, -0.013861141, -0.012877407, 0.009500975, 0.005804036, 0.0013859555, 0.025335932, -0.01779608, 0.01537165, 0.0019722297, -0.011081297, 0.0073875315, 0.0015795291, 0.015968239, 0.013454954, -0.0026592575, 0.0020944031, 0.014140395, -0.0023339903, -0.0042554466, -0.0064989966, 0.0030828982, -0.0046870206, 0.013239168, -0.017491441, -0.011106684, -0.029702445, 0.003696939, 0.007419265, 0.01609517, -0.013784981, -0.017250266, -0.0037762725, 0.021413686, 0.017047172, 0.019268509, 0.006898837, -0.013924608, -0.009266147, -0.0023577902, -0.020905953, -0.005264568, -0.0014875022, 0.0064513967, 0.003044818, 0.0029210579, -0.0073431046, 0.0012431552, -0.0021166166, -0.0019404964, 0.018646536, 7.6913787E-4, 0.01518125, 0.0070194243, 0.0013581888, 0.016374426, -0.00872668, 0.016755225, -4.5418405E-4, -0.0076921717, 0.016780613, -8.56008E-4, -0.02805231, 0.010948017, 9.956349E-5, -0.006108676, -0.011290737, -0.027443029, 0.008910734, 0.012858367, 0.016844079, -0.017592987, 0.01476237, -0.0039793663, 0.008066626, -0.0018421229, -0.018836936, 0.03422128, 0.021020193, 0.016526746, 0.022200674, 0.015397037, -0.0010051549, 0.004474407, 4.6767073E-4, -0.007749292, -0.026249854, 0.009856389, -0.006670357, 0.014775063, -0.02589444, -0.0023530303, -0.0066068904, 0.0067147836, -0.0012542619, -0.018671922, 0.0022498968, -0.017884934, 0.0048552076, 0.0031463648, -0.0217691, 0.029905539, 0.011849245, -0.0026735375, -0.011024177, -0.01733912, 0.0073621445, -0.012407753, 0.0032939252, 0.0072288644, 0.014457729, 0.0011781019, -0.009615215, 0.0141150085, 6.025376E-4, 0.04615303, -0.020804405, 0.031631835, -0.005131288, 0.006594197, -0.025386706, -0.028204631, -0.023482703, 0.026249854, -0.013086847, -0.022314915, -5.2082416E-4, 0.023457317, -0.0076921717, 0.0064989966, -0.006013476, -0.0125029525, -0.0021404168, 0.023977743, -0.0033542186, -0.029423192, 0.0019960299, 0.0076477453, -8.080113E-4, -0.030413274, -0.017047172, -0.008790147, -0.013493034, 0.078089505, -0.004842514, 0.015232024, 0.00825068, 0.036785338, 5.335175E-4, -0.03891782, -0.004680674, -0.005451795, -0.012134845, -0.006746517, 0.009710415, 0.02490436, 0.007101931, 0.026351402, -0.0043093935, -0.0059595294, -0.024561638, 0.019331977, -0.02385081, -0.008206253, 0.016602905, 0.015942851, 0.027138388, -0.01521933, 0.0043728603, 0.025500946, 0.026173694, -0.0011558884, -0.023381157, 0.0016207825, -0.001237602, -0.0049916613, -0.0024085636, -0.015587438, 0.0048203007, 4.35144E-4, -0.012255432, 0.0048742476, -0.0062546497, 0.04051718, -0.008777454, 0.0051090745, -0.016932933, 0.004626727, -0.0016660026, -0.02774767, 0.050976507, -0.03043866, -0.0028655245, 0.01540973, 0.027138388, 0.0023292303, -0.0104275895, -0.004360167, 0.011144764, -0.0066068904, -0.024282385, -0.013988075, 0.016234798, -0.014698903, -0.037673872, -0.0054644886, -7.842112E-4, -0.02589444, -0.020461684, -0.012598153, -0.012363326, -0.002833791, -0.0029274046, -0.01243314, 0.0037413659, -0.012820287, -0.0070511578, 0.017364508, -0.0025545373, -0.0034843255, -0.009773882, -0.0010368882, 0.009894469, 8.330013E-4, -0.008237986, 0.0013804021, 0.0035890455, -0.029194713, 0.022721102, 0.026605267, 0.011151111, 0.0054200618, 0.0043919003, -0.0022181633, -0.0025402573, 0.005093208, -0.015562051, -0.005461315, -0.021984888, -0.016234798, 0.025145533, -0.008422039, -0.0032590183, -0.008130092, 0.0019309763, -0.009278841, 5.981743E-4, 0.04363975, -0.008510893, -0.011360551, -0.025069373, 0.004252273, -0.011132071, 0.020474378, 0.014889303, -0.01896387, 0.0075461986, -0.012096765, 0.030489434, 0.012166579, 0.032393437, 0.0035763523, -0.009018627, -0.007438305, -0.0064196633, 0.025056679, -0.012230045, 0.009488282, -9.821482E-4, 0.0124839125, -0.013239168, -0.0014454556, -0.012744127, -0.003696939, 0.007159051, -0.010402203, 0.010053135, -0.0042808335, -0.0025307373, -0.004128513, 0.010890896, -0.025716733, -0.024155451, -0.04023793, -0.015257411, 0.0129154865, -0.013264554, -0.028636204, -0.023520783, -0.004890114, -0.008022199, -0.016184025, 0.051535014, 0.011792125, 0.009291534, -0.031707995, 0.039476328, 0.004699714, -0.014216555, -0.01480045, -0.0065053436, 0.0044997935, 0.027138388, 0.021705633, -2.0904366E-4, 0.019585844, 0.0036842457, -1.455769E-4, -0.006727477, -0.0108718565, -0.0046076872, -0.0303625, 0.02967706, 0.026554495, 0.014825836, 0.009786575, 0.009285187, -0.020931339, 0.003630299, 0.004693367, -0.008637827, -0.009589829, -0.013886528, 0.017694535, -0.027493803, 0.004982141, 0.0071717445, 0.03297733, -0.007571585, 0.022657635, 0.006276863, 0.016069785, -3.0464047E-4, 0.028636204, -0.014419649, 0.0025450173, -0.010148335, -0.01733912, 0.0104275895, -0.0052804346, -0.015358957, -0.018494215, -3.7068556E-4, 0.027646123, 0.0011114617, 0.005093208, -0.013429567, -0.007920653, 0.0050011813, 0.013543808, -0.014381569, -0.0047346205, -0.026173694, -0.018798856, -0.019674698, -0.012629886, -0.029803993, -0.009862735, -0.0033732585, -0.04130417, 0.013048767, -0.009456548, -0.03815622, -7.286778E-4, -0.0040301397, -0.014254635, -0.0038809928, 0.016666373, -6.6997105E-4, -0.017351814, -0.015549357, 0.02952474, -0.00431574, -0.009818309, -6.470635E-5, 0.011404978, 0.025082065, -0.021908727, -0.018951176, 0.021553313, 0.010148335, -0.022936888, 0.013658048, -0.004671154, 0.0296009, -0.0127949, 0.018341895, 5.6842424E-4, 0.01292818, -0.020931339, 0.0034843255, 0.0036429923, 0.0067401705, -0.030083247, -0.00215311, -0.024206225, 0.02619908, -0.009837349, -0.010256229, 0.008168173, -0.0100340955, -0.013150314, 0.02188334, -0.010935323, 0.008371267, -0.00857436, 0.016399812, -0.0036144322, -0.009697721, 0.013493034, -0.007863532, 0.018100722, 0.019446217, -0.022492621, -0.023495397, 0.0037032857, 0.009380388, 0.027265321, -0.007140011, -0.015193944, -0.017047172, -0.004556914, -0.013632661, -0.0056358487, 0.01040855, 0.0050519546, 0.008155479, -6.9020106E-4, -0.032571144, -0.028230017, 0.0048076073, 0.0060293428, -0.016031705, -0.021781793, -0.020931339, 0.0015866691, -0.0016088824, 0.024752038, -0.0019547765, -0.012369673, 0.015320877, -0.012706046, 0.009082094, -0.010249883, 0.019128883, -0.02543748, 0.0084982, 0.0032970984, 0.012991647, 0.022479929, -0.00893612, -0.02316537, -0.016399812, 0.0012312552, -0.0042840065, 0.018227655, -0.005731049, 0.02604676, 0.005293128, 0.006689397, -0.006305423, -0.018075334, 0.019484296, -0.01783416, -0.0012130085, 0.027265321, -0.015866691, -0.020626698, 0.039882515, 0.008682254, -0.0022546567, -0.029423192, 0.009323268, -0.021553313, 0.035871416, -0.014330796, -0.0145465825, -0.023216143, 0.011531911, -0.0166156, 0.020372832, 0.00641649, -0.013531114, 0.016437892, 0.013124927, 0.019814324, -0.0015136823, 0.016247492, 0.004753661, -0.013823061, 0.007907959, -0.036125284, -0.027113002, -0.009932549, 0.009659641, -0.0044807536, -0.009850042, -0.014191168, 0.009856389, -0.042954307, 0.024701266, -0.01059895, 0.0047885673, 0.011081297, 0.021629473, -0.023571556, 0.006651317, -0.031098714, 0.0058262493, -0.0051249415, -0.013823061, -0.0065180366, 4.0519563E-4, 0.009488282, -0.009792922, -0.0423958, -0.010992444, 0.008739374, 0.002449817, 0.012045992, -0.0068544107, -0.014089622, -0.0070511578, 0.0018310162, 0.014406956, 0.033180423, 0.0052709146, -0.0016802826, -0.012750473, -0.015358957, 0.018329201, -0.005750089, -0.048234742, -0.01771992, 0.009240761, -0.0108718565, 1.789961E-5, -0.015866691, -0.028204631, 0.017669147, -0.01730104, -0.0026529108, -0.022543395, -0.017288346, 0.015193944, 0.007971426, -0.019065415, 0.007857186, -1.0481933E-4, -0.019484296, 0.016488666, 0.007101931, 1.709636E-4, -0.009348654, -0.015866691, 0.0049281945, -0.0059436625, -0.020956725, 0.003538272, 0.0038905127, -0.0016485492, 0.0044141137, 0.01271874, -0.01483853, 0.01245218, 0.0023657237, -0.0037794458, 4.5497736E-4, -0.00882188, 0.015815917, -0.017351814, -0.016767919, -0.005185235, -0.022187982, -0.020626698, 0.018049948, 0.009335961, -0.007685825, 0.02589444, 0.21934114, 0.012007912, -0.005039261, 0.037445392, -4.4307736E-4, 0.031403355, 0.0018468829, 0.0024656837, -0.01722488, 0.013213781, -0.011512871, -0.006594197, 0.0015811158, -0.0035287521, 0.0062419563, -0.0048456877, -0.025120145, -0.023800036, 2.0269697E-4, -0.03554139, 0.01071319, -0.016526746, 8.2110125E-4, -0.017313734, 0.03777542, 0.0019944431, -0.04402055, 0.0065434235, 0.013988075, 0.02442201, -0.018976564, -0.00865052, 0.005873849, 0.0016660026, -0.014419649, 0.013048767, 0.006924224, 0.003865126, 0.0057437425, -0.0038206992, 0.009894469, -0.013163007, 0.017351814, -0.01646328, 0.01733912, 0.02446009, -0.018748082, -0.027239935, 0.0032479118, 0.03653147, -0.015206637, -0.018773468, 0.00643553, 0.010141989, 0.0054200618, 0.009183641, 0.02604676, -0.02025859, -0.019852404, -0.006054729, 0.010630683, 0.009481935, -0.016374426, 9.059881E-4, -0.03005786, 0.009589829, -0.014851223, 0.014280022, -0.003274885, -0.016031705, -0.0014168955, -0.025005905, 1.9089613E-4, 0.022302222, -0.008999587, -0.010097562, 0.024942439, -0.012807593, 0.019547764, 0.034957495, -0.026833748, -3.7683392E-5, -0.0068417173, -0.011182844, -0.016907547, -0.03013402, 0.0041062995, 0.014571969, -0.018951176, -0.02070286, 0.011335164, -0.012725086, -7.8341785E-5, -0.0013653288, 0.017859548, 0.0056802756, -0.006556117, 0.010249883, 0.0033002717, -0.011398631, -0.010954363, -0.055139925, -0.009424815, -0.004959928, -0.028788524, -0.0031241516, 0.0027465243, 0.036810722, 0.0031828582, -0.005543822, -0.0026053106, -2.6973375E-4, 0.017935708, -0.0015406557, 0.0023911104, -0.0026735375, -0.016945627, 0.0035636588, 0.030311726, -0.02396505, 0.018836936, -0.01911619, -0.0029448578, 0.033408906, -0.020550538, -0.01294722, -0.011500178, 0.011988872, 0.025424786, -0.011887325, 0.038587794, -0.003395472, -0.007946039, 0.019966645, -0.033713546, -0.018798856, 0.009615215, 0.018189576, -0.026859134, -0.012223699, 0.024802811, 8.099946E-4, -0.0010448216, 0.006422837, -0.005020221, -0.03554139, 0.012356979, 0.007590625, -0.029956313, -0.018303815, -0.03089562, -0.014521196, -0.017250266, -0.017212186, 0.024917051, -0.020169739, -0.044680603, -0.005658062, -0.013835755, -8.3776127E-4, -0.0028496578, -0.006467263, 0.053007443, -0.011614418, 0.008066626, 0.0056453687, -0.16145945, 0.0091963345, -0.024548944, -0.016425198, 0.015701678, 6.862344E-4, 0.023190755, -0.0074509983, -0.018088028, 0.018875016, 0.010205456, 0.010383163, -0.033028103, 0.0023324036, 0.019052723, 0.016590212, 1.4408938E-4, -0.014406956, 0.02324153, 0.019623924, 0.0383847, 0.002686231, 0.0010852817, -0.0076223584, 0.002762391, 0.030540207, -0.025539026, 0.0037667525, -0.011005137, 0.0017850028, 0.005984916, -0.0029353378, 0.02555172, -0.00855532, 0.010287963, 0.005451795, 1.2544602E-4, -0.0065624635, 0.017808774, 0.03528752, 0.013188394, 0.027925376, -0.0014248289, 0.014889303, -0.009710415, 0.009881775, 0.009342308, -0.0017247093, 0.023596942, -0.004709234, 0.009456548, -0.037369233, 0.016082479, 0.0011963486, 0.00222451, 0.016945627, -0.014165782, 0.0014414889, -0.0058865426, -6.2633766E-4, -0.012274472, -0.011328817, -0.013150314, 0.0020372833, -0.0013026553, -0.0039793663, -0.00635937, -0.01487661, 0.00651169, 0.005984916, -0.0024672705, 0.0026640175, 0.0033669118, 0.0074763848, 6.311968E-5, 0.023444623, -0.017656455, -0.0065243836, 0.021832567, -0.02320345, -0.015092397, 0.034119733, -0.025983294, 0.021324834, -0.015663598, 0.00222451, 0.00417294, 0.014965463, 0.014203862, -0.0074319583, 0.007381185, -0.0035446188, -0.009310574, -0.02562788, 0.018049948, 0.01101783, 0.009050361, 0.010484709, -0.005835769, -0.0036620323, 0.0055565154, -0.021515233, -0.028712364, 0.025564414, 0.016374426, 0.033586614, 0.012407753, 0.027087616, 0.019509684, -0.005166195, -0.020042805, 0.010281616, 0.019903177, 0.025424786, -0.010738577, 0.038816273, -0.014990849, -0.025412092, 0.030464048, -0.009158255, 0.046609994, 7.9095457E-4, 0.0016675893, 0.012921833, -7.2828116E-4, 0.0033288319, -0.10784273, -0.022898808, 0.020563232, 0.020487072, -0.0063117696, -0.005299475, 0.009348654, 0.013442261, -0.014330796, 0.0036620323, -0.0112590045, -0.018075334, -0.015282797, -0.013581888, 0.023723876, 0.00847916, 0.025221692, -0.028686978, -3.8655227E-4, 0.005169368, -7.0765446E-4, 0.011436711, -0.004963101, 0.0067592105, -0.00427766, 0.007527158, -0.008999587, 0.029854767, 0.0072098244, 0.011246311, 0.024218917, -0.009945242, 0.017326428, -0.004052353, -0.011684231, -5.311375E-4, -0.024688572, 0.002335577, 0.01476237, -0.026986068, 0.012801247, -0.0074636918, -0.0023815904, -0.047600072, 0.006886144, -0.004464887, 2.9809546E-4, 0.018684616, 0.022924196, -0.0070575043, -0.0037730993, 0.025830973, -0.029651672, 0.0046140337, 0.041710358, -0.0058960626, 0.016666373, -0.0018706829, -0.009786575, -0.0065878504, 0.0067338236, -0.0011431951, -0.020233205, 0.007971426, 0.008218946, 0.015930157, -0.01105591, -0.0024022171, 0.0051439814, -0.015193944, 0.0120777255, -0.0064989966, -0.016590212, -0.00895516, -0.010116602, -0.038638566, -0.034119733, 0.0056231553, -8.840722E-5, -0.022632249, 0.0019944431, -0.009754842, 0.0074256114, -0.0011773085, -6.7314436E-4, -0.02014435, -0.010186416, -0.0067211306, -0.0074256114, -0.015828611, -0.0043665133, 0.0112526575, 0.031073328, -0.013632661, -0.016932933, 0.018126108, -0.014432343, -0.0021118566, 0.017389894, -0.023635022, -0.0062736897, -0.010116602, -0.040187154, 0.006905184, -0.017884934, -0.0068163304, 0.0087838005, -0.0100340955, 0.016717145, 0.010072175, -0.00832684, 0.017047172, -0.01061799, 0.01268066, 0.0137088215, 0.007926999, -0.01711064, -0.00885996, 0.015422424, 0.0052011013, 0.022327607, -0.0092280675, 0.022251448, 0.0303625, -0.0045251804, -6.5886433E-4, -0.020360138, 0.021870647, -0.013251861, 0.016844079, -0.027595349, -0.01094167, 0.011550951, -0.024612412, 0.0033034452, 0.026072146, -0.014419649, -0.030032473, -0.00411582, 0.012185619, 0.0096215615, 0.002618004, -0.006575157, -0.03675995, 0.010986097, -0.023673104, -0.011900018, 0.0149527695, -0.016044399, -0.0040206197, 0.018722696, 0.0038873393, -0.00825068, 0.011163804, 0.010484709, -0.01919235, 0.015790531, 0.0013692954, 0.0059595294, -0.011836552, 0.005096381, -0.031200262, 0.0358968, -0.009126521, 0.0087838005, -0.009158255, -0.004693367, -0.013619968, -0.016717145, -0.013696128, 0.014711596, -0.029880153, -0.018608455, 0.005166195, 0.019801632, 0.0112526575, 0.03922246, -0.0179484, -0.0069178776, -0.028610818, -0.00832684, 0.010909937, 0.013569194, 0.019839711, -0.024447398, 0.01086551, 0.010294309, 0.024726652, -0.016679065, -0.0013145554, 0.005451795, 0.004617207, -0.004690194, -0.013315327, 0.0112653505, -0.0016009491, 0.003998406, 0.025272466, -0.0030051514, -0.007869879, 0.017935708, 0.031251036, -0.005375635, 0.0046203807, 0.0030099114, -0.0071273176, -0.012020606, -0.016285572, -0.033865865, -0.04290353, 0.009107481, 0.007400225, 0.018253041, 0.016704453, -0.003957153, 0.022644943, 0.0074446513, 0.012122152, -0.0013796088, -0.005835769, -0.019014644, 0.026909908, 0.003035298, 0.012153885, 0.007863532, -0.020499766, 0.006010303, 0.017212186, -0.004026966, 1.3466855E-4, 0.001078935, 0.0051725414, -0.0014906756, 0.009526362, -0.016310958, -0.010357776, -0.0145338895, 0.0070511578, 0.015993625, 0.018748082, -0.025259772, 0.036937658, 0.0044014202, 0.008713987, 0.003931766, -0.007863532, 0.0053597684, 0.02797615, -0.020093577, -0.006286383, 0.004550567, 0.024434704, 0.0076223584, 0.0057437425, -0.0125029525, -0.02619908, -0.0029956312, 3.6632223E-4, 8.51248E-4, -0.028915457, -0.023470009, 0.008675907, 0.018684616, 0.014406956, 0.028204631, -0.014013462, -0.0031527115, 0.0018865496, -0.0033986452, 0.012991647, -0.040974144, 0.002589444, -0.0018516429, -0.049504075, -0.00884092, -0.004541047, -0.0217691, -0.014076929, -0.015473197, 0.004080913, 0.0027211376, -0.031327195, 0.041126464, -0.017656455, -0.018595763, 0.014571969, 0.0104593225, -0.015397037, -0.01938275, -0.0027592175]}]|
    +-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
    """

    name = "OpenAIEmbeddings"

    inputAnnotatorTypes = [AnnotatorType.DOCUMENT]

    outputAnnotatorType = AnnotatorType.SENTENCE_EMBEDDINGS

    model = Param(Params._dummy(),
                  "model",
                  "ID of the OpenAI model to use",
                  typeConverter=TypeConverters.toString)

    user = Param(Params._dummy(),
                 "user",
                 "A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse.",
                 typeConverter=TypeConverters.toString)

    def setModel(self, value):
        """Sets model ID of the OpenAI model to use

        Parameters
        ----------
        value : str
           ID of the OpenAI model to use
        """
        return self._set(model=value)

    def setUser(self, value):
        """Sets a unique identifier representing your end-user

        Parameters
        ----------
        value : str
           A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse.
        """
        return self._set(user=value)

    @keyword_only
    def __init__(self, classname="com.johnsnowlabs.ml.ai.OpenAIEmbeddings", java_model=None):
        super(OpenAIEmbeddings, self).__init__(
            classname=classname,
            java_model=java_model
        )
