"""
Type annotations for workdocs service literal definitions.

[Open documentation](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_workdocs/literals.html)

Usage::

    ```python
    from mypy_boto3_workdocs.literals import ActivityTypeType

    data: ActivityTypeType = "DOCUMENT_ANNOTATION_ADDED"
    ```
"""
import sys

if sys.version_info >= (3, 8):
    from typing import Literal
else:
    from typing_extensions import Literal


__all__ = (
    "ActivityTypeType",
    "BooleanEnumTypeType",
    "CommentStatusTypeType",
    "CommentVisibilityTypeType",
    "DescribeActivitiesPaginatorName",
    "DescribeCommentsPaginatorName",
    "DescribeDocumentVersionsPaginatorName",
    "DescribeFolderContentsPaginatorName",
    "DescribeGroupsPaginatorName",
    "DescribeNotificationSubscriptionsPaginatorName",
    "DescribeResourcePermissionsPaginatorName",
    "DescribeRootFoldersPaginatorName",
    "DescribeUsersPaginatorName",
    "DocumentSourceTypeType",
    "DocumentStatusTypeType",
    "DocumentThumbnailTypeType",
    "DocumentVersionStatusType",
    "FolderContentTypeType",
    "LocaleTypeType",
    "OrderTypeType",
    "PrincipalTypeType",
    "ResourceCollectionTypeType",
    "ResourceSortTypeType",
    "ResourceStateTypeType",
    "ResourceTypeType",
    "RolePermissionTypeType",
    "RoleTypeType",
    "ShareStatusTypeType",
    "StorageTypeType",
    "SubscriptionProtocolTypeType",
    "SubscriptionTypeType",
    "UserFilterTypeType",
    "UserSortTypeType",
    "UserStatusTypeType",
    "UserTypeType",
    "ServiceName",
    "PaginatorName",
)


ActivityTypeType = Literal[
    "DOCUMENT_ANNOTATION_ADDED",
    "DOCUMENT_ANNOTATION_DELETED",
    "DOCUMENT_CHECKED_IN",
    "DOCUMENT_CHECKED_OUT",
    "DOCUMENT_COMMENT_ADDED",
    "DOCUMENT_COMMENT_DELETED",
    "DOCUMENT_MOVED",
    "DOCUMENT_RECYCLED",
    "DOCUMENT_RENAMED",
    "DOCUMENT_RESTORED",
    "DOCUMENT_REVERTED",
    "DOCUMENT_SHAREABLE_LINK_CREATED",
    "DOCUMENT_SHAREABLE_LINK_PERMISSION_CHANGED",
    "DOCUMENT_SHAREABLE_LINK_REMOVED",
    "DOCUMENT_SHARED",
    "DOCUMENT_SHARE_PERMISSION_CHANGED",
    "DOCUMENT_UNSHARED",
    "DOCUMENT_VERSION_DELETED",
    "DOCUMENT_VERSION_DOWNLOADED",
    "DOCUMENT_VERSION_UPLOADED",
    "DOCUMENT_VERSION_VIEWED",
    "FOLDER_CREATED",
    "FOLDER_DELETED",
    "FOLDER_MOVED",
    "FOLDER_RECYCLED",
    "FOLDER_RENAMED",
    "FOLDER_RESTORED",
    "FOLDER_SHAREABLE_LINK_CREATED",
    "FOLDER_SHAREABLE_LINK_PERMISSION_CHANGED",
    "FOLDER_SHAREABLE_LINK_REMOVED",
    "FOLDER_SHARED",
    "FOLDER_SHARE_PERMISSION_CHANGED",
    "FOLDER_UNSHARED",
]
BooleanEnumTypeType = Literal["FALSE", "TRUE"]
CommentStatusTypeType = Literal["DELETED", "DRAFT", "PUBLISHED"]
CommentVisibilityTypeType = Literal["PRIVATE", "PUBLIC"]
DescribeActivitiesPaginatorName = Literal["describe_activities"]
DescribeCommentsPaginatorName = Literal["describe_comments"]
DescribeDocumentVersionsPaginatorName = Literal["describe_document_versions"]
DescribeFolderContentsPaginatorName = Literal["describe_folder_contents"]
DescribeGroupsPaginatorName = Literal["describe_groups"]
DescribeNotificationSubscriptionsPaginatorName = Literal["describe_notification_subscriptions"]
DescribeResourcePermissionsPaginatorName = Literal["describe_resource_permissions"]
DescribeRootFoldersPaginatorName = Literal["describe_root_folders"]
DescribeUsersPaginatorName = Literal["describe_users"]
DocumentSourceTypeType = Literal["ORIGINAL", "WITH_COMMENTS"]
DocumentStatusTypeType = Literal["ACTIVE", "INITIALIZED"]
DocumentThumbnailTypeType = Literal["LARGE", "SMALL", "SMALL_HQ"]
DocumentVersionStatusType = Literal["ACTIVE"]
FolderContentTypeType = Literal["ALL", "DOCUMENT", "FOLDER"]
LocaleTypeType = Literal[
    "de", "default", "en", "es", "fr", "ja", "ko", "pt_BR", "ru", "zh_CN", "zh_TW"
]
OrderTypeType = Literal["ASCENDING", "DESCENDING"]
PrincipalTypeType = Literal["ANONYMOUS", "GROUP", "INVITE", "ORGANIZATION", "USER"]
ResourceCollectionTypeType = Literal["SHARED_WITH_ME"]
ResourceSortTypeType = Literal["DATE", "NAME"]
ResourceStateTypeType = Literal["ACTIVE", "RECYCLED", "RECYCLING", "RESTORING"]
ResourceTypeType = Literal["DOCUMENT", "FOLDER"]
RolePermissionTypeType = Literal["DIRECT", "INHERITED"]
RoleTypeType = Literal["CONTRIBUTOR", "COOWNER", "OWNER", "VIEWER"]
ShareStatusTypeType = Literal["FAILURE", "SUCCESS"]
StorageTypeType = Literal["QUOTA", "UNLIMITED"]
SubscriptionProtocolTypeType = Literal["HTTPS"]
SubscriptionTypeType = Literal["ALL"]
UserFilterTypeType = Literal["ACTIVE_PENDING", "ALL"]
UserSortTypeType = Literal["FULL_NAME", "STORAGE_LIMIT", "STORAGE_USED", "USER_NAME", "USER_STATUS"]
UserStatusTypeType = Literal["ACTIVE", "INACTIVE", "PENDING"]
UserTypeType = Literal["ADMIN", "MINIMALUSER", "POWERUSER", "USER", "WORKSPACESUSER"]
ServiceName = Literal[
    "accessanalyzer",
    "account",
    "acm",
    "acm-pca",
    "alexaforbusiness",
    "amp",
    "amplify",
    "amplifybackend",
    "apigateway",
    "apigatewaymanagementapi",
    "apigatewayv2",
    "appconfig",
    "appflow",
    "appintegrations",
    "application-autoscaling",
    "application-insights",
    "applicationcostprofiler",
    "appmesh",
    "apprunner",
    "appstream",
    "appsync",
    "athena",
    "auditmanager",
    "autoscaling",
    "autoscaling-plans",
    "backup",
    "batch",
    "braket",
    "budgets",
    "ce",
    "chime",
    "chime-sdk-identity",
    "chime-sdk-messaging",
    "cloud9",
    "cloudcontrol",
    "clouddirectory",
    "cloudformation",
    "cloudfront",
    "cloudhsm",
    "cloudhsmv2",
    "cloudsearch",
    "cloudsearchdomain",
    "cloudtrail",
    "cloudwatch",
    "codeartifact",
    "codebuild",
    "codecommit",
    "codedeploy",
    "codeguru-reviewer",
    "codeguruprofiler",
    "codepipeline",
    "codestar",
    "codestar-connections",
    "codestar-notifications",
    "cognito-identity",
    "cognito-idp",
    "cognito-sync",
    "comprehend",
    "comprehendmedical",
    "compute-optimizer",
    "config",
    "connect",
    "connect-contact-lens",
    "connectparticipant",
    "cur",
    "customer-profiles",
    "databrew",
    "dataexchange",
    "datapipeline",
    "datasync",
    "dax",
    "detective",
    "devicefarm",
    "devops-guru",
    "directconnect",
    "discovery",
    "dlm",
    "dms",
    "docdb",
    "ds",
    "dynamodb",
    "dynamodbstreams",
    "ebs",
    "ec2",
    "ec2-instance-connect",
    "ecr",
    "ecr-public",
    "ecs",
    "efs",
    "eks",
    "elastic-inference",
    "elasticache",
    "elasticbeanstalk",
    "elastictranscoder",
    "elb",
    "elbv2",
    "emr",
    "emr-containers",
    "es",
    "events",
    "finspace",
    "finspace-data",
    "firehose",
    "fis",
    "fms",
    "forecast",
    "forecastquery",
    "frauddetector",
    "fsx",
    "gamelift",
    "glacier",
    "globalaccelerator",
    "glue",
    "grafana",
    "greengrass",
    "greengrassv2",
    "groundstation",
    "guardduty",
    "health",
    "healthlake",
    "honeycode",
    "iam",
    "identitystore",
    "imagebuilder",
    "importexport",
    "inspector",
    "iot",
    "iot-data",
    "iot-jobs-data",
    "iot1click-devices",
    "iot1click-projects",
    "iotanalytics",
    "iotdeviceadvisor",
    "iotevents",
    "iotevents-data",
    "iotfleethub",
    "iotsecuretunneling",
    "iotsitewise",
    "iotthingsgraph",
    "iotwireless",
    "ivs",
    "kafka",
    "kafkaconnect",
    "kendra",
    "kinesis",
    "kinesis-video-archived-media",
    "kinesis-video-media",
    "kinesis-video-signaling",
    "kinesisanalytics",
    "kinesisanalyticsv2",
    "kinesisvideo",
    "kms",
    "lakeformation",
    "lambda",
    "lex-models",
    "lex-runtime",
    "lexv2-models",
    "lexv2-runtime",
    "license-manager",
    "lightsail",
    "location",
    "logs",
    "lookoutequipment",
    "lookoutmetrics",
    "lookoutvision",
    "machinelearning",
    "macie",
    "macie2",
    "managedblockchain",
    "marketplace-catalog",
    "marketplace-entitlement",
    "marketplacecommerceanalytics",
    "mediaconnect",
    "mediaconvert",
    "medialive",
    "mediapackage",
    "mediapackage-vod",
    "mediastore",
    "mediastore-data",
    "mediatailor",
    "memorydb",
    "meteringmarketplace",
    "mgh",
    "mgn",
    "migrationhub-config",
    "mobile",
    "mq",
    "mturk",
    "mwaa",
    "neptune",
    "network-firewall",
    "networkmanager",
    "nimble",
    "opensearch",
    "opsworks",
    "opsworkscm",
    "organizations",
    "outposts",
    "personalize",
    "personalize-events",
    "personalize-runtime",
    "pi",
    "pinpoint",
    "pinpoint-email",
    "pinpoint-sms-voice",
    "polly",
    "pricing",
    "proton",
    "qldb",
    "qldb-session",
    "quicksight",
    "ram",
    "rds",
    "rds-data",
    "redshift",
    "redshift-data",
    "rekognition",
    "resource-groups",
    "resourcegroupstaggingapi",
    "robomaker",
    "route53",
    "route53-recovery-cluster",
    "route53-recovery-control-config",
    "route53-recovery-readiness",
    "route53domains",
    "route53resolver",
    "s3",
    "s3control",
    "s3outposts",
    "sagemaker",
    "sagemaker-a2i-runtime",
    "sagemaker-edge",
    "sagemaker-featurestore-runtime",
    "sagemaker-runtime",
    "savingsplans",
    "schemas",
    "sdb",
    "secretsmanager",
    "securityhub",
    "serverlessrepo",
    "service-quotas",
    "servicecatalog",
    "servicecatalog-appregistry",
    "servicediscovery",
    "ses",
    "sesv2",
    "shield",
    "signer",
    "sms",
    "sms-voice",
    "snow-device-management",
    "snowball",
    "sns",
    "sqs",
    "ssm",
    "ssm-contacts",
    "ssm-incidents",
    "sso",
    "sso-admin",
    "sso-oidc",
    "stepfunctions",
    "storagegateway",
    "sts",
    "support",
    "swf",
    "synthetics",
    "textract",
    "timestream-query",
    "timestream-write",
    "transcribe",
    "transfer",
    "translate",
    "voice-id",
    "waf",
    "waf-regional",
    "wafv2",
    "wellarchitected",
    "wisdom",
    "workdocs",
    "worklink",
    "workmail",
    "workmailmessageflow",
    "workspaces",
    "xray",
]
PaginatorName = Literal[
    "describe_activities",
    "describe_comments",
    "describe_document_versions",
    "describe_folder_contents",
    "describe_groups",
    "describe_notification_subscriptions",
    "describe_resource_permissions",
    "describe_root_folders",
    "describe_users",
]
