#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['apidaora', 'apidaora.core', 'apidaora.openapi']

package_data = \
{'': ['*'],
 'apidaora.core': ['tests/*'],
 'apidaora.openapi': ['path_decorator/*',
                      'path_decorator/factories/*',
                      'tests/*']}

install_requires = \
['jsondaora']

extras_require = \
{'doc': ['mkdocs', 'mkdocs-material', 'markdown-include'],
 'test': ['asgi-testclient',
          'bumpversion',
          'black',
          'flake8',
          'isort',
          'ipython',
          'mypy',
          'pytest-asyncio',
          'pytest-cov',
          'pytest-mock',
          'pytest>=5.1.1',
          'tox',
          'towncrier',
          'uvicorn']}

setup(name='apidaora',
      version='0.6.0a4',
      description='ASGI App using dataclasses module for request/response objects',
      author='Diogo Dutra',
      author_email='diogodutradamata@gmail.com',
      url='https://github.com/dutradda/apidaora',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.8',
     )
