/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.io.VelocityWriter;
import org.apache.velocity.tools.generic.log.LogSystemCommonsLog;
import org.apache.velocity.tools.view.ToolboxManager;
import org.apache.velocity.tools.view.context.ChainedContext;
import org.apache.velocity.tools.view.servlet.ServletToolboxManager;
import org.apache.velocity.tools.view.servlet.ServletUtils;
import org.apache.velocity.util.SimplePool;

public class VelocityViewServlet
extends HttpServlet {
    private static final long serialVersionUID = -3329444102562079189L;
    public static final String CONTENT_TYPE = "default.contentType";
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    public static final String DEFAULT_OUTPUT_ENCODING = "ISO-8859-1";
    public static final String SERVLET_CONTEXT_KEY = ServletContext.class.getName();
    public static final String DEFAULT_TOOLS_PROPERTIES = "/org/apache/velocity/tools/view/servlet/velocity.properties";
    protected static final String TOOLBOX_KEY = "org.apache.velocity.toolbox";
    protected static final String INIT_PROPS_KEY = "org.apache.velocity.properties";
    protected static final String DEFAULT_TOOLBOX_PATH = "/WEB-INF/toolbox.xml";
    protected static final String DEFAULT_PROPERTIES_PATH = "/WEB-INF/velocity.properties";
    protected ToolboxManager toolboxManager = null;
    private static SimplePool writerPool = new SimplePool(40);
    private VelocityEngine velocity = null;
    private String defaultContentType;
    private boolean warnOfOutputStreamDeprecation = true;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.initVelocity(config);
        this.initToolbox(config);
        this.defaultContentType = this.getVelocityProperty(CONTENT_TYPE, DEFAULT_CONTENT_TYPE);
        String encoding = this.getVelocityProperty("output.encoding", DEFAULT_OUTPUT_ENCODING);
        if (!DEFAULT_OUTPUT_ENCODING.equalsIgnoreCase(encoding)) {
            int index = this.defaultContentType.lastIndexOf("charset");
            if (index < 0) {
                this.defaultContentType = this.defaultContentType + "; charset=" + encoding;
            } else {
                this.velocity.warn("VelocityViewServlet: Charset was already specified in the Content-Type property.  Output encoding property will be ignored.");
            }
        }
        this.velocity.info("VelocityViewServlet: Default content-type is: " + this.defaultContentType);
    }

    protected String findInitParameter(ServletConfig config, String key) {
        String param = config.getInitParameter(key);
        if (param == null || param.length() == 0) {
            ServletContext servletContext = config.getServletContext();
            param = servletContext.getInitParameter(key);
        }
        return param;
    }

    protected String getVelocityProperty(String key, String alternate) {
        String prop = (String)this.velocity.getProperty(key);
        if (prop == null || prop.length() == 0) {
            return alternate;
        }
        return prop;
    }

    protected VelocityEngine getVelocityEngine() {
        return this.velocity;
    }

    protected void setVelocityEngine(VelocityEngine ve) {
        if (ve == null) {
            throw new NullPointerException("Cannot set the VelocityEngine to null");
        }
        this.velocity = ve;
    }

    protected void initToolbox(ServletConfig config) throws ServletException {
        String file = this.findInitParameter(config, TOOLBOX_KEY);
        if (file == null) {
            file = DEFAULT_TOOLBOX_PATH;
            this.velocity.debug("VelocityViewServlet: No toolbox entry in configuration. Looking for '/WEB-INF/toolbox.xml'");
        }
        this.toolboxManager = ServletToolboxManager.getInstance(this.getServletContext(), file);
    }

    protected void initVelocity(ServletConfig config) throws ServletException {
        this.velocity = new VelocityEngine();
        this.setVelocityEngine(this.velocity);
        LogSystemCommonsLog.setVelocityEngine(this.velocity);
        this.velocity.setApplicationAttribute(SERVLET_CONTEXT_KEY, this.getServletContext());
        try {
            ExtendedProperties defaultProperties = this.loadDefaultProperties();
            this.velocity.setExtendedProperties(defaultProperties);
        }
        catch (Exception e) {
            this.log("VelocityViewServlet: Unable to read Velocity Servlet configuration file: ", e);
            throw new ServletException((Throwable)e);
        }
        try {
            ExtendedProperties p = this.loadConfiguration(config);
            this.velocity.setExtendedProperties(p);
        }
        catch (Exception e) {
            this.log("VelocityViewServlet: Unable to read Velocity configuration file: ", e);
            this.log("VelocityViewServlet: Using default Velocity configuration.");
        }
        try {
            this.velocity.init();
        }
        catch (Exception e) {
            this.log("VelocityViewServlet: PANIC! unable to init()", e);
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtendedProperties loadDefaultProperties() {
        InputStream inputStream = null;
        ExtendedProperties defaultProperties = new ExtendedProperties();
        try {
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(DEFAULT_TOOLS_PROPERTIES);
            if (inputStream != null) {
                defaultProperties.load(inputStream);
            }
        }
        catch (IOException ioe) {
            this.log("Cannot load default extendedProperties!", ioe);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ioe) {
                this.log("Cannot close default extendedProperties!", ioe);
            }
        }
        return defaultProperties;
    }

    protected ExtendedProperties loadConfiguration(ServletConfig config) throws IOException {
        String propsFile = this.findInitParameter(config, INIT_PROPS_KEY);
        if (propsFile == null) {
            propsFile = DEFAULT_PROPERTIES_PATH;
            this.velocity.debug("VelocityViewServlet: Looking for custom properties at '/WEB-INF/velocity.properties'");
        }
        ExtendedProperties p = new ExtendedProperties();
        InputStream is = this.getServletContext().getResourceAsStream(propsFile);
        if (is != null) {
            p.load(is);
            this.velocity.info("VelocityViewServlet: Using custom properties at '" + propsFile + "'");
        } else {
            this.velocity.debug("VelocityViewServlet: No custom properties found. Using default Velocity configuration.");
        }
        return p;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Context context = null;
        try {
            context = this.createContext(request, response);
            this.fillContext(context, request);
            this.setContentType(request, response);
            Template template = this.handleRequest(request, response, context);
            if (template == null) {
                this.velocity.warn("VelocityViewServlet: couldn't find template to match request.");
                return;
            }
            this.mergeTemplate(template, context, response);
        }
        catch (Exception e) {
            this.velocity.error("VelocityViewServlet: Exception processing the template: " + e);
            this.error(request, response, e);
        }
        finally {
            this.requestCleanup(request, response, context);
        }
    }

    protected Template handleRequest(HttpServletRequest request, HttpServletResponse response, Context ctx) throws Exception {
        return this.getTemplate(request, response);
    }

    protected Context createContext(HttpServletRequest request, HttpServletResponse response) {
        ChainedContext ctx = new ChainedContext(this.velocity, request, response, this.getServletContext());
        if (this.toolboxManager != null) {
            ctx.setToolbox(this.toolboxManager.getToolbox(ctx));
        }
        return ctx;
    }

    protected void fillContext(Context context, HttpServletRequest request) {
    }

    protected void setContentType(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType(this.defaultContentType);
    }

    protected Template getTemplate(HttpServletRequest request) throws ResourceNotFoundException, ParseErrorException, Exception {
        return this.getTemplate(request, null);
    }

    protected Template getTemplate(HttpServletRequest request, HttpServletResponse response) throws ResourceNotFoundException, ParseErrorException, Exception {
        String path = ServletUtils.getPath(request);
        if (response == null) {
            return this.getTemplate(path);
        }
        return this.getTemplate(path, response.getCharacterEncoding());
    }

    public Template getTemplate(String name) throws ResourceNotFoundException, ParseErrorException, Exception {
        return this.getTemplate(name, null);
    }

    public Template getTemplate(String name, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        if (encoding == null) {
            return this.getVelocityEngine().getTemplate(name);
        }
        return this.getVelocityEngine().getTemplate(name, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeTemplate(Template template, Context context, HttpServletResponse response) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, IOException, UnsupportedEncodingException, Exception {
        VelocityWriter vw = null;
        Writer writer = this.getResponseWriter(response);
        try {
            vw = (VelocityWriter)writerPool.get();
            if (vw == null) {
                vw = new VelocityWriter(writer, 4096, true);
            } else {
                vw.recycle(writer);
            }
            this.performMerge(template, context, vw);
        }
        finally {
            if (vw != null) {
                try {
                    vw.flush();
                    vw.recycle(null);
                    writerPool.put(vw);
                }
                catch (Exception e) {
                    this.velocity.debug("VelocityViewServlet: Trouble releasing VelocityWriter: " + e.getMessage());
                }
            }
        }
    }

    protected void performMerge(Template template, Context context, Writer writer) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, Exception {
        template.merge(context, writer);
    }

    protected void error(HttpServletRequest request, HttpServletResponse response, Exception e) throws ServletException {
        try {
            StringBuffer html = new StringBuffer();
            html.append("<html>\n");
            html.append("<head><title>Error</title></head>\n");
            html.append("<body>\n");
            html.append("<h2>VelocityViewServlet : Error processing a template for path '");
            html.append(ServletUtils.getPath(request));
            html.append("'</h2>\n");
            Throwable cause = e;
            String why = cause.getMessage();
            if (why != null && why.trim().length() > 0) {
                html.append(StringEscapeUtils.escapeHtml(why));
                html.append("\n<br>\n");
            }
            if (cause instanceof MethodInvocationException) {
                cause = ((MethodInvocationException)cause).getWrappedThrowable();
            }
            StringWriter sw = new StringWriter();
            cause.printStackTrace(new PrintWriter(sw));
            html.append("<pre>\n");
            html.append(StringEscapeUtils.escapeHtml(sw.toString()));
            html.append("</pre>\n");
            html.append("</body>\n");
            html.append("</html>");
            this.getResponseWriter(response).write(html.toString());
        }
        catch (Exception e2) {
            this.velocity.error("VelocityViewServlet: Exception while printing error screen: " + e2);
            throw new ServletException((Throwable)e);
        }
    }

    protected Writer getResponseWriter(HttpServletResponse response) throws UnsupportedEncodingException, IOException {
        Writer writer = null;
        try {
            writer = response.getWriter();
        }
        catch (IllegalStateException e) {
            String encoding;
            if (this.warnOfOutputStreamDeprecation) {
                this.warnOfOutputStreamDeprecation = false;
                this.velocity.warn("VelocityViewServlet: Use of ServletResponse's getOutputStream() method with VelocityViewServlet is deprecated -- support will be removed in an upcoming release");
            }
            if ((encoding = response.getCharacterEncoding()) == null) {
                encoding = DEFAULT_OUTPUT_ENCODING;
            }
            writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), encoding);
        }
        return writer;
    }

    protected void requestCleanup(HttpServletRequest request, HttpServletResponse response, Context context) {
    }
}

