from __future__ import annotations

from collections.abc import Mapping
from typing import Any, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

T = TypeVar("T", bound="Image")


@_attrs_define
class Image:
    """
    Attributes:
        url (str):  Example: https://lh3.googleusercontent.com/proxy/IPr6keWrYy7JmdkUpFwyZB2Ev7OJg3oWLlqKlht7r5YGu2lPkEs
            iDUiHDkAbcrgLkh9zlPELDvQ-4Qa8F0hBYn2bjw3qlA5RvgwR-tW8ayfG1gfVrUxC6K3Oba0WR1g7cjh3D4eRQPkChlatag.
    """

    url: str
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        url = self.url

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "url": url,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        url = d.pop("url")

        image = cls(
            url=url,
        )

        image.additional_properties = d
        return image

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
