from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Any, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.check_in_out_result_scanning_messages_item import CheckInOutResultScanningMessagesItem


T = TypeVar("T", bound="CheckInOutResult")


@_attrs_define
class CheckInOutResult:
    """
    Attributes:
        scanning_messages (list[CheckInOutResultScanningMessagesItem]):
    """

    scanning_messages: list[CheckInOutResultScanningMessagesItem]
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        scanning_messages = []
        for scanning_messages_item_data in self.scanning_messages:
            scanning_messages_item = scanning_messages_item_data.to_dict()
            scanning_messages.append(scanning_messages_item)

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "scanningMessages": scanning_messages,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        from ..models.check_in_out_result_scanning_messages_item import CheckInOutResultScanningMessagesItem

        d = dict(src_dict)
        scanning_messages = []
        _scanning_messages = d.pop("scanningMessages")
        for scanning_messages_item_data in _scanning_messages:
            scanning_messages_item = CheckInOutResultScanningMessagesItem.from_dict(scanning_messages_item_data)

            scanning_messages.append(scanning_messages_item)

        check_in_out_result = cls(
            scanning_messages=scanning_messages,
        )

        check_in_out_result.additional_properties = d
        return check_in_out_result

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
