/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Map;
import java.util.function.Consumer;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.Util;

public class DefaultSocketFactory
implements SocketFactory {
    private final javax.net.SocketFactory socketFactory;
    private final ServerSocketFactory serverSocketFactory;
    private Consumer<Socket> socketConfigurator;
    private Consumer<ServerSocket> serverSocketConfigurator;

    public DefaultSocketFactory() {
        this(javax.net.SocketFactory.getDefault(), ServerSocketFactory.getDefault());
    }

    public DefaultSocketFactory(SSLContext sslContext) {
        this.socketConfigurator = s2 -> {};
        this.serverSocketConfigurator = s2 -> {};
        this.socketFactory = sslContext.getSocketFactory();
        this.serverSocketFactory = sslContext.getServerSocketFactory();
    }

    public DefaultSocketFactory(javax.net.SocketFactory socketFactory, ServerSocketFactory serverSocketFactory) {
        this.socketConfigurator = s2 -> {};
        this.serverSocketConfigurator = s2 -> {};
        this.socketFactory = socketFactory;
        this.serverSocketFactory = serverSocketFactory;
    }

    public void setSocketConfigurator(Consumer<Socket> socketConfigurator) {
        this.socketConfigurator = socketConfigurator;
    }

    public void setServerSocketConfigurator(Consumer<ServerSocket> serverSocketConfigurator) {
        this.serverSocketConfigurator = serverSocketConfigurator;
    }

    private Socket configureSocket(Socket socket) {
        this.socketConfigurator.accept(socket);
        return socket;
    }

    private ServerSocket configureSocket(ServerSocket socket) {
        this.serverSocketConfigurator.accept(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String s2) throws IOException {
        return this.configureSocket(this.socketFactory.createSocket());
    }

    @Override
    public Socket createSocket(String s2, String host, int port) throws IOException {
        return this.configureSocket(this.socketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String s2, InetAddress host, int port) throws IOException {
        return this.configureSocket(this.socketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String s2, String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.configureSocket(this.socketFactory.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(String s2, InetAddress host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.configureSocket(this.socketFactory.createSocket(host, port, localHost, localPort));
    }

    @Override
    public ServerSocket createServerSocket(String s2) throws IOException {
        return this.configureSocket(this.serverSocketFactory.createServerSocket());
    }

    @Override
    public ServerSocket createServerSocket(String s2, int port) throws IOException {
        return this.configureSocket(this.serverSocketFactory.createServerSocket(port));
    }

    @Override
    public ServerSocket createServerSocket(String s2, int port, int backlog) throws IOException {
        return this.configureSocket(this.serverSocketFactory.createServerSocket(port, backlog));
    }

    @Override
    public ServerSocket createServerSocket(String s2, int port, int backlog, InetAddress bindAddress) throws IOException {
        return this.configureSocket(this.serverSocketFactory.createServerSocket(port, backlog, bindAddress));
    }

    @Override
    public DatagramSocket createDatagramSocket(String service_name) throws SocketException {
        return new DatagramSocket();
    }

    @Override
    public DatagramSocket createDatagramSocket(String service_name, SocketAddress bindaddr) throws SocketException {
        return new DatagramSocket(bindaddr);
    }

    @Override
    public DatagramSocket createDatagramSocket(String service_name, int port) throws SocketException {
        return new DatagramSocket(port);
    }

    @Override
    public DatagramSocket createDatagramSocket(String service_name, int port, InetAddress laddr) throws SocketException {
        return new DatagramSocket(port, laddr);
    }

    @Override
    public MulticastSocket createMulticastSocket(String service_name) throws IOException {
        return new MulticastSocket();
    }

    @Override
    public MulticastSocket createMulticastSocket(String service_name, int port) throws IOException {
        return new MulticastSocket(port);
    }

    @Override
    public MulticastSocket createMulticastSocket(String service_name, SocketAddress bindaddr) throws IOException {
        return new MulticastSocket(bindaddr);
    }

    @Override
    public void close(Socket socket) throws IOException {
        Util.close((Closeable)socket);
    }

    @Override
    public void close(ServerSocket serverSocket) throws IOException {
        Util.close((Closeable)serverSocket);
    }

    @Override
    public void close(DatagramSocket datagramSocket) {
        Util.close((Closeable)datagramSocket);
    }

    @Override
    public Map<Object, String> getSockets() {
        return null;
    }
}

