/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.lang.invoke.MethodHandles;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.core.MarshallableFunctions;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.reactive.RxJavaInterop;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManager;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.InnerPublisherSubscription;
import org.infinispan.reactive.publisher.impl.LocalClusterPublisherManagerImpl;
import org.infinispan.reactive.publisher.impl.LocalPublisherManager;
import org.infinispan.reactive.publisher.impl.LocalPublisherManagerImpl;
import org.infinispan.reactive.publisher.impl.ModifiedValueFunction;
import org.infinispan.reactive.publisher.impl.PublisherHandler;
import org.infinispan.reactive.publisher.impl.SegmentAwarePublisher;
import org.infinispan.reactive.publisher.impl.SegmentCompletionPublisher;
import org.infinispan.reactive.publisher.impl.commands.batch.CancelPublisherCommand;
import org.infinispan.reactive.publisher.impl.commands.batch.InitialPublisherCommand;
import org.infinispan.reactive.publisher.impl.commands.batch.NextPublisherCommand;
import org.infinispan.reactive.publisher.impl.commands.batch.PublisherResponse;
import org.infinispan.reactive.publisher.impl.commands.reduction.KeyPublisherResult;
import org.infinispan.reactive.publisher.impl.commands.reduction.PublisherResult;
import org.infinispan.reactive.publisher.impl.commands.reduction.ReductionPublisherRequestCommand;
import org.infinispan.reactive.publisher.impl.commands.reduction.SegmentPublisherResult;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ValidResponseCollector;
import org.infinispan.remoting.transport.impl.SingleResponseCollector;
import org.infinispan.remoting.transport.impl.VoidResponseCollector;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

@Scope(value=Scopes.NAMED_CACHE)
public class ClusterPublisherManagerImpl<K, V>
implements ClusterPublisherManager<K, V> {
    protected static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Inject
    PublisherHandler publisherHandler;
    @Inject
    LocalPublisherManager<K, V> localPublisherManager;
    @Inject
    DistributionManager distributionManager;
    @Inject
    StateTransferLock stateTransferLock;
    @Inject
    RpcManager rpcManager;
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    KeyPartitioner keyPartitioner;
    @Inject
    Configuration cacheConfiguration;
    @Inject
    ComponentRegistry componentRegistry;
    @Inject
    PersistenceManager persistenceManager;
    private final KeyComposedType KEY_COMPOSED = new KeyComposedType();
    private final EntryComposedType ENTRY_COMPOSED = new EntryComposedType();
    private int maxSegment;
    private volatile boolean writeBehindShared;
    private final PersistenceManager.StoreChangeListener storeChangeListener = pm -> {
        this.writeBehindShared = pm.usingSharedAsyncStore();
    };
    protected RpcOptions rpcOptions;
    private static final AtomicInteger requestCounter = new AtomicInteger();
    private static final Function<ValidResponse, PublisherResponse> responseHandler = vr -> {
        if (vr instanceof SuccessfulResponse) {
            return (PublisherResponse)vr.getResponseValue();
        }
        throw new IllegalArgumentException("Unsupported response received: " + vr);
    };
    private static final int MAX_INNER_SUBSCRIBERS = 4;

    private <R> KeyComposedType<R> keyComposedType() {
        return this.KEY_COMPOSED;
    }

    private <R> EntryComposedType<R> entryComposedType() {
        return this.ENTRY_COMPOSED;
    }

    @Start
    public void start() {
        this.maxSegment = this.cacheConfiguration.clustering().hash().numSegments();
        this.writeBehindShared = this.hasWriteBehindSharedStore(this.cacheConfiguration.persistence());
        this.persistenceManager.addStoreListener(this.storeChangeListener);
        this.rpcOptions = new RpcOptions(DeliverOrder.NONE, this.cacheConfiguration.clustering().remoteTimeout() * 3L, TimeUnit.MILLISECONDS);
        this.cacheConfiguration.clustering().attributes().attribute(ClusteringConfiguration.REMOTE_TIMEOUT).addListener((a, ignored) -> {
            this.rpcOptions = new RpcOptions(DeliverOrder.NONE, (Long)a.get() * 3L, TimeUnit.MILLISECONDS);
        });
    }

    @Stop
    public void stop() {
        this.persistenceManager.removeStoreListener(this.storeChangeListener);
    }

    @Override
    public <R> CompletionStage<R> keyReduction(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, InvocationContext ctx, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<K>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        return this.reduction(parallelPublisher, segments, keysToInclude, ctx, includeLoader, deliveryGuarantee, this.keyComposedType(), transformer, finalizer);
    }

    @Override
    public <R> CompletionStage<R> entryReduction(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, InvocationContext ctx, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<CacheEntry<K, V>>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        return this.reduction(parallelPublisher, segments, keysToInclude, ctx, includeLoader, deliveryGuarantee, this.entryComposedType(), transformer, finalizer);
    }

    private <I, R> CompletionStage<R> reduction(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, InvocationContext ctx, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, ComposedType<K, I, R> composedType, Function<? super Publisher<I>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        Function<Publisher<CompletionStage<R>>, CompletionStage<CompletionStage<R>>> finalizerToUse;
        FlowableProcessor flowableProcessor = UnicastProcessor.create().toSerialized();
        CompletionStage<R> stage = finalizer.apply(flowableProcessor);
        Function<Publisher<CompletionStage<Object>>, CompletionStage<CompletionStage<R>>> function = finalizerToUse = this.requiresFinalizer(parallelPublisher, keysToInclude, deliveryGuarantee) ? finalizer : null;
        if (keysToInclude != null) {
            this.startKeyPublisher(parallelPublisher, segments, keysToInclude, ctx, includeLoader, deliveryGuarantee, composedType, transformer, finalizerToUse, flowableProcessor);
        } else {
            this.startSegmentPublisher(parallelPublisher, segments, ctx, includeLoader, deliveryGuarantee, composedType, transformer, finalizerToUse, flowableProcessor);
        }
        return stage;
    }

    private <R> boolean requiresFinalizer(boolean parallelPublisher, Set<K> keysToInclude, DeliveryGuarantee deliveryGuarantee) {
        return parallelPublisher || keysToInclude == null && deliveryGuarantee == DeliveryGuarantee.EXACTLY_ONCE;
    }

    private <I, R> void handleContextInvocation(IntSet segments, Set<K> keysToInclude, InvocationContext ctx, ComposedType<K, I, R> composedType, Function<? super Publisher<I>, ? extends CompletionStage<R>> transformer, BiConsumer<PublisherResult<R>, Throwable> biConsumer) {
        CompletionStage<PublisherResult<R>> localStage = composedType.contextInvocation(segments, keysToInclude, ctx, transformer);
        if (log.isTraceEnabled()) {
            localStage = localStage.whenComplete((results, t) -> {
                if (t != null) {
                    log.tracef((Throwable)t, "Received exception while processing context %s", (Object)ctx);
                } else {
                    log.tracef("Result was: %s for context %s", results.getResult(), (Object)ctx);
                }
            });
        }
        localStage.whenComplete(biConsumer);
    }

    private static <I, R> void handleNoTargets(Function<? super Publisher<I>, ? extends CompletionStage<R>> transformer, FlowableProcessor<R> flowableProcessor) {
        CompletionStage<R> transformedStage = transformer.apply(Flowable.empty());
        transformedStage.whenComplete((value, t) -> {
            if (t != null) {
                flowableProcessor.onError((Throwable)t);
            } else {
                if (value != null) {
                    flowableProcessor.onNext(value);
                }
                flowableProcessor.onComplete();
            }
        });
    }

    private <I, R> void startKeyPublisher(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, InvocationContext ctx, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, ComposedType<K, I, R> composedType, Function<? super Publisher<I>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer, FlowableProcessor<R> flowableProcessor) {
        Address localAddress;
        LocalizedCacheTopology topology = this.distributionManager.getCacheTopology();
        Map<Address, Set<K>> keyTargets = this.determineKeyTargets(topology, keysToInclude, localAddress = topology.getLocalAddress(), segments, ctx);
        int keyTargetSize = keyTargets.size();
        if (keyTargetSize == 0) {
            ClusterPublisherManagerImpl.handleNoTargets(transformer, flowableProcessor);
            return;
        }
        boolean useContext = ctx != null && ctx.lookedUpEntriesCount() > 0;
        AtomicInteger parallelCount = useContext ? new AtomicInteger(keyTargetSize + 1) : new AtomicInteger(keyTargetSize);
        KeyBiConsumer<I, R> biConsumer = new KeyBiConsumer<I, R>(flowableProcessor, parallelCount, topology.getTopologyId(), parallelPublisher, includeLoader, deliveryGuarantee, composedType, transformer, finalizer);
        Set localKeys = keyTargets.remove(localAddress);
        if (!keyTargets.isEmpty()) {
            for (Map.Entry<Address, Set<K>> remoteTarget : keyTargets.entrySet()) {
                Address remoteAddress = remoteTarget.getKey();
                Set<K> remoteKeys = remoteTarget.getValue();
                ReductionPublisherRequestCommand<K> command = composedType.remoteInvocation(parallelPublisher, null, remoteKeys, null, includeLoader, deliveryGuarantee, transformer, finalizer);
                command.setTopologyId(topology.getTopologyId());
                CompletionStage stage = this.rpcManager.invokeCommand(remoteAddress, command, new KeyPublisherResultCollector(remoteKeys), this.rpcManager.getSyncRpcOptions());
                stage.whenComplete(biConsumer);
            }
        }
        if (localKeys != null) {
            CompletionStage<PublisherResult<R>> localStage = composedType.localInvocation(parallelPublisher, null, localKeys, null, includeLoader, deliveryGuarantee, transformer, finalizer);
            if (log.isTraceEnabled()) {
                localStage = localStage.whenComplete((results, t) -> {
                    if (t != null) {
                        log.tracef((Throwable)t, "Received exception while processing keys %s from %s", (Object)localKeys, (Object)localAddress);
                    } else {
                        log.tracef("Result was: %s for keys %s from %s with %s suspected keys", results.getResult(), localKeys, localAddress, results.getSuspectedKeys());
                    }
                });
            }
            localStage.whenComplete(biConsumer);
        }
        if (useContext) {
            this.handleContextInvocation(segments, keysToInclude, ctx, composedType, transformer, biConsumer);
        }
    }

    private <I, R> void startSegmentPublisher(boolean parallelPublisher, IntSet segments, InvocationContext ctx, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, ComposedType<K, I, R> composedType, Function<? super Publisher<I>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer, FlowableProcessor<R> flowableProcessor) {
        Map<Object, Object> keysToExcludeByAddress;
        AtomicInteger parallelCount;
        boolean useContext;
        Address localAddress;
        LocalizedCacheTopology topology = this.distributionManager.getCacheTopology();
        Map<Address, IntSet> targets = this.determineSegmentTargets(topology, segments, localAddress = topology.getLocalAddress());
        int targetSize = targets.size();
        if (targetSize == 0) {
            ClusterPublisherManagerImpl.handleNoTargets(transformer, flowableProcessor);
            return;
        }
        boolean bl = useContext = ctx != null && ctx.lookedUpEntriesCount() > 0;
        if (useContext) {
            parallelCount = new AtomicInteger(targetSize + 1);
            keysToExcludeByAddress = this.determineKeyTargets(topology, ctx.getLookedUpEntries().keySet(), localAddress, segments, null);
        } else {
            parallelCount = new AtomicInteger(targetSize);
            keysToExcludeByAddress = Collections.emptyMap();
        }
        SegmentSpecificConsumer<I, R> biConsumer = new SegmentSpecificConsumer<I, R>(flowableProcessor, parallelCount, topology.getTopologyId(), parallelPublisher, ctx, includeLoader, deliveryGuarantee, composedType, transformer, finalizer);
        IntSet localSegments = targets.remove(localAddress);
        if (!targets.isEmpty()) {
            for (Map.Entry<Address, IntSet> remoteTarget : targets.entrySet()) {
                Address remoteAddress = remoteTarget.getKey();
                IntSet remoteSegments = remoteTarget.getValue();
                ReductionPublisherRequestCommand<K> command = composedType.remoteInvocation(parallelPublisher, remoteSegments, null, (Set)keysToExcludeByAddress.get(remoteAddress), includeLoader, deliveryGuarantee, transformer, finalizer);
                command.setTopologyId(topology.getTopologyId());
                CompletionStage stage = this.rpcManager.invokeCommand(remoteAddress, command, new SegmentPublisherResultCollector(remoteSegments), this.rpcManager.getSyncRpcOptions());
                stage.whenComplete(biConsumer);
            }
        }
        if (localSegments != null) {
            CompletionStage<PublisherResult<R>> localStage = composedType.localInvocation(parallelPublisher, localSegments, null, (Set)keysToExcludeByAddress.get(localAddress), includeLoader, deliveryGuarantee, transformer, finalizer);
            if (log.isTraceEnabled()) {
                localStage = localStage.whenComplete((results, t) -> {
                    if (t != null) {
                        log.tracef((Throwable)t, "Received exception while processing segments %s from %s", (Object)localSegments, (Object)localAddress);
                    } else {
                        log.tracef("Result was: %s for segments %s from %s with %s suspected segments", results.getResult(), localSegments, localAddress, results.getSuspectedSegments());
                    }
                });
            }
            localStage.whenComplete(biConsumer);
        }
        if (useContext) {
            this.handleContextInvocation(segments, null, ctx, composedType, transformer, biConsumer);
        }
    }

    private Map<Address, IntSet> determineSegmentTargets(LocalizedCacheTopology topology, IntSet segments, Address localAddress) {
        HashMap<Address, IntSet> targets = new HashMap<Address, IntSet>();
        if (segments == null) {
            for (int segment = 0; segment < this.maxSegment; ++segment) {
                this.handleSegment(segment, topology, localAddress, targets);
            }
        } else {
            PrimitiveIterator.OfInt iter = segments.iterator();
            while (iter.hasNext()) {
                int segment = iter.nextInt();
                this.handleSegment(segment, topology, localAddress, targets);
            }
        }
        if (log.isTraceEnabled()) {
            log.tracef("Targets determined to be %s on topology " + topology.getTopologyId(), (Object)targets);
        }
        return targets;
    }

    private void handleSegment(int segment, LocalizedCacheTopology topology, Address localAddress, Map<Address, IntSet> targets) {
        DistributionInfo distributionInfo = topology.getSegmentDistribution(segment);
        Address targetAddres = this.determineOwnerToReadFrom(distributionInfo, localAddress);
        if (targetAddres != null) {
            this.addToMap(targets, targetAddres, (K)segment);
        } else if (log.isTraceEnabled()) {
            log.tracef("No owner was found for segment %s.", segment);
        }
    }

    private void addToMap(Map<Address, IntSet> map, Address owner, int segment) {
        IntSet set = map.get(owner);
        if (set == null) {
            set = IntSets.mutableEmptySet();
            map.put(owner, set);
        }
        set.set(segment);
    }

    private Address determineOwnerToReadFrom(DistributionInfo distributionInfo, Address localAddress) {
        if (!this.writeBehindShared && distributionInfo.isReadOwner()) {
            return localAddress;
        }
        return distributionInfo.primary();
    }

    private Map<Address, Set<K>> determineKeyTargets(LocalizedCacheTopology topology, Set<K> keys2, Address localAddress, IntSet segments, InvocationContext ctx) {
        HashMap<Address, Set<K>> filteredKeys = new HashMap<Address, Set<K>>();
        for (K key : keys2) {
            if (ctx != null && ctx.lookupEntry(key) != null) continue;
            DistributionInfo distributionInfo = topology.getDistribution(key);
            if (segments != null && !segments.contains(distributionInfo.segmentId())) continue;
            this.addToMap(filteredKeys, this.determineOwnerToReadFrom(distributionInfo, localAddress), key);
        }
        return filteredKeys;
    }

    private void addToMap(Map<Address, Set<K>> map, Address owner, K key) {
        Set<K> set = map.get(owner);
        if (set == null) {
            set = new HashSet<K>();
            map.put(owner, set);
        }
        set.add(key);
    }

    private boolean hasWriteBehindSharedStore(PersistenceConfiguration persistenceConfiguration) {
        for (StoreConfiguration storeConfiguration : persistenceConfiguration.stores()) {
            if (!storeConfiguration.shared() || !storeConfiguration.async().enabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <R> SegmentCompletionPublisher<R> keyPublisher(IntSet segments, Set<K> keysToInclude, InvocationContext invocationContext, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, int batchSize, Function<? super Publisher<K>, ? extends Publisher<R>> transformer) {
        if (keysToInclude != null) {
            return new KeyAwarePublisherImpl(keysToInclude, this.keyComposedType(), segments, invocationContext, includeLoader, deliveryGuarantee, batchSize, transformer);
        }
        return new SegmentAwarePublisherImpl(segments, this.keyComposedType(), invocationContext, includeLoader, deliveryGuarantee, batchSize, transformer);
    }

    @Override
    public <R> SegmentCompletionPublisher<R> entryPublisher(IntSet segments, Set<K> keysToInclude, InvocationContext invocationContext, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, int batchSize, Function<? super Publisher<CacheEntry<K, V>>, ? extends Publisher<R>> transformer) {
        if (keysToInclude != null) {
            return new KeyAwarePublisherImpl(keysToInclude, this.entryComposedType(), segments, invocationContext, includeLoader, deliveryGuarantee, batchSize, transformer);
        }
        return new SegmentAwarePublisherImpl(segments, this.entryComposedType(), invocationContext, includeLoader, deliveryGuarantee, batchSize, transformer);
    }

    private static boolean shouldTrackKeys(DeliveryGuarantee deliveryGuarantee, Function<?, ?> transformer) {
        if (deliveryGuarantee == DeliveryGuarantee.EXACTLY_ONCE) {
            if (transformer == MarshallableFunctions.identity()) {
                return false;
            }
            if (transformer instanceof ModifiedValueFunction) {
                return ((ModifiedValueFunction)transformer).isModified();
            }
            return true;
        }
        return false;
    }

    private class SegmentAwarePublisherImpl<I, R>
    extends AbstractSegmentAwarePublisher<I, R> {
        private SegmentAwarePublisherImpl(IntSet segments, ComposedType<K, I, R> composedType, InvocationContext invocationContext, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, int batchSize, Function<? super Publisher<I>, ? extends Publisher<R>> transformer) {
            super(composedType, segments, invocationContext, includeLoader, deliveryGuarantee, batchSize, transformer);
        }

        @Override
        InitialPublisherCommand buildInitialCommand(Address target, String requestId, IntSet segments, Set<K> excludedKeys, int batchSize, boolean useContext) {
            int lookupEntryCount;
            Function functionToUse = useContext && this.invocationContext != null && (lookupEntryCount = this.invocationContext.lookedUpEntriesCount()) > 0 ? publisher -> {
                if (this.usedContext.getAndSet(true)) {
                    return (Publisher)this.transformer.apply(publisher);
                }
                ArrayList contextValues = new ArrayList(lookupEntryCount);
                this.invocationContext.forEachValue((key, entry) -> contextValues.add(this.composedType.fromCacheEntry((CacheEntry)entry)));
                return (Publisher)this.transformer.apply(Flowable.concat(Flowable.fromIterable(contextValues), publisher));
            } : this.transformer;
            return ClusterPublisherManagerImpl.this.commandsFactory.buildInitialPublisherCommand(requestId, this.deliveryGuarantee, batchSize, segments, null, excludedKeys, this.includeLoader, this.composedType.isEntry(), this.shouldTrackKeys, functionToUse);
        }
    }

    private class KeyAwarePublisherImpl<I, R>
    extends AbstractSegmentAwarePublisher<I, R> {
        final Set<K> keysToInclude;

        private KeyAwarePublisherImpl(Set<K> keysToInclude, ComposedType<K, I, R> composedType, IntSet segments, InvocationContext invocationContext, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, int batchSize, Function<? super Publisher<I>, ? extends Publisher<R>> transformer) {
            super(composedType, segments, invocationContext, includeLoader, deliveryGuarantee, batchSize, transformer);
            this.keysToInclude = Objects.requireNonNull(keysToInclude);
        }

        Set<K> calculateKeysToUse(Set<K> keys2, IntSet segments, Set<K> excludedKeys) {
            HashSet results = null;
            for (Object key : keys2) {
                if (excludedKeys != null && excludedKeys.contains(key) || !segments.contains(ClusterPublisherManagerImpl.this.keyPartitioner.getSegment(key))) continue;
                if (results == null) {
                    results = new HashSet();
                }
                results.add(key);
            }
            return results;
        }

        @Override
        InitialPublisherCommand buildInitialCommand(Address target, String requestId, IntSet segments, Set<K> excludedKeys, int batchSize, boolean useContext) {
            int lookupEntryCount;
            Set keysToUse = this.calculateKeysToUse(this.keysToInclude, segments, excludedKeys);
            if (keysToUse == null) {
                return null;
            }
            Function functionToUse = useContext && this.invocationContext != null && (lookupEntryCount = this.invocationContext.lookedUpEntriesCount()) > 0 ? publisher -> {
                if (this.usedContext.getAndSet(true)) {
                    return (Publisher)this.transformer.apply(publisher);
                }
                ArrayList contextValues = new ArrayList(lookupEntryCount);
                this.invocationContext.forEachValue((key, entry) -> {
                    if (this.keysToInclude.contains(key)) {
                        contextValues.add(this.composedType.fromCacheEntry((CacheEntry)entry));
                    }
                });
                return (Publisher)this.transformer.apply(Flowable.concat(Flowable.fromIterable(contextValues), publisher));
            } : this.transformer;
            return ClusterPublisherManagerImpl.this.commandsFactory.buildInitialPublisherCommand(requestId, this.deliveryGuarantee, batchSize, segments, keysToUse, excludedKeys, this.includeLoader, this.composedType.isEntry(), this.shouldTrackKeys, functionToUse);
        }
    }

    abstract class AbstractSegmentAwarePublisher<I, R>
    implements SegmentCompletionPublisher<R> {
        final ComposedType<K, I, R> composedType;
        final IntSet segments;
        final InvocationContext invocationContext;
        final boolean includeLoader;
        final DeliveryGuarantee deliveryGuarantee;
        final int batchSize;
        final Function<? super Publisher<I>, ? extends Publisher<R>> transformer;
        final boolean shouldTrackKeys;
        final AtomicBoolean usedContext = new AtomicBoolean();

        private AbstractSegmentAwarePublisher(ComposedType<K, I, R> composedType, IntSet segments, InvocationContext invocationContext, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, int batchSize, Function<? super Publisher<I>, ? extends Publisher<R>> transformer) {
            this.composedType = composedType;
            this.segments = segments != null ? segments : IntSets.immutableRangeSet(ClusterPublisherManagerImpl.this.maxSegment);
            this.invocationContext = invocationContext;
            this.includeLoader = includeLoader;
            this.deliveryGuarantee = deliveryGuarantee;
            this.batchSize = batchSize;
            this.transformer = transformer;
            this.shouldTrackKeys = ClusterPublisherManagerImpl.shouldTrackKeys(deliveryGuarantee, transformer);
        }

        @Override
        public void subscribe(Subscriber<? super R> s2, IntConsumer completedSegmentConsumer) {
            IntConsumer consumerToUse = completedSegmentConsumer == SegmentCompletionPublisher.EMPTY_CONSUMER ? null : Objects.requireNonNull(completedSegmentConsumer);
            new SubscriberHandler(this, s2, consumerToUse).start();
        }

        abstract InitialPublisherCommand buildInitialCommand(Address var1, String var2, IntSet var3, Set<K> var4, int var5, boolean var6);

        NextPublisherCommand buildNextCommand(String requestId) {
            return ClusterPublisherManagerImpl.this.commandsFactory.buildNextPublisherCommand(requestId);
        }
    }

    class SubscriberHandler<I, R>
    implements ObjIntConsumer<I> {
        final AbstractSegmentAwarePublisher<I, R> publisher;
        final Subscriber<? super R> subscriber;
        final String requestId;
        final AtomicReferenceArray<Set<K>> keysBySegment;
        final IntSet segmentsToComplete;
        final IntConsumer completedSegmentConsumer;
        final Map<Object, IntSet> enqueuedSegmentNotifiers;
        final AtomicBoolean useContext = new AtomicBoolean(true);
        volatile int currentTopology = -1;

        SubscriberHandler(AbstractSegmentAwarePublisher<I, R> publisher, Subscriber<? super R> subscriber, IntConsumer completedSegmentConsumer) {
            this.publisher = publisher;
            this.subscriber = subscriber;
            this.requestId = ClusterPublisherManagerImpl.this.rpcManager.getAddress() + "#" + requestCounter.incrementAndGet();
            this.keysBySegment = publisher.deliveryGuarantee == DeliveryGuarantee.EXACTLY_ONCE ? new AtomicReferenceArray(ClusterPublisherManagerImpl.this.maxSegment) : null;
            this.segmentsToComplete = IntSets.concurrentCopyFrom(publisher.segments, ClusterPublisherManagerImpl.this.maxSegment);
            this.completedSegmentConsumer = completedSegmentConsumer;
            this.enqueuedSegmentNotifiers = completedSegmentConsumer == null ? null : new ConcurrentHashMap();
        }

        public void start() {
            Flowable<Object> valuesFlowable = Flowable.just(ClusterPublisherManagerImpl.this.distributionManager).flatMap(dm -> {
                int currentTopology;
                if (!ClusterPublisherManagerImpl.this.componentRegistry.getStatus().allowInvocations()) {
                    return Flowable.error(new IllegalLifecycleStateException());
                }
                LocalizedCacheTopology topology = dm.getCacheTopology();
                int previousTopology = this.currentTopology;
                this.currentTopology = currentTopology = topology.getTopologyId();
                Address localAddress = ClusterPublisherManagerImpl.this.rpcManager.getAddress();
                Map targets = ClusterPublisherManagerImpl.this.determineSegmentTargets(topology, this.segmentsToComplete, localAddress);
                if (previousTopology != -1 && previousTopology == currentTopology || targets.isEmpty()) {
                    int nextTopology = currentTopology + 1;
                    if (log.isTraceEnabled()) {
                        log.tracef("Request id %s needs a new topology to retry segments %s. Current topology is %d, with targets %s", this.requestId, this.segmentsToComplete, currentTopology, targets);
                    }
                    return RxJavaInterop.voidCompletionStageToFlowable(ClusterPublisherManagerImpl.this.stateTransferLock.topologyFuture(nextTopology), true);
                }
                IntSet localSegments = (IntSet)targets.remove(localAddress);
                Iterator iterator2 = targets.entrySet().iterator();
                Supplier<Map.Entry<Address, IntSet>> targetSupplier = () -> {
                    SubscriberHandler subscriberHandler = this;
                    synchronized (subscriberHandler) {
                        if (iterator2.hasNext()) {
                            return (Map.Entry)iterator2.next();
                        }
                        return null;
                    }
                };
                Map excludedKeys = this.publisher.invocationContext == null ? Collections.emptyMap() : ClusterPublisherManagerImpl.this.determineKeyTargets(topology, this.publisher.invocationContext.getLookedUpEntries().keySet(), localAddress, this.segmentsToComplete, null);
                int concurrentPublishers = Math.min(4, targets.size() + (localSegments != null ? 1 : 0));
                int targetBatchSize = (this.publisher.batchSize + concurrentPublishers - 1) / concurrentPublishers;
                Publisher[] publisherArray = new Publisher[concurrentPublishers];
                for (int i = 0; i < concurrentPublishers - 1; ++i) {
                    publisherArray[i] = InnerPublisherSubscription.createPublisher(this, targetBatchSize, targetSupplier, excludedKeys, currentTopology);
                }
                publisherArray[concurrentPublishers - 1] = localSegments != null ? InnerPublisherSubscription.createPublisher(this, targetBatchSize, targetSupplier, excludedKeys, currentTopology, new AbstractMap.SimpleEntry<Address, IntSet>(localAddress, localSegments)) : InnerPublisherSubscription.createPublisher(this, targetBatchSize, targetSupplier, excludedKeys, currentTopology);
                return Flowable.mergeArray(publisherArray);
            }, 4).repeatUntil(() -> {
                boolean complete = this.segmentsToComplete.isEmpty();
                if (log.isTraceEnabled()) {
                    if (complete) {
                        log.tracef("All segments complete for %s", (Object)this.requestId);
                    } else {
                        log.tracef("Segments %s not completed - retrying", (Object)this.segmentsToComplete);
                    }
                }
                return complete;
            });
            if (this.completedSegmentConsumer != null) {
                ByRef<Object> previousValue = new ByRef<Object>(null);
                valuesFlowable = valuesFlowable.doOnNext(value -> {
                    IntSet segments;
                    Object previous = previousValue.get();
                    if (previous != null && (segments = this.enqueuedSegmentNotifiers.remove(previous)) != null) {
                        if (log.isTraceEnabled()) {
                            log.tracef("Enqueued value %s has been returned, completing segments %s", (Object)Util.toStr(previous), (Object)segments);
                        }
                        segments.forEach(this.completedSegmentConsumer);
                    }
                    previousValue.set(value);
                }).doOnComplete(() -> this.enqueuedSegmentNotifiers.forEach((k, segments) -> {
                    if (log.isTraceEnabled()) {
                        log.tracef("Notifying of completed segments %s due to publisher is complete", segments);
                    }
                    segments.forEach(this.completedSegmentConsumer);
                }));
            }
            valuesFlowable.subscribe(this.subscriber);
        }

        void completeSegment(int segment) {
            this.segmentsToComplete.remove(segment);
            if (this.keysBySegment != null) {
                this.keysBySegment.set(segment, null);
            }
        }

        void notifySegmentsComplete(IntSet segments, Object lastValue) {
            if (this.completedSegmentConsumer != null) {
                if (lastValue == null) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Delaying completed segments %s to be notified when current publisher is complete(no value to map it's completion)", (Object)segments);
                    }
                    this.enqueuedSegmentNotifiers.put(new Object(), segments);
                } else {
                    if (log.isTraceEnabled()) {
                        log.tracef("Delaying completed segments %s to be notified when %s is returned", (Object)segments, (Object)Util.toStr(lastValue));
                    }
                    this.enqueuedSegmentNotifiers.put(lastValue, segments);
                }
            }
        }

        CompletionStage<PublisherResponse> sendInitialCommand(Address target, IntSet segments, int batchSize, Set<K> excludedKeys, int topologyId) {
            boolean local;
            InitialPublisherCommand cmd;
            if (this.keysBySegment != null) {
                PrimitiveIterator.OfInt iter = segments.iterator();
                while (iter.hasNext()) {
                    int segment = iter.nextInt();
                    Set keys2 = this.keysBySegment.get(segment);
                    if (keys2 == null) continue;
                    if (excludedKeys == null) {
                        excludedKeys = new HashSet();
                    }
                    excludedKeys.addAll(keys2);
                }
            }
            if (log.isTraceEnabled()) {
                log.tracef("Request: %s is initiating publisher request with batch size %d from %s in segments %s", this.requestId, batchSize, target, segments);
            }
            if ((cmd = this.publisher.buildInitialCommand(target, this.requestId, segments, excludedKeys, batchSize, (local = target == ClusterPublisherManagerImpl.this.rpcManager.getAddress()) && this.useContext.getAndSet(false))) == null) {
                return CompletableFuture.completedFuture(PublisherResponse.emptyResponse(segments, null));
            }
            if (local) {
                try {
                    return (CompletableFuture)cmd.invokeAsync(ClusterPublisherManagerImpl.this.componentRegistry);
                }
                catch (Throwable throwable) {
                    return CompletableFutures.completedExceptionFuture(throwable);
                }
            }
            cmd.setTopologyId(topologyId);
            return ClusterPublisherManagerImpl.this.rpcManager.invokeCommand(target, (ReplicableCommand)cmd, SingleResponseCollector.validOnly(), ClusterPublisherManagerImpl.this.rpcOptions).thenApply(responseHandler);
        }

        CompletionStage<PublisherResponse> sendNextCommand(Address target, int topologyId) {
            if (log.isTraceEnabled()) {
                log.tracef("Request: %s is continuing publisher request from %s", (Object)this.requestId, (Object)target);
            }
            if (target == ClusterPublisherManagerImpl.this.rpcManager.getAddress()) {
                return ClusterPublisherManagerImpl.this.publisherHandler.getNext(this.requestId);
            }
            NextPublisherCommand cmd = this.publisher.buildNextCommand(this.requestId);
            cmd.setTopologyId(topologyId);
            return ClusterPublisherManagerImpl.this.rpcManager.invokeCommand(target, (ReplicableCommand)cmd, SingleResponseCollector.validOnly(), ClusterPublisherManagerImpl.this.rpcOptions).thenApply(responseHandler);
        }

        boolean handleThrowable(Throwable t, Address target, IntSet segments) {
            if (t instanceof SuspectException || t.getCause() instanceof SuspectException) {
                if (log.isTraceEnabled()) {
                    log.tracef("Received suspect exception for id %s from node %s when requesting segments %s", (Object)this.requestId, (Object)target, (Object)segments);
                }
                return true;
            }
            if (log.isTraceEnabled()) {
                log.tracef(t, "Received exception for id %s from node %s when requesting segments %s", (Object)this.requestId, (Object)target, (Object)segments);
            }
            this.sendCancelCommand(target);
            return false;
        }

        void sendCancelCommand(Address target) {
            CompletionStage<Object> stage;
            CancelPublisherCommand command = ClusterPublisherManagerImpl.this.commandsFactory.buildCancelPublisherCommand(this.requestId);
            if (target == ClusterPublisherManagerImpl.this.rpcManager.getAddress()) {
                try {
                    stage = command.invokeAsync(ClusterPublisherManagerImpl.this.componentRegistry);
                }
                catch (Throwable throwable) {
                    stage = CompletableFutures.completedExceptionFuture(throwable);
                }
            } else {
                stage = ClusterPublisherManagerImpl.this.rpcManager.invokeCommand(target, (ReplicableCommand)command, VoidResponseCollector.ignoreLeavers(), ClusterPublisherManagerImpl.this.rpcOptions);
            }
            if (log.isTraceEnabled()) {
                stage.exceptionally(t -> {
                    log.tracef("There was a problem cancelling publisher for id %s at address %s", (Object)this.requestId, (Object)target);
                    return null;
                });
            }
        }

        @Override
        public void accept(I value, int segment) {
            if (this.keysBySegment != null) {
                Set keys2 = this.keysBySegment.get(segment);
                if (keys2 == null) {
                    keys2 = new HashSet();
                    this.keysBySegment.set(segment, keys2);
                }
                Object key = this.publisher.shouldTrackKeys ? value : this.publisher.composedType.toKey(value);
                if (log.isTraceEnabled()) {
                    log.tracef("Saving key %s for segment %d for id %s", (Object)Util.toStr(key), (Object)segment, (Object)this.requestId);
                }
                keys2.add(key);
            }
        }
    }

    private class EntryComposedType<R>
    implements ComposedType<K, CacheEntry<K, V>, R> {
        private EntryComposedType() {
        }

        @Override
        public CompletionStage<PublisherResult<R>> localInvocation(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, Set<K> keysToExclude, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<CacheEntry<K, V>>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
            return ClusterPublisherManagerImpl.this.localPublisherManager.entryReduction(parallelPublisher, segments, keysToInclude, keysToExclude, includeLoader, deliveryGuarantee, transformer, finalizer);
        }

        @Override
        public ReductionPublisherRequestCommand<K> remoteInvocation(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, Set<K> keysToExclude, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<CacheEntry<K, V>>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
            return ClusterPublisherManagerImpl.this.commandsFactory.buildEntryReductionPublisherCommand(parallelPublisher, deliveryGuarantee, segments, keysToInclude, keysToExclude, includeLoader, transformer, finalizer);
        }

        @Override
        public CompletionStage<PublisherResult<R>> contextInvocation(IntSet segments, Set<K> keysToInclude, InvocationContext ctx, Function<? super Publisher<CacheEntry<K, V>>, ? extends CompletionStage<R>> transformer) {
            return transformer.apply(LocalClusterPublisherManagerImpl.entryPublisherFromContext(ctx, segments, ClusterPublisherManagerImpl.this.keyPartitioner, keysToInclude)).thenApply(LocalPublisherManagerImpl.ignoreSegmentsFunction());
        }

        @Override
        public SegmentAwarePublisher<R> localPublisher(IntSet segments, Set<K> keysToInclude, Set<K> keysToExclude, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<CacheEntry<K, V>>, ? extends Publisher<R>> transformer) {
            return ClusterPublisherManagerImpl.this.localPublisherManager.entryPublisher(segments, keysToInclude, keysToExclude, includeLoader, deliveryGuarantee, transformer);
        }

        @Override
        public boolean isEntry() {
            return true;
        }

        @Override
        public K toKey(CacheEntry<K, V> value) {
            return value.getKey();
        }

        @Override
        public CacheEntry<K, V> fromCacheEntry(CacheEntry entry) {
            return entry;
        }
    }

    private class KeyComposedType<R>
    implements ComposedType<K, K, R> {
        private KeyComposedType() {
        }

        @Override
        public CompletionStage<PublisherResult<R>> localInvocation(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, Set<K> keysToExclude, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<K>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
            return ClusterPublisherManagerImpl.this.localPublisherManager.keyReduction(parallelPublisher, segments, keysToInclude, keysToExclude, includeLoader, deliveryGuarantee, transformer, finalizer);
        }

        @Override
        public ReductionPublisherRequestCommand<K> remoteInvocation(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, Set<K> keysToExclude, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<K>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
            return ClusterPublisherManagerImpl.this.commandsFactory.buildKeyReductionPublisherCommand(parallelPublisher, deliveryGuarantee, segments, keysToInclude, keysToExclude, includeLoader, transformer, finalizer);
        }

        @Override
        public CompletionStage<PublisherResult<R>> contextInvocation(IntSet segments, Set<K> keysToInclude, InvocationContext ctx, Function<? super Publisher<K>, ? extends CompletionStage<R>> transformer) {
            return transformer.apply(LocalClusterPublisherManagerImpl.keyPublisherFromContext(ctx, segments, ClusterPublisherManagerImpl.this.keyPartitioner, keysToInclude)).thenApply(LocalPublisherManagerImpl.ignoreSegmentsFunction());
        }

        @Override
        public SegmentAwarePublisher<R> localPublisher(IntSet segments, Set<K> keysToInclude, Set<K> keysToExclude, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<K>, ? extends Publisher<R>> transformer) {
            return ClusterPublisherManagerImpl.this.localPublisherManager.keyPublisher(segments, keysToInclude, keysToExclude, includeLoader, deliveryGuarantee, transformer);
        }

        @Override
        public boolean isEntry() {
            return false;
        }

        @Override
        public K toKey(K value) {
            return value;
        }

        @Override
        public K fromCacheEntry(CacheEntry entry) {
            return entry.getKey();
        }
    }

    static interface ComposedType<K, I, R> {
        public CompletionStage<PublisherResult<R>> localInvocation(boolean var1, IntSet var2, Set<K> var3, Set<K> var4, boolean var5, DeliveryGuarantee var6, Function<? super Publisher<I>, ? extends CompletionStage<R>> var7, Function<? super Publisher<R>, ? extends CompletionStage<R>> var8);

        public ReductionPublisherRequestCommand<K> remoteInvocation(boolean var1, IntSet var2, Set<K> var3, Set<K> var4, boolean var5, DeliveryGuarantee var6, Function<? super Publisher<I>, ? extends CompletionStage<R>> var7, Function<? super Publisher<R>, ? extends CompletionStage<R>> var8);

        public CompletionStage<PublisherResult<R>> contextInvocation(IntSet var1, Set<K> var2, InvocationContext var3, Function<? super Publisher<I>, ? extends CompletionStage<R>> var4);

        public SegmentAwarePublisher<R> localPublisher(IntSet var1, Set<K> var2, Set<K> var3, boolean var4, DeliveryGuarantee var5, Function<? super Publisher<I>, ? extends Publisher<R>> var6);

        public boolean isEntry();

        public K toKey(I var1);

        public I fromCacheEntry(CacheEntry var1);
    }

    private class SegmentPublisherResultCollector<R>
    extends ValidResponseCollector<PublisherResult<R>> {
        private final IntSet targetSegments;

        SegmentPublisherResultCollector(IntSet targetSegments) {
            this.targetSegments = targetSegments;
        }

        @Override
        public PublisherResult<R> finish() {
            throw new IllegalStateException("Should never be invoked!");
        }

        @Override
        protected PublisherResult<R> addValidResponse(Address sender, ValidResponse response) {
            PublisherResult results = (PublisherResult)response.getResponseValue();
            if (log.isTraceEnabled()) {
                log.tracef("Result was: %s for segments %s from %s with %s suspected segments", results.getResult(), this.targetSegments, sender, results.getSuspectedSegments());
            }
            return results;
        }

        @Override
        protected PublisherResult<R> addTargetNotFound(Address sender) {
            if (log.isTraceEnabled()) {
                log.tracef("Cache is no longer running for segments %s from %s - must retry", (Object)this.targetSegments, (Object)sender);
            }
            return new SegmentPublisherResult<Object>(this.targetSegments, null);
        }

        @Override
        protected PublisherResult<R> addException(Address sender, Exception exception) {
            if (log.isTraceEnabled()) {
                log.tracef((Throwable)exception, "Exception encountered while requesting segments %s from %s", (Object)this.targetSegments, (Object)sender);
            }
            if (exception instanceof CacheException) {
                throw (CacheException)exception;
            }
            throw new CacheException(exception);
        }
    }

    private class KeyPublisherResultCollector<R>
    extends ValidResponseCollector<PublisherResult<R>> {
        private final Set<K> keys;

        KeyPublisherResultCollector(Set<K> keys2) {
            this.keys = keys2;
        }

        @Override
        public PublisherResult<R> finish() {
            throw new IllegalStateException("Should never be invoked!");
        }

        @Override
        protected PublisherResult<R> addValidResponse(Address sender, ValidResponse response) {
            PublisherResult results = (PublisherResult)response.getResponseValue();
            if (log.isTraceEnabled()) {
                log.tracef("Result was: %s for keys %s from %s", results.getResult(), (Object)this.keys, (Object)sender);
            }
            return results;
        }

        @Override
        protected PublisherResult<R> addTargetNotFound(Address sender) {
            if (log.isTraceEnabled()) {
                log.tracef("Cache is no longer running for keys %s from %s - must retry", (Object)Util.toStr(this.keys), (Object)sender);
            }
            return new KeyPublisherResult(this.keys);
        }

        @Override
        protected PublisherResult<R> addException(Address sender, Exception exception) {
            if (log.isTraceEnabled()) {
                log.tracef((Throwable)exception, "Exception encountered while requesting keys %s from %s", (Object)Util.toStr(this.keys), (Object)sender);
            }
            if (exception instanceof CacheException) {
                throw (CacheException)exception;
            }
            throw new CacheException(exception);
        }
    }

    private class KeyBiConsumer<I, R>
    implements BiConsumer<PublisherResult<R>, Throwable> {
        private final FlowableProcessor<R> flowableProcessor;
        private final AtomicInteger parallelCount;
        private final Set<K> keysToRetry = ConcurrentHashMap.newKeySet();
        private final int currentTopologyId;
        private final boolean parallelPublisher;
        private final boolean includeLoader;
        private final DeliveryGuarantee deliveryGuarantee;
        private final ComposedType<K, I, R> composedType;
        private final Function<? super Publisher<I>, ? extends CompletionStage<R>> transformer;
        private final Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer;

        KeyBiConsumer(FlowableProcessor<R> flowableProcessor, AtomicInteger parallelCount, int currentTopologyId, boolean parallelPublisher, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, ComposedType<K, I, R> composedType, Function<? super Publisher<I>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
            this.flowableProcessor = flowableProcessor;
            this.parallelCount = parallelCount;
            this.currentTopologyId = currentTopologyId;
            this.parallelPublisher = parallelPublisher;
            this.includeLoader = includeLoader;
            this.deliveryGuarantee = deliveryGuarantee;
            this.composedType = composedType;
            this.transformer = transformer;
            this.finalizer = finalizer;
        }

        @Override
        public void accept(PublisherResult<R> resultCollector, Throwable t) {
            if (t != null) {
                if (log.isTraceEnabled()) {
                    log.tracef(t, "General error encountered when executing publisher request command", new Object[0]);
                }
                this.flowableProcessor.onError(t);
            } else {
                this.handleResult(resultCollector);
                if (this.parallelCount.decrementAndGet() == 0) {
                    this.onCompletion();
                }
            }
        }

        private void handleResult(PublisherResult<R> result) {
            R actualValue;
            Set<?> suspectedKeys = result.getSuspectedKeys();
            if (suspectedKeys != null && !suspectedKeys.isEmpty()) {
                this.keysToRetry.addAll(suspectedKeys);
            }
            if ((actualValue = result.getResult()) != null) {
                this.flowableProcessor.onNext(actualValue);
            }
        }

        private void onCompletion() {
            if (this.keysToRetry.isEmpty()) {
                this.flowableProcessor.onComplete();
            } else {
                int nextTopology = this.currentTopologyId + 1;
                if (log.isTraceEnabled()) {
                    log.tracef("Retrying keys %s after %d is installed", (Object)this.keysToRetry, (Object)nextTopology);
                }
                ClusterPublisherManagerImpl.this.stateTransferLock.topologyFuture(nextTopology).whenComplete((ign, innerT) -> {
                    if (innerT != null) {
                        if (log.isTraceEnabled()) {
                            log.tracef((Throwable)innerT, "General error encountered when waiting on topology future for publisher request command", new Object[0]);
                        }
                        this.flowableProcessor.onError((Throwable)innerT);
                    } else {
                        ClusterPublisherManagerImpl.this.startKeyPublisher(this.parallelPublisher, null, this.keysToRetry, null, this.includeLoader, this.deliveryGuarantee, this.composedType, this.transformer, this.finalizer, this.flowableProcessor);
                    }
                });
            }
        }
    }

    private class SegmentSpecificConsumer<I, R>
    implements BiConsumer<PublisherResult<R>, Throwable> {
        private final FlowableProcessor<R> flowableProcessor;
        private final AtomicInteger parallelCount;
        private final IntSet segmentsToRetry;
        private final int currentTopologyId;
        private final boolean parallelPublisher;
        private final InvocationContext ctx;
        private final boolean includeLoader;
        private final DeliveryGuarantee deliveryGuarantee;
        private final ComposedType<K, I, R> composedType;
        private final Function<? super Publisher<I>, ? extends CompletionStage<R>> transformer;
        private final Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer;

        SegmentSpecificConsumer(FlowableProcessor<R> flowableProcessor, AtomicInteger parallelCount, int currentTopologyId, boolean parallelPublisher, InvocationContext ctx, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, ComposedType<K, I, R> composedType, Function<? super Publisher<I>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
            this.segmentsToRetry = IntSets.concurrentSet(ClusterPublisherManagerImpl.this.maxSegment);
            this.flowableProcessor = flowableProcessor;
            this.parallelCount = parallelCount;
            this.currentTopologyId = currentTopologyId;
            this.parallelPublisher = parallelPublisher;
            this.ctx = ctx;
            this.includeLoader = includeLoader;
            this.deliveryGuarantee = deliveryGuarantee;
            this.composedType = composedType;
            this.transformer = transformer;
            this.finalizer = finalizer;
        }

        @Override
        public void accept(PublisherResult<R> resultCollector, Throwable t) {
            if (t != null) {
                if (log.isTraceEnabled()) {
                    log.tracef(t, "General error encountered when executing publisher request command", new Object[0]);
                }
                this.flowableProcessor.onError(t);
            } else {
                this.handleResult(resultCollector);
                if (this.parallelCount.decrementAndGet() == 0) {
                    this.onCompletion();
                }
            }
        }

        private void handleResult(PublisherResult<R> result) {
            R actualValue;
            IntSet suspectedSegments = result.getSuspectedSegments();
            if (suspectedSegments != null && !suspectedSegments.isEmpty()) {
                this.segmentsToRetry.addAll(suspectedSegments);
            }
            if ((actualValue = result.getResult()) != null) {
                this.flowableProcessor.onNext(actualValue);
            }
        }

        private void onCompletion() {
            if (this.segmentsToRetry.isEmpty()) {
                this.flowableProcessor.onComplete();
            } else {
                int nextTopology = this.currentTopologyId + 1;
                if (log.isTraceEnabled()) {
                    log.tracef("Retrying segments %s after %d is installed", (Object)this.segmentsToRetry, (Object)nextTopology);
                }
                ClusterPublisherManagerImpl.this.stateTransferLock.topologyFuture(nextTopology).whenComplete((ign, innerT) -> {
                    if (innerT != null) {
                        if (log.isTraceEnabled()) {
                            log.tracef((Throwable)innerT, "General error encountered when waiting on topology future for publisher request command", new Object[0]);
                        }
                        this.flowableProcessor.onError((Throwable)innerT);
                    } else {
                        ClusterPublisherManagerImpl.this.startSegmentPublisher(this.parallelPublisher, this.segmentsToRetry, this.ctx, this.includeLoader, this.deliveryGuarantee, this.composedType, this.transformer, this.finalizer, this.flowableProcessor);
                    }
                });
            }
        }
    }
}

