/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.cluster.ClusterEvent;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventManager;
import org.infinispan.notifications.cachelistener.cluster.MultiClusterEventCommand;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.impl.SingleResponseCollector;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class BatchingClusterEventManagerImpl<K, V>
implements ClusterEventManager<K, V> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    Configuration configuration;
    @Inject
    RpcManager rpcManager;
    @Inject
    ComponentRef<CommandsFactory> commandsFactory;
    private long timeout;
    private final Map<Object, EventContext<K, V>> eventContextMap = new ConcurrentHashMap<Object, EventContext<K, V>>();

    @Start
    public void start() {
        this.timeout = this.configuration.clustering().remoteTimeout();
        this.configuration.clustering().attributes().attribute(ClusteringConfiguration.REMOTE_TIMEOUT).addListener((a, ignored) -> {
            this.timeout = (Long)a.get();
        });
    }

    @Override
    public void addEvents(Object batchIdentifier, Address target, UUID identifier, Collection<ClusterEvent<K, V>> events, boolean sync) {
        this.eventContextMap.compute(batchIdentifier, (ignore, eventContext) -> {
            if (eventContext == null) {
                if (log.isTraceEnabled()) {
                    log.tracef("Created new unicast event context for identifier %s", batchIdentifier);
                }
                eventContext = new UnicastEventContext();
            }
            if (log.isTraceEnabled()) {
                log.tracef("Adding new events %s for identifier %s", (Object)events, batchIdentifier);
            }
            eventContext.addTargets(target, identifier, events, sync);
            return eventContext;
        });
    }

    @Override
    public CompletionStage<Void> sendEvents(Object batchIdentifier) {
        EventContext<K, V> ctx = this.eventContextMap.remove(batchIdentifier);
        if (ctx != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Sending events for identifier %s", batchIdentifier);
            }
            return ctx.sendToTargets();
        }
        if (log.isTraceEnabled()) {
            log.tracef("No events to send for identifier %s", batchIdentifier);
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public void dropEvents(Object batchIdentifier) {
        EventContext<K, V> ctx = this.eventContextMap.remove(batchIdentifier);
        if (log.isTraceEnabled()) {
            if (ctx != null) {
                log.tracef("Dropping events for identifier %s", batchIdentifier);
            } else {
                log.tracef("No events to drop for identifier %s", batchIdentifier);
            }
        }
    }

    private static class TargetEvents<K, V> {
        final Map<UUID, Collection<ClusterEvent<K, V>>> events = new HashMap<UUID, Collection<ClusterEvent<K, V>>>();
        boolean sync = false;

        private TargetEvents() {
        }
    }

    protected class UnicastEventContext<K, V>
    implements EventContext<K, V> {
        protected final Map<Address, TargetEvents<K, V>> targets = new HashMap<Address, TargetEvents<K, V>>();

        protected UnicastEventContext() {
        }

        @Override
        public void addTargets(Address address, UUID identifier, Collection<ClusterEvent<K, V>> events, boolean sync) {
            Map<UUID, Collection<ClusterEvent<UUID, Collection<ClusterEvent<K, V>>>>> listenerEvents;
            Collection<ClusterEvent<K, V>> prevEvents;
            TargetEvents<K, V> targetEvents = this.targets.get(address);
            if (targetEvents == null) {
                targetEvents = new TargetEvents();
                this.targets.put(address, targetEvents);
            }
            if ((prevEvents = (listenerEvents = targetEvents.events).put(identifier, events)) != null) {
                events.addAll(prevEvents);
            }
            if (sync) {
                targetEvents.sync = true;
            }
        }

        @Override
        public CompletionStage<Void> sendToTargets() {
            AggregateCompletionStage<Void> aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
            CommandsFactory factory2 = BatchingClusterEventManagerImpl.this.commandsFactory.running();
            for (Map.Entry<Address, TargetEvents<K, V>> entry : this.targets.entrySet()) {
                TargetEvents<K, V> multiEvents = entry.getValue();
                MultiClusterEventCommand callable = factory2.buildMultiClusterEventCommand(multiEvents.events);
                CompletionStage<ValidResponse> stage = BatchingClusterEventManagerImpl.this.rpcManager.invokeCommand(entry.getKey(), callable, SingleResponseCollector.validOnly(), new RpcOptions(DeliverOrder.NONE, BatchingClusterEventManagerImpl.this.timeout, TimeUnit.MILLISECONDS));
                if (!multiEvents.sync) continue;
                aggregateCompletionStage.dependsOn(stage);
            }
            return aggregateCompletionStage.freeze();
        }
    }

    private static interface EventContext<K, V> {
        public void addTargets(Address var1, UUID var2, Collection<ClusterEvent<K, V>> var3, boolean var4);

        public CompletionStage<Void> sendToTargets();
    }
}

