/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.commons.time.TimeService;
import org.infinispan.executors.ManageableExecutorService;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorServiceImpl;

@Scope(value=Scopes.GLOBAL)
public final class LazyInitializingBlockingTaskAwareExecutorService
extends ManageableExecutorService<ExecutorService>
implements BlockingTaskAwareExecutorService {
    private static final BlockingTaskAwareExecutorService STOPPED = new EmptyBlockingTaskAwareExecutorService();
    private final ThreadPoolExecutorFactory<ExecutorService> executorFactory;
    private final ThreadFactory threadFactory;
    private final TimeService timeService;
    private volatile BlockingTaskAwareExecutorService blockingExecutor;

    public LazyInitializingBlockingTaskAwareExecutorService(ThreadPoolExecutorFactory<ExecutorService> executorFactory, ThreadFactory threadFactory2, TimeService timeService) {
        this.executorFactory = executorFactory;
        this.threadFactory = threadFactory2;
        this.timeService = timeService;
    }

    @Override
    public void execute(BlockingRunnable runnable2) {
        this.initIfNeeded();
        this.blockingExecutor.execute(runnable2);
    }

    @Override
    public void checkForReadyTasks() {
        if (this.blockingExecutor != null) {
            this.blockingExecutor.checkForReadyTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        LazyInitializingBlockingTaskAwareExecutorService lazyInitializingBlockingTaskAwareExecutorService = this;
        synchronized (lazyInitializingBlockingTaskAwareExecutorService) {
            if (this.blockingExecutor == null) {
                this.blockingExecutor = STOPPED;
            }
            this.blockingExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Stop
    public List<Runnable> shutdownNow() {
        LazyInitializingBlockingTaskAwareExecutorService lazyInitializingBlockingTaskAwareExecutorService = this;
        synchronized (lazyInitializingBlockingTaskAwareExecutorService) {
            if (this.blockingExecutor == null) {
                this.blockingExecutor = STOPPED;
            }
            return this.blockingExecutor.shutdownNow();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.blockingExecutor == null || this.blockingExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.blockingExecutor == null || this.blockingExecutor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout2, TimeUnit unit) throws InterruptedException {
        if (this.blockingExecutor == null) {
            return true;
        }
        return this.blockingExecutor.awaitTermination(timeout2, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.initIfNeeded();
        return this.blockingExecutor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.initIfNeeded();
        return this.blockingExecutor.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.initIfNeeded();
        return this.blockingExecutor.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.initIfNeeded();
        return this.blockingExecutor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout2, TimeUnit unit) throws InterruptedException {
        this.initIfNeeded();
        return this.blockingExecutor.invokeAll(tasks, timeout2, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.initIfNeeded();
        return this.blockingExecutor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout2, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.initIfNeeded();
        return this.blockingExecutor.invokeAny(tasks, timeout2, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.initIfNeeded();
        this.blockingExecutor.execute(command);
    }

    public BlockingTaskAwareExecutorService getExecutorService() {
        return this.blockingExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNeeded() {
        if (this.blockingExecutor == null) {
            LazyInitializingBlockingTaskAwareExecutorService lazyInitializingBlockingTaskAwareExecutorService = this;
            synchronized (lazyInitializingBlockingTaskAwareExecutorService) {
                if (this.blockingExecutor == null) {
                    this.executor = this.executorFactory.createExecutor(this.threadFactory);
                    this.blockingExecutor = new BlockingTaskAwareExecutorServiceImpl(this.executor, this.timeService);
                }
            }
        }
    }

    static final class EmptyBlockingTaskAwareExecutorService
    extends AbstractExecutorService
    implements BlockingTaskAwareExecutorService {
        EmptyBlockingTaskAwareExecutorService() {
        }

        @Override
        public void execute(BlockingRunnable runnable2) {
            throw new RejectedExecutionException();
        }

        @Override
        public void checkForReadyTasks() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return true;
        }

        @Override
        public boolean isTerminated() {
            return true;
        }

        @Override
        public boolean awaitTermination(long timeout2, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public void execute(Runnable command) {
            throw new RejectedExecutionException();
        }
    }
}

