/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.ResourceSecurityCategory;

public class ResourceSecurityCategoryEnumFactory
implements EnumFactory<ResourceSecurityCategory> {
    @Override
    public ResourceSecurityCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("anonymous".equals(codeString)) {
            return ResourceSecurityCategory.ANONYMOUS;
        }
        if ("business".equals(codeString)) {
            return ResourceSecurityCategory.BUSINESS;
        }
        if ("individual".equals(codeString)) {
            return ResourceSecurityCategory.INDIVIDUAL;
        }
        if ("patient".equals(codeString)) {
            return ResourceSecurityCategory.PATIENT;
        }
        if ("not-classified".equals(codeString)) {
            return ResourceSecurityCategory.NOTCLASSIFIED;
        }
        throw new IllegalArgumentException("Unknown ResourceSecurityCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(ResourceSecurityCategory code) {
        if (code == ResourceSecurityCategory.ANONYMOUS) {
            return "anonymous";
        }
        if (code == ResourceSecurityCategory.BUSINESS) {
            return "business";
        }
        if (code == ResourceSecurityCategory.INDIVIDUAL) {
            return "individual";
        }
        if (code == ResourceSecurityCategory.PATIENT) {
            return "patient";
        }
        if (code == ResourceSecurityCategory.NOTCLASSIFIED) {
            return "not-classified";
        }
        return "?";
    }

    @Override
    public String toSystem(ResourceSecurityCategory code) {
        return code.getSystem();
    }
}

