/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum QualityType {
    INDEL,
    SNP,
    UNKNOWN,
    NULL;


    public static QualityType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("indel".equals(codeString)) {
            return INDEL;
        }
        if ("snp".equals(codeString)) {
            return SNP;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown QualityType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INDEL: {
                return "indel";
            }
            case SNP: {
                return "snp";
            }
            case UNKNOWN: {
                return "unknown";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/quality-type";
    }

    public String getDefinition() {
        switch (this) {
            case INDEL: {
                return "INDEL Comparison.";
            }
            case SNP: {
                return "SNP Comparison.";
            }
            case UNKNOWN: {
                return "UNKNOWN Comparison.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INDEL: {
                return "INDEL Comparison";
            }
            case SNP: {
                return "SNP Comparison";
            }
            case UNKNOWN: {
                return "UNKNOWN Comparison";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

