/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.fuseable.ConditionalSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.Optional;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelMapOptional<T, R>
extends ParallelFlowable<R> {
    final ParallelFlowable<T> source;
    final Function<? super T, Optional<? extends R>> mapper;

    public ParallelMapOptional(ParallelFlowable<T> source2, Function<? super T, Optional<? extends R>> mapper) {
        this.source = source2;
        this.mapper = mapper;
    }

    @Override
    public void subscribe(Subscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            Subscriber<R> a = subscribers[i];
            parents[i] = a instanceof ConditionalSubscriber ? new ParallelMapConditionalSubscriber<T, R>((ConditionalSubscriber)a, this.mapper) : new ParallelMapSubscriber<T, R>(a, this.mapper);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelMapConditionalSubscriber<T, R>
    implements ConditionalSubscriber<T>,
    Subscription {
        final ConditionalSubscriber<? super R> downstream;
        final Function<? super T, Optional<? extends R>> mapper;
        Subscription upstream;
        boolean done;

        ParallelMapConditionalSubscriber(ConditionalSubscriber<? super R> actual, Function<? super T, Optional<? extends R>> mapper) {
            this.downstream = actual;
            this.mapper = mapper;
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.upstream.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            Optional<R> v;
            if (this.done) {
                return false;
            }
            try {
                v = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null value");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.cancel();
                this.onError(ex);
                return false;
            }
            return v.isPresent() && this.downstream.tryOnNext(v.get());
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }
    }

    static final class ParallelMapSubscriber<T, R>
    implements ConditionalSubscriber<T>,
    Subscription {
        final Subscriber<? super R> downstream;
        final Function<? super T, Optional<? extends R>> mapper;
        Subscription upstream;
        boolean done;

        ParallelMapSubscriber(Subscriber<? super R> actual, Function<? super T, Optional<? extends R>> mapper) {
            this.downstream = actual;
            this.mapper = mapper;
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.upstream.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            Optional<R> v;
            if (this.done) {
                return true;
            }
            try {
                v = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null Optional");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.cancel();
                this.onError(ex);
                return true;
            }
            if (v.isPresent()) {
                this.downstream.onNext(v.get());
                return true;
            }
            return false;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }
    }
}

