/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.Optional;

public final class MaybeMapOptional<T, R>
extends Maybe<R> {
    final Maybe<T> source;
    final Function<? super T, Optional<? extends R>> mapper;

    public MaybeMapOptional(Maybe<T> source2, Function<? super T, Optional<? extends R>> mapper) {
        this.source = source2;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super R> observer) {
        this.source.subscribe(new MapOptionalMaybeObserver<T, R>(observer, this.mapper));
    }

    static final class MapOptionalMaybeObserver<T, R>
    implements MaybeObserver<T>,
    Disposable {
        final MaybeObserver<? super R> downstream;
        final Function<? super T, Optional<? extends R>> mapper;
        Disposable upstream;

        MapOptionalMaybeObserver(MaybeObserver<? super R> downstream, Function<? super T, Optional<? extends R>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
        }

        @Override
        public void dispose() {
            Disposable d = this.upstream;
            this.upstream = DisposableHelper.DISPOSED;
            d.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            Optional<R> v;
            try {
                v = Objects.requireNonNull(this.mapper.apply(value), "The mapper returned a null item");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(ex);
                return;
            }
            if (v.isPresent()) {
                this.downstream.onSuccess(v.get());
            } else {
                this.downstream.onComplete();
            }
        }

        @Override
        public void onError(Throwable e) {
            this.downstream.onError(e);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

