/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseReference;

public abstract class BaseRuntimeChildDefinition {
    private BaseRuntimeChildDefinition myReplacedParentDefinition;

    public abstract IAccessor getAccessor();

    public abstract BaseRuntimeElementDefinition<?> getChildByName(String var1);

    public abstract BaseRuntimeElementDefinition<?> getChildElementDefinitionByDatatype(Class<? extends IBase> var1);

    public abstract String getChildNameByDatatype(Class<? extends IBase> var1);

    public abstract String getElementName();

    public String getExtensionUrl() {
        return null;
    }

    public Object getInstanceConstructorArguments() {
        return null;
    }

    public abstract int getMax();

    public abstract int getMin();

    public abstract IMutator getMutator();

    public abstract Set<String> getValidChildNames();

    public abstract boolean isSummary();

    abstract void sealAndInitialize(FhirContext var1, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> var2);

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getElementName() + "]";
    }

    public BaseRuntimeChildDefinition getReplacedParentDefinition() {
        return this.myReplacedParentDefinition;
    }

    public void setReplacedParentDefinition(BaseRuntimeChildDefinition myReplacedParentDefinition) {
        this.myReplacedParentDefinition = myReplacedParentDefinition;
    }

    BaseRuntimeElementDefinition<?> findResourceReferenceDefinition(Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        for (Map.Entry<Class<IBase>, BaseRuntimeElementDefinition<?>> next : theClassToElementDefinitions.entrySet()) {
            if (!IBaseReference.class.isAssignableFrom(next.getKey())) continue;
            return next.getValue();
        }
        throw new IllegalStateException(Msg.code(1692) + "Unable to find reference type");
    }

    public static interface IMutator {
        public void addValue(IBase var1, IBase var2);

        public void setValue(IBase var1, IBase var2);
    }

    public static interface IAccessor {
        public List<IBase> getValues(IBase var1);

        default public <T extends IBase> Optional<T> getFirstValueOrNull(IBase theTarget) {
            return this.getValues(theTarget).stream().findFirst();
        }
    }
}

