/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.sql.udf;

import au.csiro.pathling.fhirpath.encoding.CodingEncoding;
import au.csiro.pathling.sql.udf.SqlFunction;
import au.csiro.pathling.sql.udf.SqlFunction1;
import au.csiro.pathling.sql.udf.TerminologyUdfHelpers;
import au.csiro.pathling.terminology.TerminologyService;
import au.csiro.pathling.terminology.TerminologyServiceFactory;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.hl7.fhir.r4.model.Coding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayUdf
implements SqlFunction,
SqlFunction1<Row, String> {
    private static final Logger log = LoggerFactory.getLogger(DisplayUdf.class);
    private static final long serialVersionUID = 7605853352299165569L;
    public static final String DISPLAY_PROPERTY_CODE = "display";
    public static final String FUNCTION_NAME = "display";
    public static final DataType RETURN_TYPE = DataTypes.StringType;
    @Nonnull
    private final TerminologyServiceFactory terminologyServiceFactory;

    DisplayUdf(@Nonnull TerminologyServiceFactory terminologyServiceFactory) {
        this.terminologyServiceFactory = terminologyServiceFactory;
    }

    @Override
    public String getName() {
        return "display";
    }

    @Override
    public DataType getReturnType() {
        return RETURN_TYPE;
    }

    @Nullable
    protected String doCall(@Nullable Coding coding) {
        if (coding == null || !TerminologyUdfHelpers.isValidCoding(coding)) {
            return null;
        }
        TerminologyService terminologyService = this.terminologyServiceFactory.build();
        List<TerminologyService.PropertyOrDesignation> result = terminologyService.lookup(coding, "display");
        Optional<TerminologyService.Property> maybeDisplayName = result.stream().filter(s2 -> s2 instanceof TerminologyService.Property).map(s2 -> (TerminologyService.Property)s2).filter(p -> "display".equals(p.getCode())).findFirst();
        return maybeDisplayName.map(TerminologyService.Property::getValueAsString).orElse(null);
    }

    @Nullable
    public String call(@Nullable Row codingRow) {
        return this.doCall(CodingEncoding.decode(codingRow));
    }
}

