/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.config;

import java.util.Set;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class EncodingConfiguration {
    @NotNull
    @Min(value=0L)
    private @NotNull @Min(value=0L) Integer maxNestingLevel;
    @NotNull
    private boolean enableExtensions;
    @NotNull
    private Set<String> openTypes;

    private static Integer $default$maxNestingLevel() {
        return 3;
    }

    private static boolean $default$enableExtensions() {
        return true;
    }

    private static Set<String> $default$openTypes() {
        return Set.of("boolean", "code", "date", "dateTime", "decimal", "integer", "string", "Coding", "CodeableConcept", "Address", "Identifier", "Reference");
    }

    EncodingConfiguration(Integer maxNestingLevel, boolean enableExtensions, Set<String> openTypes) {
        this.maxNestingLevel = maxNestingLevel;
        this.enableExtensions = enableExtensions;
        this.openTypes = openTypes;
    }

    public static EncodingConfigurationBuilder builder() {
        return new EncodingConfigurationBuilder();
    }

    public Integer getMaxNestingLevel() {
        return this.maxNestingLevel;
    }

    public boolean isEnableExtensions() {
        return this.enableExtensions;
    }

    public Set<String> getOpenTypes() {
        return this.openTypes;
    }

    public void setMaxNestingLevel(Integer maxNestingLevel) {
        this.maxNestingLevel = maxNestingLevel;
    }

    public void setEnableExtensions(boolean enableExtensions) {
        this.enableExtensions = enableExtensions;
    }

    public void setOpenTypes(Set<String> openTypes) {
        this.openTypes = openTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncodingConfiguration)) {
            return false;
        }
        EncodingConfiguration other = (EncodingConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableExtensions() != other.isEnableExtensions()) {
            return false;
        }
        Integer this$maxNestingLevel = this.getMaxNestingLevel();
        Integer other$maxNestingLevel = other.getMaxNestingLevel();
        if (this$maxNestingLevel == null ? other$maxNestingLevel != null : !((Object)this$maxNestingLevel).equals(other$maxNestingLevel)) {
            return false;
        }
        Set<String> this$openTypes = this.getOpenTypes();
        Set<String> other$openTypes = other.getOpenTypes();
        return !(this$openTypes == null ? other$openTypes != null : !((Object)this$openTypes).equals(other$openTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EncodingConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableExtensions() ? 79 : 97);
        Integer $maxNestingLevel = this.getMaxNestingLevel();
        result = result * 59 + ($maxNestingLevel == null ? 43 : ((Object)$maxNestingLevel).hashCode());
        Set<String> $openTypes = this.getOpenTypes();
        result = result * 59 + ($openTypes == null ? 43 : ((Object)$openTypes).hashCode());
        return result;
    }

    public String toString() {
        return "EncodingConfiguration(maxNestingLevel=" + this.getMaxNestingLevel() + ", enableExtensions=" + this.isEnableExtensions() + ", openTypes=" + this.getOpenTypes() + ")";
    }

    public static class EncodingConfigurationBuilder {
        private boolean maxNestingLevel$set;
        private Integer maxNestingLevel$value;
        private boolean enableExtensions$set;
        private boolean enableExtensions$value;
        private boolean openTypes$set;
        private Set<String> openTypes$value;

        EncodingConfigurationBuilder() {
        }

        public EncodingConfigurationBuilder maxNestingLevel(Integer maxNestingLevel) {
            this.maxNestingLevel$value = maxNestingLevel;
            this.maxNestingLevel$set = true;
            return this;
        }

        public EncodingConfigurationBuilder enableExtensions(boolean enableExtensions) {
            this.enableExtensions$value = enableExtensions;
            this.enableExtensions$set = true;
            return this;
        }

        public EncodingConfigurationBuilder openTypes(Set<String> openTypes) {
            this.openTypes$value = openTypes;
            this.openTypes$set = true;
            return this;
        }

        public EncodingConfiguration build() {
            Integer maxNestingLevel$value = this.maxNestingLevel$value;
            if (!this.maxNestingLevel$set) {
                maxNestingLevel$value = EncodingConfiguration.$default$maxNestingLevel();
            }
            boolean enableExtensions$value = this.enableExtensions$value;
            if (!this.enableExtensions$set) {
                enableExtensions$value = EncodingConfiguration.$default$enableExtensions();
            }
            Set<String> openTypes$value = this.openTypes$value;
            if (!this.openTypes$set) {
                openTypes$value = EncodingConfiguration.$default$openTypes();
            }
            return new EncodingConfiguration(maxNestingLevel$value, enableExtensions$value, openTypes$value);
        }

        public String toString() {
            return "EncodingConfiguration.EncodingConfigurationBuilder(maxNestingLevel$value=" + this.maxNestingLevel$value + ", enableExtensions$value=" + this.enableExtensions$value + ", openTypes$value=" + this.openTypes$value + ")";
        }
    }
}

