/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathlingVersion {
    private static final Logger log = LoggerFactory.getLogger(PathlingVersion.class);
    private static final String GIT_PROPERTIES_FILE_NAME = "git.properties";
    private static final String BUILD_VERSION_PROPERTY = "git.build.version";
    private static final String GIT_SHA_PROPERTY = "git.commit.id.abbrev";
    @Nonnull
    private final Properties gitProperties = new Properties();

    public PathlingVersion() {
        this.initialiseGitProperties();
        log.info("Pathling build version: {}", (Object)this.getDescriptiveVersion().orElse("UNKNOWN"));
    }

    private void initialiseGitProperties() {
        InputStream gitPropertiesStream = this.getClass().getClassLoader().getResourceAsStream(GIT_PROPERTIES_FILE_NAME);
        if (gitPropertiesStream != null) {
            try {
                this.gitProperties.load(gitPropertiesStream);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read property file: git.properties");
            }
        } else {
            throw new RuntimeException("Required property file not found in classpath: git.properties");
        }
    }

    public Optional<String> getBuildVersion() {
        return Optional.ofNullable(this.gitProperties.getProperty(BUILD_VERSION_PROPERTY));
    }

    @Nonnull
    public Optional<String> getMajorVersion() {
        return this.getBuildVersion().map(version -> version.split("\\.")[0]);
    }

    public Optional<String> getDescriptiveVersion() {
        if (this.getBuildVersion().isEmpty()) {
            return Optional.empty();
        }
        Optional<String> gitShaProperty = Optional.ofNullable(this.gitProperties.getProperty(GIT_SHA_PROPERTY));
        return gitShaProperty.map(sha -> String.format("%s+%s", this.getBuildVersion().get(), sha));
    }
}

