# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/05_repr_chans.ipynb.

# %% auto 0
__all__ = ['chans']

# %% ../nbs/05_repr_chans.ipynb 4
import torch
from lovely_numpy.repr_chans import chans as np_chans


# %% ../nbs/05_repr_chans.ipynb 5
def chans(t: torch.Tensor,      # Input, shape=([...], H, W)
             cmap = "twilight", # Use matplotlib colormap by this name
             cm_below="blue",   # Color for values below -1
             cm_above="red",    # Color for values above 1
             cm_ninf="cyan",    # Color for -inf values
             cm_pinf="fuchsia", # Color for +inf values
             cm_nan="yellow",   # Color for NaN values
             view_width=966,    # Try to produce an image at most this wide
             gutter_px=3,       # Draw write gutters when tiling the images
             frame_px=1,        # Draw black frame around each image
             scale=1,
             cl=False):     

    "Map tensor values to colors. RGB[A] color is added as channel-last"
    return np_chans(t.detach().cpu().numpy(),
                    cmap=cmap,
                    cm_below=cm_below,
                    cm_above=cm_above,
                    cm_ninf=cm_ninf,
                    cm_pinf=cm_pinf,
                    cm_nan=cm_nan,
                    view_width=view_width,
                    gutter_px=gutter_px,
                    frame_px=frame_px,
                    scale=scale,
                    cl=cl)


# %% ../nbs/05_repr_chans.ipynb 6
class ChanProxy():
    def __init__(self, t: torch.Tensor):
        self.t = t
    
    def __call__(self,
                 cmap = "twilight", 
                 cm_below="blue",
                 cm_above="red",
                 cm_ninf="cyan",
                 cm_pinf="fuchsia",
                 cm_nan="yellow",
                 view_width=966,
                 gutter_px=3,
                 frame_px=1,
                 scale=1):
        
        return chans(self.t,
                     cmap=cmap,
                     cm_below=cm_below,
                     cm_above=cm_above,
                     cm_ninf=cm_ninf,
                     cm_pinf=cm_pinf,
                     cm_nan=cm_nan,
                     view_width=view_width,
                     gutter_px=gutter_px,
                     frame_px=frame_px,
                     scale=scale)
    
    def _repr_png_(self):
        return self.__call__()._repr_png_()
