# Dictionary of valid site and area keys for Craigslist queries

COUNTRY = {
    "argentina": {
        "scope": {"buenosaires": {"title": "Buenos Aires"}},
        "title": "Argentina",
    },
    "austria": {
        "scope": {
            "adelaide": {"title": "Adelaide, SA"},
            "brisbane": {"title": "Brisbane, QLD"},
            "cairns": {"title": "Cairns, QLD"},
            "canberra": {"title": "Canberra, ACT"},
            "darwin": {"title": "Darwin, NT"},
            "goldcoast": {"title": "Gold Coast"},
            "hobart": {"title": "Tasmania"},
            "melbourne": {"title": "Melbourne, VIC"},
            "ntl": {"title": "Newcastle, NSW"},
            "perth": {"title": "Perth, WA"},
            "sydney": {"title": "Sydney, NSW"},
            "wollongong": {"title": "Wollongong, NSW"},
        },
        "title": "Austria",
    },
    "bangladesh": {
        "scope": {"bangladesh": {"title": "Bangladesh"}},
        "title": "Bangladesh",
    },
    "blegium": {"scope": {"brussels": {"title": "Belgium"}}, "title": "Blegium"},
    "bolivia": {"scope": {"lapaz": {"title": "Bolivia"}}, "title": "Bolivia"},
    "brazil": {
        "scope": {
            "belohorizonte": {"title": "Belo Horizonte"},
            "brasilia": {"title": "Bras\u00edlia"},
            "curitiba": {"title": "Curitiba"},
            "fortaleza": {"title": "Fortaleza"},
            "portoalegre": {"title": "Porto Alegre"},
            "recife": {"title": "Recife"},
            "rio": {"title": "Rio De Janeiro"},
            "salvador": {"title": "Salvador, Bahia"},
            "saopaulo": {"title": "S\u00e3o Paulo"},
        },
        "title": "Brazil",
    },
    "bulgaria": {"scope": {"bulgaria": {"title": "Bulgaria"}}, "title": "Bulgaria"},
    "canada": {
        "scope": {
            "abbotsford": {"title": "Fraser Valley, BC"},
            "barrie": {"title": "Barrie, ON"},
            "belleville": {"title": "Belleville, ON"},
            "brantford": {"title": "Brantford-Woodstock"},
            "calgary": {"title": "Calgary, AB"},
            "cariboo": {"title": "Cariboo, BC"},
            "chatham": {"title": "Chatham-Kent, ON"},
            "comoxvalley": {"title": "Comox Valley, BC"},
            "cornwall": {"title": "Cornwall, ON"},
            "edmonton": {"title": "Edmonton, AB"},
            "ftmcmurray": {"title": "Ft Mcmurray, AB"},
            "guelph": {"title": "Guelph, ON"},
            "halifax": {"title": "Halifax, NS"},
            "hamilton": {"title": "Hamilton-Burlington"},
            "hat": {"title": "Medicine Hat, AB"},
            "kamloops": {"title": "Kamloops, BC"},
            "kelowna": {"title": "Kelowna / Okanagan"},
            "kingston": {"title": "Kingston, ON"},
            "kitchener": {"title": "Kitchener-Waterloo-Cambridge"},
            "kootenays": {"title": "Kootenays, BC"},
            "lethbridge": {"title": "Lethbridge, AB"},
            "londonon": {"title": "London, ON"},
            "montreal": {"title": "Montreal, QC"},
            "nanaimo": {"title": "Nanaimo, BC"},
            "newbrunswick": {"title": "New Brunswick"},
            "newfoundland": {"title": "St John'S, NL"},
            "niagara": {"title": "Niagara Region"},
            "ottawa": {"title": "Ottawa-Hull-Gatineau"},
            "owensound": {"title": "Owen Sound, ON"},
            "peace": {"title": "Peace River Country"},
            "pei": {"title": "Prince Edward Island"},
            "peterborough": {"title": "Peterborough, ON"},
            "princegeorge": {"title": "Prince George, BC"},
            "quebec": {"title": "Qu\u00e9bec (Ville)"},
            "reddeer": {"title": "Red Deer, AB"},
            "regina": {"title": "Regina, SK"},
            "saguenay": {"title": "Saguenay, QC"},
            "sarnia": {"title": "Sarnia, ON"},
            "saskatoon": {"title": "Saskatoon, SK"},
            "sherbrooke": {"title": "Sherbrooke, QC"},
            "skeena": {"title": "Skeena-Bulkley"},
            "soo": {"title": "Sault Ste Marie, ON"},
            "sudbury": {"title": "Sudbury, ON"},
            "sunshine": {"title": "Sunshine Coast, BC"},
            "territories": {"title": "Territories"},
            "thunderbay": {"title": "Thunder Bay, ON"},
            "toronto": {
                "scope": {
                    "bra": {"title": "Brampton-Caledon"},
                    "drh": {"title": "Durham Region"},
                    "mss": {"title": "Mississauga"},
                    "oak": {"title": "Oakville-Milton"},
                    "tor": {"title": "City of Toronto"},
                    "yrk": {"title": "York Region"},
                },
                "title": "Toronto",
            },
            "troisrivieres": {"title": "Trois-Rivieres, QC"},
            "vancouver": {
                "scope": {
                    "bnc": {"title": "Burnaby/Newwest"},
                    "nvn": {"title": "North Shore"},
                    "pml": {"title": "Tricities/Pitt/Maple"},
                    "rch": {"title": "Richmond"},
                    "rds": {"title": "Delta/Surrey/Langley"},
                    "van": {"title": "City of Vancouver"},
                },
                "title": "Vancouver, BC",
            },
            "whistler": {"title": "Whistler / Squamish"},
            "whitehorse": {"title": "Whitehorse, YT"},
            "winnipeg": {"title": "Winnipeg, MB"},
            "yellowknife": {"title": "Yellowknife, NT"},
        },
        "title": "Canada",
    },
    "caribbean_islands": {
        "scope": {"caribbean": {"title": "Islas Del Caribe"}},
        "title": "Caribbean Islands",
    },
    "chile": {"scope": {"santiago": {"title": "Chile"}}, "title": "Chile"},
    "china": {
        "scope": {
            "beijing": {"title": "\u5317\u4eac"},
            "chengdu": {"title": "\u6210\u90fd"},
            "chongqing": {"title": "\u91cd\u5e86"},
            "dalian": {"title": "\u5927\u8fde"},
            "guangzhou": {"title": "\u5e7f\u5dde"},
            "hangzhou": {"title": "\u676d\u5dde"},
            "nanjing": {"title": "\u5357\u4eac"},
            "shanghai": {"title": "\u4e0a\u6d77"},
            "shenyang": {"title": "\u6c88\u9633"},
            "shenzhen": {"title": "\u6df1\u5733"},
            "wuhan": {"title": "\u6b66\u6c49"},
            "xian": {"title": "\u897f\u5b89"},
        },
        "title": "China",
    },
    "colombia": {"scope": {"colombia": {"title": "Colombia"}}, "title": "Colombia"},
    "costa_rica": {
        "scope": {"costarica": {"title": "Costa Rica"}},
        "title": "Costa Rica",
    },
    "croatia": {"scope": {"zagreb": {"title": "Croatia"}}, "title": "Croatia"},
    "czech_republic": {
        "scope": {"prague": {"title": "Prague"}},
        "title": "Czech Republic",
    },
    "denmar": {"scope": {"copenhagen": {"title": "K\u00f8benhavn"}}, "title": "Denmar"},
    "dominican_republic": {
        "scope": {"santodomingo": {"title": "Rep\u00fablica Dominicana"}},
        "title": "Dominican Republic",
    },
    "ecuador": {"scope": {"quito": {"title": "Ecuador"}}, "title": "Ecuador"},
    "egypt": {"scope": {"cairo": {"title": "Egypt"}}, "title": "Egypt"},
    "el_salvador": {
        "scope": {"elsalvador": {"title": "El Salvador"}},
        "title": "El Salvador",
    },
    "ethiopia": {"scope": {"addisababa": {"title": "Ethiopia"}}, "title": "Ethiopia"},
    "finland": {
        "scope": {"helsinki": {"title": "Suomi Ty\u00f6paikkoja,"}},
        "title": "Finland",
    },
    "france": {
        "scope": {
            "bordeaux": {"title": "Bordeaux"},
            "cotedazur": {"title": "Nice / C\u00f4te D'Azur"},
            "grenoble": {"title": "Grenoble"},
            "lille": {"title": "Lille"},
            "loire": {"title": "Loire (Vall\u00e9e)"},
            "lyon": {"title": "Lyon"},
            "marseilles": {"title": "Marseille"},
            "montpellier": {"title": "Montpellier"},
            "paris": {"title": "Paris, FR"},
            "rennes": {"title": "Bretagne"},
            "rouen": {"title": "Normandie"},
            "strasbourg": {"title": "Strasbourg"},
            "toulouse": {"title": "Toulouse"},
        },
        "title": "France",
    },
    "germany": {
        "scope": {
            "berlin": {"title": "Berlin"},
            "bremen": {"title": "Bremen"},
            "cologne": {"title": "K\u00f6ln"},
            "dresden": {"title": "Dresden"},
            "dusseldorf": {"title": "D\u00fcsseldorf"},
            "essen": {"title": "Essen / Ruhr"},
            "frankfurt": {"title": "Frankfurt"},
            "hamburg": {"title": "Hamburg"},
            "hannover": {"title": "Hannover"},
            "heidelberg": {"title": "Heidelberg"},
            "kaiserslautern": {"title": "Kaiserslautern"},
            "leipzig": {"title": "Leipzig"},
            "munich": {"title": "M\u00fcnchen"},
            "nuremberg": {"title": "N\u00fcrnberg"},
            "stuttgart": {"title": "Stuttgart"},
        },
        "title": "Germany",
    },
    "ghana": {"scope": {"accra": {"title": "Ghana"}}, "title": "Ghana"},
    "greece": {"scope": {"athens": {"title": "Greece"}}, "title": "Greece"},
    "guam_micronesia": {
        "scope": {"micronesia": {"title": "Guam-Micronesia"}},
        "title": "Guam Micronesia",
    },
    "guatemala": {"scope": {"guatemala": {"title": "Guatemala"}}, "title": "Guatemala"},
    "hong_kong": {"scope": {"hongkong": {"title": "Hong Kong"}}, "title": "Hong Kong"},
    "hungary": {"scope": {"budapest": {"title": "Budapest"}}, "title": "Hungary"},
    "iceland": {"scope": {"reykjavik": {"title": "Reykjavik"}}, "title": "Iceland"},
    "india": {
        "scope": {
            "ahmedabad": {"title": "Ahmedabad"},
            "bangalore": {"title": "Bangalore"},
            "bhubaneswar": {"title": "Bhubaneswar"},
            "chandigarh": {"title": "Chandigarh"},
            "chennai": {"title": "Chennai (Madras)"},
            "delhi": {"title": "Delhi"},
            "goa": {"title": "Goa"},
            "hyderabad": {"title": "Hyderabad"},
            "indore": {"title": "Indore"},
            "jaipur": {"title": "Jaipur"},
            "kerala": {"title": "Kerala"},
            "kolkata": {"title": "Kolkata (Calcutta)"},
            "lucknow": {"title": "Lucknow"},
            "mumbai": {"title": "Mumbai"},
            "pune": {"title": "Pune"},
            "surat": {"title": "Surat Surat"},
        },
        "title": "India",
    },
    "indonesia": {"scope": {"jakarta": {"title": "Indonesia"}}, "title": "Indonesia"},
    "iran": {"scope": {"tehran": {"title": "Iran"}}, "title": "Iran"},
    "iraq": {"scope": {"baghdad": {"title": "Iraq"}}, "title": "Iraq"},
    "ireland": {"scope": {"dublin": {"title": "Dublin, IE"}}, "title": "Ireland"},
    "israel_and_palestine": {
        "scope": {
            "haifa": {"title": "Haifa"},
            "jerusalem": {"title": "Jerusalem"},
            "ramallah": {"title": "West Bank"},
            "telaviv": {"title": "Tel Aviv"},
        },
        "title": "Israel and Palestine",
    },
    "italy": {
        "scope": {
            "bologna": {"title": "Bologna"},
            "florence": {"title": "Firenze / Toscana"},
            "genoa": {"title": "Genova"},
            "milan": {"title": "Milano"},
            "naples": {"title": "Napoli / Campania"},
            "perugia": {"title": "Perugia"},
            "rome": {"title": "Roma"},
            "sardinia": {"title": "Sardegna"},
            "sicily": {"title": "Sicilia"},
            "torino": {"title": "Torino"},
            "venice": {"title": "Venezia / Veneto"},
        },
        "title": "Italy",
    },
    "japan": {
        "scope": {
            "fukuoka": {"title": "\u798f\u5ca1"},
            "hiroshima": {"title": "\u5e83\u5cf6"},
            "nagoya": {"title": "\u540d\u53e4\u5c4b"},
            "okinawa": {"title": "\u6c96\u7e04"},
            "osaka": {"title": "\u5927\u962a\u30fb\u795e\u6238\u30fb\u4eac\u90fd"},
            "sapporo": {"title": "\u672d\u5e4c"},
            "sendai": {"title": "\u4ed9\u53f0"},
            "tokyo": {"title": "\u6771\u4eac"},
        },
        "title": "Japan",
    },
    "kenya": {"scope": {"kenya": {"title": "Kenya"}}, "title": "Kenya"},
    "korea": {"scope": {"seoul": {"title": "Seoul"}}, "title": "Korea"},
    "kuwait": {"scope": {"kuwait": {"title": "Kuwait"}}, "title": "Kuwait"},
    "lebanon": {"scope": {"beirut": {"title": "Beirut, Lebanon"}}, "title": "Lebanon"},
    "luxembourg": {
        "scope": {"luxembourg": {"title": "Luxembourg"}},
        "title": "Luxembourg",
    },
    "malaysia": {"scope": {"malaysia": {"title": "Malaysia"}}, "title": "Malaysia"},
    "mexico": {
        "scope": {
            "acapulco": {"title": "Acapulco"},
            "bajasur": {"title": "Baja California Sur"},
            "chihuahua": {"title": "Chihuahua"},
            "guadalajara": {"title": "Guadalajara, MX"},
            "guanajuato": {"title": "Guanajuato"},
            "hermosillo": {"title": "Hermosillo"},
            "juarez": {"title": "Ciudad Ju\u00e1rez"},
            "mazatlan": {"title": "Mazatl\u00e1n"},
            "mexicocity": {"title": "Ciudad De M\u00e9xico"},
            "monterrey": {"title": "Monterrey"},
            "oaxaca": {"title": "Oaxaca"},
            "puebla": {"title": "Puebla, MX"},
            "pv": {"title": "Puerto Vallarta"},
            "tijuana": {"title": "Tijuana, MX"},
            "veracruz": {"title": "Veracruz"},
            "yucatan": {"title": "Yucat\u00e1n"},
        },
        "title": "Mexico",
    },
    "morocco": {"scope": {"casablanca": {"title": "Morocco"}}, "title": "Morocco"},
    "netherlands": {
        "scope": {"amsterdam": {"title": "Amsterdam / Randstad"}},
        "title": "Netherlands",
    },
    "new_zealand": {
        "scope": {
            "auckland": {"title": "Auckland, NZ"},
            "christchurch": {"title": "Christchurch"},
            "dunedin": {"title": "Dunedin, NZ"},
            "wellington": {"title": "Wellington"},
        },
        "title": "New Zealand",
    },
    "nicaragua": {"scope": {"managua": {"title": "Nicaragua"}}, "title": "Nicaragua"},
    "norway": {"scope": {"oslo": {"title": "Norway"}}, "title": "Norway"},
    "pakistan": {"scope": {"pakistan": {"title": "Pakistan"}}, "title": "Pakistan"},
    "panama": {"scope": {"panama": {"title": "Panama"}}, "title": "Panama"},
    "peru": {"scope": {"lima": {"title": "Peru"}}, "title": "Peru"},
    "philippines": {
        "scope": {
            "bacolod": {"title": "Bacolod"},
            "cdo": {"title": "Cagayan De Oro"},
            "cebu": {"title": "Cebu"},
            "davaocity": {"title": "Davao City"},
            "iloilo": {"title": "Iloilo"},
            "manila": {"title": "Manila"},
            "naga": {"title": "Bicol Region"},
            "pampanga": {"title": "Pampanga"},
            "zamboanga": {"title": "Zamboanga"},
        },
        "title": "Philippines",
    },
    "poland": {"scope": {"warsaw": {"title": "Poland"}}, "title": "Poland"},
    "portugal": {
        "scope": {
            "faro": {"title": "Faro / Algarve"},
            "lisbon": {"title": "Lisboa"},
            "porto": {"title": "Porto"},
        },
        "title": "Portugal",
    },
    "puerto_rico": {
        "scope": {"puertorico": {"title": "Puerto Rico"}},
        "title": "Puerto Rico",
    },
    "romania": {"scope": {"bucharest": {"title": "Romania"}}, "title": "Romania"},
    "russia": {
        "scope": {
            "moscow": {"title": "\u041c\u043e\u0441\u043a\u0432\u0430"},
            "stpetersburg": {
                "title": "\u0421. \u041f\u0435\u0442\u0435\u0440\u0431\u0443\u0440\u0433, Ru"
            },
        },
        "title": "Russia",
    },
    "singapore": {"scope": {"singapore": {"title": "Singapore"}}, "title": "Singapore"},
    "south_africa": {
        "scope": {
            "capetown": {"title": "Cape Town"},
            "durban": {"title": "Durban"},
            "johannesburg": {"title": "Johannesburg"},
            "pretoria": {"title": "Pretoria"},
        },
        "title": "South Africa",
    },
    "spain": {
        "scope": {
            "alicante": {"title": "Alicante"},
            "baleares": {"title": "Baleares"},
            "barcelona": {"title": "Barcelona"},
            "bilbao": {"title": "Bilbao"},
            "cadiz": {"title": "C\u00e1diz"},
            "canarias": {"title": "Canarias"},
            "granada": {"title": "Granada"},
            "madrid": {"title": "Madrid"},
            "malaga": {"title": "M\u00e1laga"},
            "sevilla": {"title": "Sevilla"},
            "valencia": {"title": "Valencia"},
        },
        "title": "Spain",
    },
    "sweden": {"scope": {"stockholm": {"title": "Sverige"}}, "title": "Sweden"},
    "switzerland": {
        "scope": {
            "basel": {"title": "Basel"},
            "bern": {"title": "Bern"},
            "geneva": {"title": "Gen\u00e8ve"},
            "lausanne": {"title": "Lausanne"},
            "zurich": {"title": "Z\u00fcrich"},
        },
        "title": "Switzerland",
    },
    "taiwan": {"scope": {"taipei": {"title": "Taiwan"}}, "title": "Taiwan"},
    "territories": {
        "scope": {
            "micronesia": {"title": "Guam-Micronesia"},
            "puertorico": {"title": "Puerto Rico"},
            "virgin": {"title": "Virgin Islands"},
        },
        "title": "Territories",
    },
    "thailand": {"scope": {"bangkok": {"title": "Thailand"}}, "title": "Thailand"},
    "tunisia": {"scope": {"tunis": {"title": "Tunisia"}}, "title": "Tunisia"},
    "turkey": {"scope": {"istanbul": {"title": "T\u00fcrkiye"}}, "title": "Turkey"},
    "ukraine": {"scope": {"ukraine": {"title": "Ukraine"}}, "title": "Ukraine"},
    "united_arab_emirates": {
        "scope": {"dubai": {"title": "United Arab Emirates"}},
        "title": "United Arab Emirates",
    },
    "united_kingdom": {
        "scope": {
            "aberdeen": {"title": "Aberdeen"},
            "bath": {"title": "Bath, UK"},
            "belfast": {"title": "Belfast"},
            "birmingham": {"title": "Birmingham / West Mids"},
            "brighton": {"title": "Brighton"},
            "bristol": {"title": "Bristol"},
            "cambridge": {"title": "Cambridge, UK"},
            "cardiff": {"title": "Cardiff / Wales"},
            "coventry": {"title": "Coventry, UK"},
            "derby": {"title": "Derby, UK"},
            "devon": {"title": "Devon & Cornwall"},
            "dundee": {"title": "Dundee"},
            "eastmids": {"title": "East Midlands"},
            "edinburgh": {"title": "Edinburgh"},
            "essex": {"title": "Essex, UK"},
            "glasgow": {"title": "Glasgow"},
            "hampshire": {"title": "Hampshire"},
            "kent": {"title": "Kent, UK"},
            "leeds": {"title": "Leeds"},
            "liverpool": {"title": "Liverpool"},
            "london": {"title": "London, UK"},
            "manchester": {"title": "Manchester, UK"},
            "newcastle": {"title": "Newcastle / Ne England"},
            "norwich": {"title": "East Anglia"},
            "nottingham": {"title": "Nottingham, UK"},
            "oxford": {"title": "Oxford, UK"},
            "sheffield": {"title": "Sheffield"},
        },
        "title": "United Kingdom",
    },
    "united_states": {
        "scope": {
            "abilene": {"title": "Abilene, TX"},
            "akroncanton": {"title": "Akron / Canton"},
            "albany": {"title": "Albany, NY"},
            "albanyga": {"title": "Albany, GA"},
            "albuquerque": {"title": "Albuquerque"},
            "allentown": {"title": "Lehigh Valley"},
            "altoona": {"title": "Altoona-Johnstown"},
            "amarillo": {"title": "Amarillo, TX"},
            "ames": {"title": "Ames, IA"},
            "anchorage": {"title": "Anchorage / Mat-Su"},
            "annapolis": {"title": "Annapolis, MD"},
            "annarbor": {"title": "Ann Arbor, MI"},
            "appleton": {"title": "Appleton-Oshkosh-Fdl"},
            "asheville": {"title": "Asheville, NC"},
            "ashtabula": {"title": "Ashtabula, OH"},
            "athensga": {"title": "Athens, GA"},
            "athensohio": {"title": "Athens, OH"},
            "atlanta": {
                "scope": {
                    "atl": {"title": "City of Atlanta"},
                    "eat": {"title": "Otp East"},
                    "nat": {"title": "Otp North"},
                    "sat": {"title": "Otp South"},
                    "wat": {"title": "Otp West"},
                },
                "title": "Atlanta, GA",
            },
            "auburn": {"title": "Auburn, AL"},
            "austin": {"title": "Austin, TX"},
            "bakersfield": {"title": "Bakersfield, CA"},
            "baltimore": {"title": "Baltimore, MD"},
            "batonrouge": {"title": "Baton Rouge"},
            "battlecreek": {"title": "Battle Creek, MI"},
            "beaumont": {"title": "Beaumont / Port Arthur"},
            "bellingham": {"title": "Bellingham, WA"},
            "bemidji": {"title": "Bemidji, MN"},
            "bend": {"title": "Bend, OR"},
            "bgky": {"title": "Bowling Green, KY"},
            "bham": {"title": "Birmingham, AL"},
            "bigbend": {"title": "Southwest Tx"},
            "billings": {"title": "Billings, MT"},
            "binghamton": {"title": "Binghamton, NY"},
            "bismarck": {"title": "Bismarck, ND"},
            "blacksburg": {"title": "New River Valley"},
            "bloomington": {"title": "Bloomington, IN"},
            "bn": {"title": "Bloomington-Normal"},
            "boise": {"title": "Boise, ID"},
            "boone": {"title": "Boone, NC"},
            "boston": {
                "scope": {
                    "bmw": {"title": "Metro West"},
                    "gbs": {"title": "Boston/Cambridge/Brookline"},
                    "nos": {"title": "North Shore"},
                    "nwb": {"title": "Northwest/Merrimack"},
                    "sob": {"title": "South Shore"},
                },
                "title": "Boston",
            },
            "boulder": {"title": "Boulder, CO"},
            "bozeman": {"title": "Bozeman, MT"},
            "brainerd": {"title": "Brainerd, MN"},
            "brownsville": {"title": "Brownsville, TX"},
            "brunswick": {"title": "Brunswick, GA"},
            "buffalo": {"title": "Buffalo, NY"},
            "butte": {"title": "Butte, MT"},
            "carbondale": {"title": "Southern Illinois"},
            "catskills": {"title": "Catskills"},
            "cedarrapids": {"title": "Cedar Rapids, IA"},
            "cenla": {"title": "Central Louisiana"},
            "centralmich": {"title": "Central Michigan"},
            "cfl": {"title": "Heartland Florida"},
            "chambana": {"title": "Champaign Urbana"},
            "chambersburg": {"title": "Cumberland Valley"},
            "charleston": {"title": "Charleston, SC"},
            "charlestonwv": {"title": "Charleston, WV"},
            "charlotte": {"title": "Charlotte, NC"},
            "charlottesville": {"title": "Charlottesville, VA"},
            "chattanooga": {"title": "Chattanooga, TN"},
            "chautauqua": {"title": "Chautauqua, NY"},
            "chicago": {
                "scope": {
                    "chc": {"title": "City of Chicago"},
                    "nch": {"title": "North Chicagoland"},
                    "nwc": {"title": "Northwest Suburbs"},
                    "nwi": {"title": "Northwest Indiana"},
                    "sox": {"title": "South Chicagoland"},
                    "wcl": {"title": "West Chicagoland"},
                },
                "title": "Chicago",
            },
            "chico": {"title": "Chico, CA"},
            "chillicothe": {"title": "Chillicothe, OH"},
            "cincinnati": {"title": "Cincinnati, OH"},
            "clarksville": {"title": "Clarksville, TN"},
            "cleveland": {"title": "Cleveland, OH"},
            "clovis": {"title": "Clovis / Portales"},
            "cnj": {"title": "Central Nj"},
            "collegestation": {"title": "College Station, TX"},
            "columbia": {"title": "Columbia, SC"},
            "columbiamo": {"title": "Columbia / Jeff City"},
            "columbus": {"title": "Columbus, OH"},
            "columbusga": {"title": "Columbus, GA"},
            "cookeville": {"title": "Cookeville, TN"},
            "corpuschristi": {"title": "Corpus Christi, TX"},
            "corvallis": {"title": "Corvallis/Albany"},
            "cosprings": {"title": "Colorado Springs"},
            "csd": {"title": "Pierre / Central Sd"},
            "dallas": {
                "scope": {
                    "dal": {"title": "Dallas"},
                    "ftw": {"title": "Fort Worth"},
                    "mdf": {"title": "Mid Cities"},
                    "ndf": {"title": "North Dfw"},
                    "sdf": {"title": "South Dfw"},
                },
                "title": "Dallas / Fort Worth",
            },
            "danville": {"title": "Danville"},
            "dayton": {"title": "Dayton / Springfield"},
            "daytona": {"title": "Daytona Beach"},
            "delaware": {"title": "Delaware"},
            "denver": {"title": "Denver, CO"},
            "desmoines": {"title": "Des Moines, IA"},
            "detroit": {
                "scope": {
                    "mcb": {"title": "Macomb County"},
                    "okl": {"title": "Oakland County"},
                    "wyn": {"title": "Wayne County"},
                },
                "title": "Detroit Metro",
            },
            "dothan": {"title": "Dothan, AL"},
            "dubuque": {"title": "Dubuque"},
            "duluth": {"title": "Duluth / Superior"},
            "eastco": {"title": "Eastern Co"},
            "easternshore": {"title": "Eastern Shore"},
            "eastidaho": {"title": "East Idaho"},
            "eastky": {"title": "Eastern Kentucky"},
            "eastnc": {"title": "Eastern Nc"},
            "eastoregon": {"title": "East Oregon"},
            "easttexas": {"title": "Tyler / East Tx"},
            "eauclaire": {"title": "Eau Claire, WI"},
            "elko": {"title": "Elko, NV"},
            "elmira": {"title": "Elmira-Corning"},
            "elpaso": {"title": "El Paso, TX"},
            "enid": {"title": "Northwest Ok"},
            "erie": {"title": "Erie, PA"},
            "eugene": {"title": "Eugene, OR"},
            "evansville": {"title": "Evansville, IN"},
            "fairbanks": {"title": "Fairbanks, AK"},
            "fargo": {"title": "Fargo / Moorhead"},
            "farmington": {"title": "Farmington, NM"},
            "fayar": {"title": "Fayetteville, AR"},
            "fayetteville": {"title": "Fayetteville, NC"},
            "fingerlakes": {"title": "Finger Lakes, NY"},
            "flagstaff": {"title": "Flagstaff / Sedona"},
            "florencesc": {"title": "Florence, SC"},
            "fortcollins": {"title": "Fort Collins / North Co"},
            "fortdodge": {"title": "Fort Dodge, IA"},
            "fortlauderdale": {
                "scope": {
                    "brw": {"title": "Broward County"},
                    "mdc": {"title": "Miami / Dade County"},
                    "pbc": {"title": "Palm Beach County"},
                },
                "title": "South Florida",
            },
            "fortmyers": {
                "scope": {
                    "chl": {"title": "Charlotte County"},
                    "col": {"title": "Collier County"},
                    "lee": {"title": "Lee County"},
                },
                "title": "Ft Myers / Sw Florida",
            },
            "fortsmith": {"title": "Fort Smith, AR"},
            "fortwayne": {"title": "Fort Wayne, IN"},
            "frederick": {"title": "Frederick, MD"},
            "fredericksburg": {"title": "Fredericksburg, VA"},
            "fresno": {"title": "Fresno / Madera"},
            "gadsden": {"title": "Gadsden-Anniston"},
            "galveston": {"title": "Galveston, TX"},
            "glensfalls": {"title": "Glens Falls, NY"},
            "goldcountry": {"title": "Gold Country"},
            "grandforks": {"title": "Grand Forks"},
            "grandisland": {"title": "Grand Island, NE"},
            "grandrapids": {"title": "Grand Rapids, MI"},
            "greatfalls": {"title": "Great Falls, MT"},
            "greenbay": {"title": "Green Bay, WI"},
            "greensboro": {"title": "Greensboro, NC"},
            "greenville": {"title": "Greenville / Upstate"},
            "gulfport": {"title": "Gulfport / Biloxi"},
            "hanford": {"title": "Hanford-Corcoran"},
            "harrisburg": {"title": "Harrisburg, PA"},
            "harrisonburg": {"title": "Harrisonburg, VA"},
            "hartford": {"title": "Hartford, CT"},
            "hattiesburg": {"title": "Hattiesburg, MS"},
            "helena": {"title": "Helena, MT"},
            "hickory": {"title": "Hickory / Lenoir"},
            "hiltonhead": {"title": "Hilton Head"},
            "holland": {"title": "Holland, MI"},
            "honolulu": {"title": "Hawaii"},
            "houma": {"title": "Houma, LA"},
            "houston": {"title": "Houston, TX"},
            "hudsonvalley": {"title": "Hudson Valley, NY"},
            "humboldt": {"title": "Humboldt County"},
            "huntington": {"title": "Huntington-Ashland"},
            "huntsville": {"title": "Huntsville / Decatur"},
            "imperial": {"title": "Imperial County"},
            "indianapolis": {"title": "Indianapolis"},
            "inlandempire": {"title": "Inland Empire, CA"},
            "iowacity": {"title": "Iowa City, IA"},
            "ithaca": {"title": "Ithaca, NY"},
            "jackson": {"title": "Jackson, MS"},
            "jacksontn": {"title": "Jackson, TN"},
            "jacksonville": {"title": "Jacksonville, FL"},
            "janesville": {"title": "Janesville, WI"},
            "jerseyshore": {"title": "Jersey Shore"},
            "jonesboro": {"title": "Jonesboro, AR"},
            "joplin": {"title": "Joplin, MO"},
            "juneau": {"title": "Southeast Alaska"},
            "jxn": {"title": "Jackson, MI"},
            "kalamazoo": {"title": "Kalamazoo, MI"},
            "kalispell": {"title": "Kalispell, MT"},
            "kansascity": {"title": "Kansas City, MO"},
            "kenai": {"title": "Kenai Peninsula"},
            "keys": {"title": "Florida Keys"},
            "killeen": {"title": "Killeen / Temple / Ft Hood"},
            "kirksville": {"title": "Kirksville, MO"},
            "klamath": {"title": "Klamath Falls, OR"},
            "knoxville": {"title": "Knoxville, TN"},
            "kokomo": {"title": "Kokomo, IN"},
            "kpr": {"title": "Kennewick-Pasco-Richland"},
            "ksu": {"title": "Manhattan, KS"},
            "lacrosse": {"title": "La Crosse, WI"},
            "lafayette": {"title": "Lafayette, LA"},
            "lakecharles": {"title": "Lake Charles, LA"},
            "lakecity": {"title": "North Central Fl"},
            "lakeland": {"title": "Lakeland, FL"},
            "lancaster": {"title": "Lancaster, PA"},
            "lansing": {"title": "Lansing, MI"},
            "laredo": {"title": "Laredo, TX"},
            "lasalle": {"title": "La Salle Co"},
            "lascruces": {"title": "Las Cruces, NM"},
            "lasvegas": {"title": "Las Vegas"},
            "lawrence": {"title": "Lawrence, KS"},
            "lawton": {"title": "Lawton, OK"},
            "lewiston": {"title": "Lewiston / Clarkston"},
            "lexington": {"title": "Lexington, KY"},
            "limaohio": {"title": "Lima / Findlay"},
            "lincoln": {"title": "Lincoln, NE"},
            "littlerock": {"title": "Little Rock"},
            "logan": {"title": "Logan, UT"},
            "longisland": {"title": "Long Island, NY"},
            "losangeles": {
                "scope": {
                    "ant": {"title": "Antelope Valley"},
                    "lac": {"title": "Central La 213/323"},
                    "lgb": {"title": "Long Beach / 562"},
                    "sfv": {"title": "San Fernando Valley"},
                    "sgv": {"title": "San Gabriel Valley"},
                    "wst": {"title": "Westside-Southbay-310"},
                },
                "title": "Los Angeles",
            },
            "louisville": {"title": "Louisville, KY"},
            "loz": {"title": "Lake of The Ozarks"},
            "lubbock": {"title": "Lubbock, TX"},
            "lynchburg": {"title": "Lynchburg, VA"},
            "macon": {"title": "Macon / Warner Robins"},
            "madison": {"title": "Madison, WI"},
            "maine": {"title": "Maine"},
            "mankato": {"title": "Mankato, MN"},
            "mansfield": {"title": "Mansfield, OH"},
            "marshall": {"title": "Southwest Mn"},
            "martinsburg": {"title": "Eastern Panhandle"},
            "masoncity": {"title": "Mason City, IA"},
            "mattoon": {"title": "Mattoon-Charleston"},
            "mcallen": {"title": "Mcallen / Edinburg"},
            "meadville": {"title": "Meadville, PA"},
            "medford": {"title": "Medford-Ashland"},
            "memphis": {"title": "Memphis, TN"},
            "merced": {"title": "Merced, CA"},
            "meridian": {"title": "Meridian, MS"},
            "miami": {
                "scope": {
                    "brw": {"title": "Broward County"},
                    "mdc": {"title": "Miami / Dade County"},
                },
                "title": "South Florida",
            },
            "milwaukee": {"title": "Milwaukee, WI"},
            "minneapolis": {
                "scope": {
                    "ank": {"title": "Anoka/Chisago/Isanti"},
                    "csw": {"title": "Carver/Sherburne/Wright"},
                    "dak": {"title": "Dakota / Scott"},
                    "hnp": {"title": "Hennepin County"},
                    "ram": {"title": "Ramsey County"},
                    "wsh": {"title": "Washington Co / Wi"},
                },
                "title": "Minneapolis / St Paul",
            },
            "missoula": {"title": "Missoula, MT"},
            "mobile": {"title": "Mobile, AL"},
            "modesto": {"title": "Modesto, CA"},
            "mohave": {"title": "Mohave County"},
            "monroe": {"title": "Monroe, LA"},
            "monroemi": {"title": "Monroe, MI"},
            "montana": {"title": "Eastern Montana"},
            "monterey": {"title": "Monterey Bay"},
            "montgomery": {"title": "Montgomery, AL"},
            "morgantown": {"title": "Morgantown, WV"},
            "moseslake": {"title": "Moses Lake, WA"},
            "muncie": {"title": "Muncie / Anderson"},
            "muskegon": {"title": "Muskegon, MI"},
            "myrtlebeach": {"title": "Myrtle Beach, SC"},
            "nacogdoches": {"title": "Deep East Texas"},
            "nashville": {"title": "Nashville, TN"},
            "natchez": {"title": "Southwest Ms"},
            "nd": {"title": "North Dakota"},
            "nesd": {"title": "Northeast Sd"},
            "newhaven": {"title": "New Haven, CT"},
            "newjersey": {"title": "North Jersey"},
            "newlondon": {"title": "Eastern Ct"},
            "neworleans": {"title": "New Orleans"},
            "newyork": {
                "scope": {
                    "brk": {"title": "Brooklyn"},
                    "brx": {"title": "Bronx"},
                    "fct": {"title": "Fairfield Co, CT"},
                    "jsy": {"title": "New Jersey"},
                    "lgi": {"title": "Long Island"},
                    "mnh": {"title": "Manhattan"},
                    "que": {"title": "Queens"},
                    "stn": {"title": "Staten Island"},
                    "wch": {"title": "Westchester"},
                },
                "title": "New York City",
            },
            "nh": {"title": "New Hampshire"},
            "nmi": {"title": "Northern Michigan"},
            "norfolk": {"title": "Norfolk / Hampton Roads"},
            "northernwi": {"title": "Northern Wi"},
            "northmiss": {"title": "North Mississippi"},
            "northplatte": {"title": "North Platte, NE"},
            "nwct": {"title": "Northwest Ct"},
            "nwga": {"title": "Northwest Ga"},
            "nwks": {"title": "Northwest Ks"},
            "odessa": {"title": "Odessa / Midland"},
            "ogden": {"title": "Ogden-Clearfield"},
            "okaloosa": {"title": "Okaloosa / Walton"},
            "oklahomacity": {"title": "Oklahoma City"},
            "olympic": {"title": "Olympic Peninsula"},
            "omaha": {"title": "Omaha / Council Bluffs"},
            "onslow": {"title": "Jacksonville, NC"},
            "orangecounty": {"title": "Orange County, CA"},
            "oregoncoast": {"title": "Oregon Coast"},
            "orlando": {"title": "Orlando, FL"},
            "ottumwa": {"title": "Southeast Ia"},
            "outerbanks": {"title": "Outer Banks"},
            "owensboro": {"title": "Owensboro, KY"},
            "palmsprings": {"title": "Palm Springs, CA"},
            "panamacity": {"title": "Panama City, FL"},
            "parkersburg": {"title": "Parkersburg-Marietta"},
            "pennstate": {"title": "State College, PA"},
            "pensacola": {"title": "Pensacola, FL"},
            "peoria": {"title": "Peoria, IL"},
            "philadelphia": {"title": "Philadelphia"},
            "phoenix": {
                "scope": {
                    "cph": {"title": "Central/South Phx"},
                    "evl": {"title": "East Valley"},
                    "nph": {"title": "Phx North"},
                    "wvl": {"title": "West Valley"},
                },
                "title": "Phoenix, AZ",
            },
            "pittsburgh": {"title": "Pittsburgh, PA"},
            "plattsburgh": {"title": "Plattsburgh-Adirondacks"},
            "poconos": {"title": "Poconos"},
            "porthuron": {"title": "Port Huron, MI"},
            "portland": {
                "scope": {
                    "clc": {"title": "Clackamas County"},
                    "clk": {"title": "Clark/Cowlitz, WA"},
                    "grg": {"title": "Columbia Gorge"},
                    "mlt": {"title": "Multnomah County"},
                    "nco": {"title": "North Coast"},
                    "wsc": {"title": "Washington County"},
                    "yam": {"title": "Yamhill Co"},
                },
                "title": "Portland, OR",
            },
            "potsdam": {"title": "Potsdam-Canton-Massena"},
            "providence": {"title": "Rhode Island"},
            "provo": {"title": "Provo / Orem"},
            "pueblo": {"title": "Pueblo, CO"},
            "pullman": {"title": "Pullman / Moscow"},
            "quadcities": {"title": "Quad Cities, Ia/Il"},
            "quincy": {"title": "Western Il"},
            "racine": {"title": "Kenosha-Racine"},
            "raleigh": {"title": "Raleigh / Durham / Ch"},
            "rapidcity": {"title": "Rapid City / West Sd"},
            "reading": {"title": "Reading, PA"},
            "redding": {"title": "Redding, CA"},
            "reno": {"title": "Reno / Tahoe"},
            "richmond": {"title": "Richmond, VA"},
            "richmondin": {"title": "Richmond, IN"},
            "roanoke": {"title": "Roanoke, VA"},
            "rochester": {"title": "Rochester, NY"},
            "rockford": {"title": "Rockford, IL"},
            "rockies": {"title": "High Rockies"},
            "roswell": {"title": "Roswell / Carlsbad"},
            "sacramento": {"title": "Sacramento"},
            "saginaw": {"title": "Saginaw-Midland-Baycity"},
            "salem": {"title": "Salem, OR"},
            "salina": {"title": "Salina, KS"},
            "saltlakecity": {"title": "Salt Lake City"},
            "sanangelo": {"title": "San Angelo, TX"},
            "sanantonio": {"title": "San Antonio"},
            "sandiego": {
                "scope": {
                    "csd": {"title": "City of San Diego"},
                    "esd": {"title": "East San Diego County"},
                    "nsd": {"title": "North San Diego County"},
                    "ssd": {"title": "South San Diego County"},
                },
                "title": "San Diego",
            },
            "sandusky": {"title": "Sandusky, OH"},
            "sanmarcos": {"title": "San Marcos, TX"},
            "santafe": {"title": "Santa Fe / Taos"},
            "santamaria": {"title": "Santa Maria, CA"},
            "sarasota": {"title": "Sarasota-Bradenton"},
            "savannah": {"title": "Savannah / Hinesville"},
            "scottsbluff": {"title": "Scottsbluff / Panhandle"},
            "scranton": {"title": "Scranton / Wilkes-Barre"},
            "sd": {"title": "South Dakota"},
            "seattle": {
                "scope": {
                    "est": {"title": "Eastside"},
                    "kit": {"title": "Kitsap / West Puget"},
                    "oly": {"title": "Olympia / Thurston"},
                    "see": {"title": "Seattle"},
                    "skc": {"title": "South King Co"},
                    "sno": {"title": "Snohomish County"},
                    "tac": {"title": "Tacoma / Pierce"},
                },
                "title": "Seattle-Tacoma",
            },
            "seks": {"title": "Southeast Ks"},
            "semo": {"title": "Southeast Missouri"},
            "sfbay": {
                "scope": {
                    "eby": {"title": "East Bay Area"},
                    "nby": {"title": "North Bay / Marin"},
                    "pen": {"title": "Peninsula"},
                    "sby": {"title": "South Bay Area"},
                    "scz": {"title": "Santa Cruz Co"},
                    "sfc": {"title": "City of San Francisco"},
                },
                "title": "Sf Bay Area",
            },
            "sheboygan": {"title": "Sheboygan, WI"},
            "shoals": {"title": "Florence / Muscle Shoals"},
            "showlow": {"title": "Show Low, AZ"},
            "shreveport": {"title": "Shreveport, LA"},
            "sierravista": {"title": "Sierra Vista, AZ"},
            "siouxcity": {"title": "Sioux City, IA"},
            "siouxfalls": {"title": "Sioux Falls / Se Sd"},
            "slo": {"title": "San Luis Obispo"},
            "smd": {"title": "Southern Maryland"},
            "southbend": {"title": "South Bend / Michiana"},
            "southcoast": {"title": "South Coast, MA"},
            "southjersey": {"title": "South Jersey"},
            "spacecoast": {"title": "Space Coast, FL"},
            "spokane": {"title": "Spokane / Coeur D'Alene"},
            "springfield": {"title": "Springfield, MO"},
            "springfieldil": {"title": "Springfield, IL"},
            "statesboro": {"title": "Statesboro, GA"},
            "staugustine": {"title": "St Augustine, FL"},
            "stcloud": {"title": "St Cloud, MN"},
            "stgeorge": {"title": "St George, UT"},
            "stillwater": {"title": "Stillwater, OK"},
            "stjoseph": {"title": "St Joseph"},
            "stlouis": {"title": "St Louis, MO"},
            "stockton": {"title": "Stockton, CA"},
            "susanville": {"title": "Susanville, CA"},
            "swks": {"title": "Southwest Ks"},
            "swmi": {"title": "Southwest Michigan"},
            "swv": {"title": "Southern Wv"},
            "swva": {"title": "Southwest Va"},
            "syracuse": {"title": "Syracuse, NY"},
            "tallahassee": {"title": "Tallahassee"},
            "tampa": {
                "scope": {
                    "hdo": {"title": "Hernando Co"},
                    "hil": {"title": "Hillsborough Co"},
                    "pnl": {"title": "Pinellas Co"},
                    "psc": {"title": "Pasco Co"},
                },
                "title": "Tampa Bay Area",
            },
            "terrehaute": {"title": "Terre Haute, IN"},
            "texarkana": {"title": "Texarkana"},
            "texoma": {"title": "Texoma"},
            "thumb": {"title": "The Thumb, MI"},
            "tippecanoe": {"title": "Lafayette / West Lafayette"},
            "toledo": {"title": "Toledo, OH"},
            "topeka": {"title": "Topeka, KS"},
            "tricities": {"title": "Tri-Cities, TN"},
            "tucson": {"title": "Tucson, AZ"},
            "tulsa": {"title": "Tulsa, OK"},
            "tuscaloosa": {"title": "Tuscaloosa"},
            "tuscarawas": {"title": "Tuscarawas Co"},
            "twinfalls": {"title": "Twin Falls, ID"},
            "twintiers": {"title": "Twin Tiers Ny/Pa"},
            "up": {"title": "Upper Peninsula, MI"},
            "utica": {"title": "Utica-Rome-Oneida"},
            "valdosta": {"title": "Valdosta, GA"},
            "ventura": {"title": "Ventura County"},
            "vermont": {"title": "Vermont"},
            "victoriatx": {"title": "Victoria, TX"},
            "visalia": {"title": "Visalia-Tulare"},
            "waco": {"title": "Waco, TX"},
            "washingtondc": {"title": "Washington, DC"},
            "waterloo": {"title": "Waterloo / Cedar Falls"},
            "watertown": {"title": "Watertown, NY"},
            "wausau": {"title": "Wausau, WI"},
            "wenatchee": {"title": "Wenatchee, WA"},
            "westernmass": {"title": "Western Massachusetts"},
            "westky": {"title": "Western Ky"},
            "westmd": {"title": "Western Maryland"},
            "westslope": {"title": "Western Slope"},
            "wheeling": {"title": "Northern Panhandle"},
            "wichita": {"title": "Wichita, KS"},
            "wichitafalls": {"title": "Wichita Falls, TX"},
            "williamsport": {"title": "Williamsport, PA"},
            "wilmington": {"title": "Wilmington, NC"},
            "winchester": {"title": "Winchester, VA"},
            "winstonsalem": {"title": "Winston-Salem, NC"},
            "worcester": {"title": "Worcester / Central Ma"},
            "wv": {"title": "West Virginia (Old)"},
            "wyoming": {"title": "Wyoming"},
            "yakima": {"title": "Yakima, WA"},
            "york": {"title": "York, PA"},
            "youngstown": {"title": "Youngstown, OH"},
            "yubasutter": {"title": "Yuba-Sutter, CA"},
            "yuma": {"title": "Yuma, AZ"},
            "zanesville": {"title": "Zanesville / Cambridge"},
        },
        "title": "United States",
    },
    "uruguay": {"scope": {"montevideo": {"title": "Montevideo"}}, "title": "Uruguay"},
    "venezuela": {"scope": {"caracas": {"title": "Venezuela"}}, "title": "Venezuela"},
    "vietnam": {"scope": {"vietnam": {"title": "Vietnam"}}, "title": "Vietnam",},
    "virgin_islands_us": {
        "scope": {"virgin": {"title": "Virgin Islands"}},
        "title": "Virgin Islands, US",
    },
}

SITE = {
    "buenosaires": {"title": "Buenos Aires"},
    "adelaide": {"title": "Adelaide, SA"},
    "brisbane": {"title": "Brisbane, QLD"},
    "cairns": {"title": "Cairns, QLD"},
    "canberra": {"title": "Canberra, ACT"},
    "darwin": {"title": "Darwin, NT"},
    "goldcoast": {"title": "Gold Coast"},
    "hobart": {"title": "Tasmania"},
    "melbourne": {"title": "Melbourne, VIC"},
    "ntl": {"title": "Newcastle, NSW"},
    "perth": {"title": "Perth, WA"},
    "sydney": {"title": "Sydney, NSW"},
    "wollongong": {"title": "Wollongong, NSW"},
    "bangladesh": {"title": "Bangladesh"},
    "brussels": {"title": "Belgium"},
    "lapaz": {"title": "Bolivia"},
    "belohorizonte": {"title": "Belo Horizonte"},
    "brasilia": {"title": "Bras\u00edlia"},
    "curitiba": {"title": "Curitiba"},
    "fortaleza": {"title": "Fortaleza"},
    "portoalegre": {"title": "Porto Alegre"},
    "recife": {"title": "Recife"},
    "rio": {"title": "Rio De Janeiro"},
    "salvador": {"title": "Salvador, Bahia"},
    "saopaulo": {"title": "S\u00e3o Paulo"},
    "bulgaria": {"title": "Bulgaria"},
    "abbotsford": {"title": "Fraser Valley, BC"},
    "barrie": {"title": "Barrie, ON"},
    "belleville": {"title": "Belleville, ON"},
    "brantford": {"title": "Brantford-Woodstock"},
    "calgary": {"title": "Calgary, AB"},
    "cariboo": {"title": "Cariboo, BC"},
    "chatham": {"title": "Chatham-Kent, ON"},
    "comoxvalley": {"title": "Comox Valley, BC"},
    "cornwall": {"title": "Cornwall, ON"},
    "edmonton": {"title": "Edmonton, AB"},
    "ftmcmurray": {"title": "Ft Mcmurray, AB"},
    "guelph": {"title": "Guelph, ON"},
    "halifax": {"title": "Halifax, NS"},
    "hamilton": {"title": "Hamilton-Burlington"},
    "hat": {"title": "Medicine Hat, AB"},
    "kamloops": {"title": "Kamloops, BC"},
    "kelowna": {"title": "Kelowna / Okanagan"},
    "kingston": {"title": "Kingston, ON"},
    "kitchener": {"title": "Kitchener-Waterloo-Cambridge"},
    "kootenays": {"title": "Kootenays, BC"},
    "lethbridge": {"title": "Lethbridge, AB"},
    "londonon": {"title": "London, ON"},
    "montreal": {"title": "Montreal, QC"},
    "nanaimo": {"title": "Nanaimo, BC"},
    "newbrunswick": {"title": "New Brunswick"},
    "newfoundland": {"title": "St John'S, NL"},
    "niagara": {"title": "Niagara Region"},
    "ottawa": {"title": "Ottawa-Hull-Gatineau"},
    "owensound": {"title": "Owen Sound, ON"},
    "peace": {"title": "Peace River Country"},
    "pei": {"title": "Prince Edward Island"},
    "peterborough": {"title": "Peterborough, ON"},
    "princegeorge": {"title": "Prince George, BC"},
    "quebec": {"title": "Qu\u00e9bec (Ville)"},
    "reddeer": {"title": "Red Deer, AB"},
    "regina": {"title": "Regina, SK"},
    "saguenay": {"title": "Saguenay, QC"},
    "sarnia": {"title": "Sarnia, ON"},
    "saskatoon": {"title": "Saskatoon, SK"},
    "sherbrooke": {"title": "Sherbrooke, QC"},
    "skeena": {"title": "Skeena-Bulkley"},
    "soo": {"title": "Sault Ste Marie, ON"},
    "sudbury": {"title": "Sudbury, ON"},
    "sunshine": {"title": "Sunshine Coast, BC"},
    "territories": {"title": "Territories"},
    "thunderbay": {"title": "Thunder Bay, ON"},
    "toronto": {
        "scope": {
            "bra": {"title": "Brampton-Caledon"},
            "drh": {"title": "Durham Region"},
            "mss": {"title": "Mississauga"},
            "oak": {"title": "Oakville-Milton"},
            "tor": {"title": "City of Toronto"},
            "yrk": {"title": "York Region"},
        },
        "title": "Toronto",
    },
    "troisrivieres": {"title": "Trois-Rivieres, QC"},
    "vancouver": {
        "scope": {
            "bnc": {"title": "Burnaby/Newwest"},
            "nvn": {"title": "North Shore"},
            "pml": {"title": "Tricities/Pitt/Maple"},
            "rch": {"title": "Richmond"},
            "rds": {"title": "Delta/Surrey/Langley"},
            "van": {"title": "City of Vancouver"},
        },
        "title": "Vancouver, BC",
    },
    "whistler": {"title": "Whistler / Squamish"},
    "whitehorse": {"title": "Whitehorse, YT"},
    "winnipeg": {"title": "Winnipeg, MB"},
    "yellowknife": {"title": "Yellowknife, NT"},
    "caribbean": {"title": "Islas Del Caribe"},
    "santiago": {"title": "Chile"},
    "beijing": {"title": "\u5317\u4eac"},
    "chengdu": {"title": "\u6210\u90fd"},
    "chongqing": {"title": "\u91cd\u5e86"},
    "dalian": {"title": "\u5927\u8fde"},
    "guangzhou": {"title": "\u5e7f\u5dde"},
    "hangzhou": {"title": "\u676d\u5dde"},
    "nanjing": {"title": "\u5357\u4eac"},
    "shanghai": {"title": "\u4e0a\u6d77"},
    "shenyang": {"title": "\u6c88\u9633"},
    "shenzhen": {"title": "\u6df1\u5733"},
    "wuhan": {"title": "\u6b66\u6c49"},
    "xian": {"title": "\u897f\u5b89"},
    "colombia": {"title": "Colombia"},
    "costarica": {"title": "Costa Rica"},
    "zagreb": {"title": "Croatia"},
    "prague": {"title": "Prague"},
    "copenhagen": {"title": "K\u00f8benhavn"},
    "santodomingo": {"title": "Rep\u00fablica Dominicana"},
    "quito": {"title": "Ecuador"},
    "cairo": {"title": "Egypt"},
    "elsalvador": {"title": "El Salvador"},
    "addisababa": {"title": "Ethiopia"},
    "helsinki": {"title": "Suomi Ty\u00f6paikkoja,"},
    "bordeaux": {"title": "Bordeaux"},
    "cotedazur": {"title": "Nice / C\u00f4te D'Azur"},
    "grenoble": {"title": "Grenoble"},
    "lille": {"title": "Lille"},
    "loire": {"title": "Loire (Vall\u00e9e)"},
    "lyon": {"title": "Lyon"},
    "marseilles": {"title": "Marseille"},
    "montpellier": {"title": "Montpellier"},
    "paris": {"title": "Paris, FR"},
    "rennes": {"title": "Bretagne"},
    "rouen": {"title": "Normandie"},
    "strasbourg": {"title": "Strasbourg"},
    "toulouse": {"title": "Toulouse"},
    "berlin": {"title": "Berlin"},
    "bremen": {"title": "Bremen"},
    "cologne": {"title": "K\u00f6ln"},
    "dresden": {"title": "Dresden"},
    "dusseldorf": {"title": "D\u00fcsseldorf"},
    "essen": {"title": "Essen / Ruhr"},
    "frankfurt": {"title": "Frankfurt"},
    "hamburg": {"title": "Hamburg"},
    "hannover": {"title": "Hannover"},
    "heidelberg": {"title": "Heidelberg"},
    "kaiserslautern": {"title": "Kaiserslautern"},
    "leipzig": {"title": "Leipzig"},
    "munich": {"title": "M\u00fcnchen"},
    "nuremberg": {"title": "N\u00fcrnberg"},
    "stuttgart": {"title": "Stuttgart"},
    "accra": {"title": "Ghana"},
    "athens": {"title": "Greece"},
    "micronesia": {"title": "Guam-Micronesia"},
    "guatemala": {"title": "Guatemala"},
    "hongkong": {"title": "Hong Kong"},
    "budapest": {"title": "Budapest"},
    "reykjavik": {"title": "Reykjavik"},
    "ahmedabad": {"title": "Ahmedabad"},
    "bangalore": {"title": "Bangalore"},
    "bhubaneswar": {"title": "Bhubaneswar"},
    "chandigarh": {"title": "Chandigarh"},
    "chennai": {"title": "Chennai (Madras)"},
    "delhi": {"title": "Delhi"},
    "goa": {"title": "Goa"},
    "hyderabad": {"title": "Hyderabad"},
    "indore": {"title": "Indore"},
    "jaipur": {"title": "Jaipur"},
    "kerala": {"title": "Kerala"},
    "kolkata": {"title": "Kolkata (Calcutta)"},
    "lucknow": {"title": "Lucknow"},
    "mumbai": {"title": "Mumbai"},
    "pune": {"title": "Pune"},
    "surat": {"title": "Surat Surat"},
    "jakarta": {"title": "Indonesia"},
    "tehran": {"title": "Iran"},
    "baghdad": {"title": "Iraq"},
    "dublin": {"title": "Dublin, IE"},
    "haifa": {"title": "Haifa"},
    "jerusalem": {"title": "Jerusalem"},
    "ramallah": {"title": "West Bank"},
    "telaviv": {"title": "Tel Aviv"},
    "bologna": {"title": "Bologna"},
    "florence": {"title": "Firenze / Toscana"},
    "genoa": {"title": "Genova"},
    "milan": {"title": "Milano"},
    "naples": {"title": "Napoli / Campania"},
    "perugia": {"title": "Perugia"},
    "rome": {"title": "Roma"},
    "sardinia": {"title": "Sardegna"},
    "sicily": {"title": "Sicilia"},
    "torino": {"title": "Torino"},
    "venice": {"title": "Venezia / Veneto"},
    "fukuoka": {"title": "\u798f\u5ca1"},
    "hiroshima": {"title": "\u5e83\u5cf6"},
    "nagoya": {"title": "\u540d\u53e4\u5c4b"},
    "okinawa": {"title": "\u6c96\u7e04"},
    "osaka": {"title": "\u5927\u962a\u30fb\u795e\u6238\u30fb\u4eac\u90fd"},
    "sapporo": {"title": "\u672d\u5e4c"},
    "sendai": {"title": "\u4ed9\u53f0"},
    "tokyo": {"title": "\u6771\u4eac"},
    "kenya": {"title": "Kenya"},
    "seoul": {"title": "Seoul"},
    "kuwait": {"title": "Kuwait"},
    "beirut": {"title": "Beirut, Lebanon"},
    "luxembourg": {"title": "Luxembourg"},
    "malaysia": {"title": "Malaysia"},
    "acapulco": {"title": "Acapulco"},
    "bajasur": {"title": "Baja California Sur"},
    "chihuahua": {"title": "Chihuahua"},
    "guadalajara": {"title": "Guadalajara, MX"},
    "guanajuato": {"title": "Guanajuato"},
    "hermosillo": {"title": "Hermosillo"},
    "juarez": {"title": "Ciudad Ju\u00e1rez"},
    "mazatlan": {"title": "Mazatl\u00e1n"},
    "mexicocity": {"title": "Ciudad De M\u00e9xico"},
    "monterrey": {"title": "Monterrey"},
    "oaxaca": {"title": "Oaxaca"},
    "puebla": {"title": "Puebla, MX"},
    "pv": {"title": "Puerto Vallarta"},
    "tijuana": {"title": "Tijuana, MX"},
    "veracruz": {"title": "Veracruz"},
    "yucatan": {"title": "Yucat\u00e1n"},
    "casablanca": {"title": "Morocco"},
    "amsterdam": {"title": "Amsterdam / Randstad"},
    "auckland": {"title": "Auckland, NZ"},
    "christchurch": {"title": "Christchurch"},
    "dunedin": {"title": "Dunedin, NZ"},
    "wellington": {"title": "Wellington"},
    "managua": {"title": "Nicaragua"},
    "oslo": {"title": "Norway"},
    "pakistan": {"title": "Pakistan"},
    "panama": {"title": "Panama"},
    "lima": {"title": "Peru"},
    "bacolod": {"title": "Bacolod"},
    "cdo": {"title": "Cagayan De Oro"},
    "cebu": {"title": "Cebu"},
    "davaocity": {"title": "Davao City"},
    "iloilo": {"title": "Iloilo"},
    "manila": {"title": "Manila"},
    "naga": {"title": "Bicol Region"},
    "pampanga": {"title": "Pampanga"},
    "zamboanga": {"title": "Zamboanga"},
    "warsaw": {"title": "Poland"},
    "faro": {"title": "Faro / Algarve"},
    "lisbon": {"title": "Lisboa"},
    "porto": {"title": "Porto"},
    "puertorico": {"title": "Puerto Rico"},
    "bucharest": {"title": "Romania"},
    "moscow": {"title": "\u041c\u043e\u0441\u043a\u0432\u0430"},
    "stpetersburg": {
        "title": "\u0421. \u041f\u0435\u0442\u0435\u0440\u0431\u0443\u0440\u0433, Ru"
    },
    "singapore": {"title": "Singapore"},
    "capetown": {"title": "Cape Town"},
    "durban": {"title": "Durban"},
    "johannesburg": {"title": "Johannesburg"},
    "pretoria": {"title": "Pretoria"},
    "alicante": {"title": "Alicante"},
    "baleares": {"title": "Baleares"},
    "barcelona": {"title": "Barcelona"},
    "bilbao": {"title": "Bilbao"},
    "cadiz": {"title": "C\u00e1diz"},
    "canarias": {"title": "Canarias"},
    "granada": {"title": "Granada"},
    "madrid": {"title": "Madrid"},
    "malaga": {"title": "M\u00e1laga"},
    "sevilla": {"title": "Sevilla"},
    "valencia": {"title": "Valencia"},
    "stockholm": {"title": "Sverige"},
    "basel": {"title": "Basel"},
    "bern": {"title": "Bern"},
    "geneva": {"title": "Gen\u00e8ve"},
    "lausanne": {"title": "Lausanne"},
    "zurich": {"title": "Z\u00fcrich"},
    "taipei": {"title": "Taiwan"},
    "virgin": {"title": "Virgin Islands"},
    "bangkok": {"title": "Thailand"},
    "tunis": {"title": "Tunisia"},
    "istanbul": {"title": "T\u00fcrkiye"},
    "ukraine": {"title": "Ukraine"},
    "dubai": {"title": "United Arab Emirates"},
    "aberdeen": {"title": "Aberdeen"},
    "bath": {"title": "Bath, UK"},
    "belfast": {"title": "Belfast"},
    "birmingham": {"title": "Birmingham / West Mids"},
    "brighton": {"title": "Brighton"},
    "bristol": {"title": "Bristol"},
    "cambridge": {"title": "Cambridge, UK"},
    "cardiff": {"title": "Cardiff / Wales"},
    "coventry": {"title": "Coventry, UK"},
    "derby": {"title": "Derby, UK"},
    "devon": {"title": "Devon & Cornwall"},
    "dundee": {"title": "Dundee"},
    "eastmids": {"title": "East Midlands"},
    "edinburgh": {"title": "Edinburgh"},
    "essex": {"title": "Essex, UK"},
    "glasgow": {"title": "Glasgow"},
    "hampshire": {"title": "Hampshire"},
    "kent": {"title": "Kent, UK"},
    "leeds": {"title": "Leeds"},
    "liverpool": {"title": "Liverpool"},
    "london": {"title": "London, UK"},
    "manchester": {"title": "Manchester, UK"},
    "newcastle": {"title": "Newcastle / Ne England"},
    "norwich": {"title": "East Anglia"},
    "nottingham": {"title": "Nottingham, UK"},
    "oxford": {"title": "Oxford, UK"},
    "sheffield": {"title": "Sheffield"},
    "abilene": {"title": "Abilene, TX"},
    "akroncanton": {"title": "Akron / Canton"},
    "albany": {"title": "Albany, NY"},
    "albanyga": {"title": "Albany, GA"},
    "albuquerque": {"title": "Albuquerque"},
    "allentown": {"title": "Lehigh Valley"},
    "altoona": {"title": "Altoona-Johnstown"},
    "amarillo": {"title": "Amarillo, TX"},
    "ames": {"title": "Ames, IA"},
    "anchorage": {"title": "Anchorage / Mat-Su"},
    "annapolis": {"title": "Annapolis, MD"},
    "annarbor": {"title": "Ann Arbor, MI"},
    "appleton": {"title": "Appleton-Oshkosh-Fdl"},
    "asheville": {"title": "Asheville, NC"},
    "ashtabula": {"title": "Ashtabula, OH"},
    "athensga": {"title": "Athens, GA"},
    "athensohio": {"title": "Athens, OH"},
    "atlanta": {
        "scope": {
            "atl": {"title": "City of Atlanta"},
            "eat": {"title": "Otp East"},
            "nat": {"title": "Otp North"},
            "sat": {"title": "Otp South"},
            "wat": {"title": "Otp West"},
        },
        "title": "Atlanta, GA",
    },
    "auburn": {"title": "Auburn, AL"},
    "austin": {"title": "Austin, TX"},
    "bakersfield": {"title": "Bakersfield, CA"},
    "baltimore": {"title": "Baltimore, MD"},
    "batonrouge": {"title": "Baton Rouge"},
    "battlecreek": {"title": "Battle Creek, MI"},
    "beaumont": {"title": "Beaumont / Port Arthur"},
    "bellingham": {"title": "Bellingham, WA"},
    "bemidji": {"title": "Bemidji, MN"},
    "bend": {"title": "Bend, OR"},
    "bgky": {"title": "Bowling Green, KY"},
    "bham": {"title": "Birmingham, AL"},
    "bigbend": {"title": "Southwest Tx"},
    "billings": {"title": "Billings, MT"},
    "binghamton": {"title": "Binghamton, NY"},
    "bismarck": {"title": "Bismarck, ND"},
    "blacksburg": {"title": "New River Valley"},
    "bloomington": {"title": "Bloomington, IN"},
    "bn": {"title": "Bloomington-Normal"},
    "boise": {"title": "Boise, ID"},
    "boone": {"title": "Boone, NC"},
    "boston": {
        "scope": {
            "bmw": {"title": "Metro West"},
            "gbs": {"title": "Boston/Cambridge/Brookline"},
            "nos": {"title": "North Shore"},
            "nwb": {"title": "Northwest/Merrimack"},
            "sob": {"title": "South Shore"},
        },
        "title": "Boston",
    },
    "boulder": {"title": "Boulder, CO"},
    "bozeman": {"title": "Bozeman, MT"},
    "brainerd": {"title": "Brainerd, MN"},
    "brownsville": {"title": "Brownsville, TX"},
    "brunswick": {"title": "Brunswick, GA"},
    "buffalo": {"title": "Buffalo, NY"},
    "butte": {"title": "Butte, MT"},
    "carbondale": {"title": "Southern Illinois"},
    "catskills": {"title": "Catskills"},
    "cedarrapids": {"title": "Cedar Rapids, IA"},
    "cenla": {"title": "Central Louisiana"},
    "centralmich": {"title": "Central Michigan"},
    "cfl": {"title": "Heartland Florida"},
    "chambana": {"title": "Champaign Urbana"},
    "chambersburg": {"title": "Cumberland Valley"},
    "charleston": {"title": "Charleston, SC"},
    "charlestonwv": {"title": "Charleston, WV"},
    "charlotte": {"title": "Charlotte, NC"},
    "charlottesville": {"title": "Charlottesville, VA"},
    "chattanooga": {"title": "Chattanooga, TN"},
    "chautauqua": {"title": "Chautauqua, NY"},
    "chicago": {
        "scope": {
            "chc": {"title": "City of Chicago"},
            "nch": {"title": "North Chicagoland"},
            "nwc": {"title": "Northwest Suburbs"},
            "nwi": {"title": "Northwest Indiana"},
            "sox": {"title": "South Chicagoland"},
            "wcl": {"title": "West Chicagoland"},
        },
        "title": "Chicago",
    },
    "chico": {"title": "Chico, CA"},
    "chillicothe": {"title": "Chillicothe, OH"},
    "cincinnati": {"title": "Cincinnati, OH"},
    "clarksville": {"title": "Clarksville, TN"},
    "cleveland": {"title": "Cleveland, OH"},
    "clovis": {"title": "Clovis / Portales"},
    "cnj": {"title": "Central Nj"},
    "collegestation": {"title": "College Station, TX"},
    "columbia": {"title": "Columbia, SC"},
    "columbiamo": {"title": "Columbia / Jeff City"},
    "columbus": {"title": "Columbus, OH"},
    "columbusga": {"title": "Columbus, GA"},
    "cookeville": {"title": "Cookeville, TN"},
    "corpuschristi": {"title": "Corpus Christi, TX"},
    "corvallis": {"title": "Corvallis/Albany"},
    "cosprings": {"title": "Colorado Springs"},
    "csd": {"title": "Pierre / Central Sd"},
    "dallas": {
        "scope": {
            "dal": {"title": "Dallas"},
            "ftw": {"title": "Fort Worth"},
            "mdf": {"title": "Mid Cities"},
            "ndf": {"title": "North Dfw"},
            "sdf": {"title": "South Dfw"},
        },
        "title": "Dallas / Fort Worth",
    },
    "danville": {"title": "Danville"},
    "dayton": {"title": "Dayton / Springfield"},
    "daytona": {"title": "Daytona Beach"},
    "delaware": {"title": "Delaware"},
    "denver": {"title": "Denver, CO"},
    "desmoines": {"title": "Des Moines, IA"},
    "detroit": {
        "scope": {
            "mcb": {"title": "Macomb County"},
            "okl": {"title": "Oakland County"},
            "wyn": {"title": "Wayne County"},
        },
        "title": "Detroit Metro",
    },
    "dothan": {"title": "Dothan, AL"},
    "dubuque": {"title": "Dubuque"},
    "duluth": {"title": "Duluth / Superior"},
    "eastco": {"title": "Eastern Co"},
    "easternshore": {"title": "Eastern Shore"},
    "eastidaho": {"title": "East Idaho"},
    "eastky": {"title": "Eastern Kentucky"},
    "eastnc": {"title": "Eastern Nc"},
    "eastoregon": {"title": "East Oregon"},
    "easttexas": {"title": "Tyler / East Tx"},
    "eauclaire": {"title": "Eau Claire, WI"},
    "elko": {"title": "Elko, NV"},
    "elmira": {"title": "Elmira-Corning"},
    "elpaso": {"title": "El Paso, TX"},
    "enid": {"title": "Northwest Ok"},
    "erie": {"title": "Erie, PA"},
    "eugene": {"title": "Eugene, OR"},
    "evansville": {"title": "Evansville, IN"},
    "fairbanks": {"title": "Fairbanks, AK"},
    "fargo": {"title": "Fargo / Moorhead"},
    "farmington": {"title": "Farmington, NM"},
    "fayar": {"title": "Fayetteville, AR"},
    "fayetteville": {"title": "Fayetteville, NC"},
    "fingerlakes": {"title": "Finger Lakes, NY"},
    "flagstaff": {"title": "Flagstaff / Sedona"},
    "florencesc": {"title": "Florence, SC"},
    "fortcollins": {"title": "Fort Collins / North Co"},
    "fortdodge": {"title": "Fort Dodge, IA"},
    "fortlauderdale": {
        "scope": {
            "brw": {"title": "Broward County"},
            "mdc": {"title": "Miami / Dade County"},
            "pbc": {"title": "Palm Beach County"},
        },
        "title": "South Florida",
    },
    "fortmyers": {
        "scope": {
            "chl": {"title": "Charlotte County"},
            "col": {"title": "Collier County"},
            "lee": {"title": "Lee County"},
        },
        "title": "Ft Myers / Sw Florida",
    },
    "fortsmith": {"title": "Fort Smith, AR"},
    "fortwayne": {"title": "Fort Wayne, IN"},
    "frederick": {"title": "Frederick, MD"},
    "fredericksburg": {"title": "Fredericksburg, VA"},
    "fresno": {"title": "Fresno / Madera"},
    "gadsden": {"title": "Gadsden-Anniston"},
    "galveston": {"title": "Galveston, TX"},
    "glensfalls": {"title": "Glens Falls, NY"},
    "goldcountry": {"title": "Gold Country"},
    "grandforks": {"title": "Grand Forks"},
    "grandisland": {"title": "Grand Island, NE"},
    "grandrapids": {"title": "Grand Rapids, MI"},
    "greatfalls": {"title": "Great Falls, MT"},
    "greenbay": {"title": "Green Bay, WI"},
    "greensboro": {"title": "Greensboro, NC"},
    "greenville": {"title": "Greenville / Upstate"},
    "gulfport": {"title": "Gulfport / Biloxi"},
    "hanford": {"title": "Hanford-Corcoran"},
    "harrisburg": {"title": "Harrisburg, PA"},
    "harrisonburg": {"title": "Harrisonburg, VA"},
    "hartford": {"title": "Hartford, CT"},
    "hattiesburg": {"title": "Hattiesburg, MS"},
    "helena": {"title": "Helena, MT"},
    "hickory": {"title": "Hickory / Lenoir"},
    "hiltonhead": {"title": "Hilton Head"},
    "holland": {"title": "Holland, MI"},
    "honolulu": {"title": "Hawaii"},
    "houma": {"title": "Houma, LA"},
    "houston": {"title": "Houston, TX"},
    "hudsonvalley": {"title": "Hudson Valley, NY"},
    "humboldt": {"title": "Humboldt County"},
    "huntington": {"title": "Huntington-Ashland"},
    "huntsville": {"title": "Huntsville / Decatur"},
    "imperial": {"title": "Imperial County"},
    "indianapolis": {"title": "Indianapolis"},
    "inlandempire": {"title": "Inland Empire, CA"},
    "iowacity": {"title": "Iowa City, IA"},
    "ithaca": {"title": "Ithaca, NY"},
    "jackson": {"title": "Jackson, MS"},
    "jacksontn": {"title": "Jackson, TN"},
    "jacksonville": {"title": "Jacksonville, FL"},
    "janesville": {"title": "Janesville, WI"},
    "jerseyshore": {"title": "Jersey Shore"},
    "jonesboro": {"title": "Jonesboro, AR"},
    "joplin": {"title": "Joplin, MO"},
    "juneau": {"title": "Southeast Alaska"},
    "jxn": {"title": "Jackson, MI"},
    "kalamazoo": {"title": "Kalamazoo, MI"},
    "kalispell": {"title": "Kalispell, MT"},
    "kansascity": {"title": "Kansas City, MO"},
    "kenai": {"title": "Kenai Peninsula"},
    "keys": {"title": "Florida Keys"},
    "killeen": {"title": "Killeen / Temple / Ft Hood"},
    "kirksville": {"title": "Kirksville, MO"},
    "klamath": {"title": "Klamath Falls, OR"},
    "knoxville": {"title": "Knoxville, TN"},
    "kokomo": {"title": "Kokomo, IN"},
    "kpr": {"title": "Kennewick-Pasco-Richland"},
    "ksu": {"title": "Manhattan, KS"},
    "lacrosse": {"title": "La Crosse, WI"},
    "lafayette": {"title": "Lafayette, LA"},
    "lakecharles": {"title": "Lake Charles, LA"},
    "lakecity": {"title": "North Central Fl"},
    "lakeland": {"title": "Lakeland, FL"},
    "lancaster": {"title": "Lancaster, PA"},
    "lansing": {"title": "Lansing, MI"},
    "laredo": {"title": "Laredo, TX"},
    "lasalle": {"title": "La Salle Co"},
    "lascruces": {"title": "Las Cruces, NM"},
    "lasvegas": {"title": "Las Vegas"},
    "lawrence": {"title": "Lawrence, KS"},
    "lawton": {"title": "Lawton, OK"},
    "lewiston": {"title": "Lewiston / Clarkston"},
    "lexington": {"title": "Lexington, KY"},
    "limaohio": {"title": "Lima / Findlay"},
    "lincoln": {"title": "Lincoln, NE"},
    "littlerock": {"title": "Little Rock"},
    "logan": {"title": "Logan, UT"},
    "longisland": {"title": "Long Island, NY"},
    "losangeles": {
        "scope": {
            "ant": {"title": "Antelope Valley"},
            "lac": {"title": "Central La 213/323"},
            "lgb": {"title": "Long Beach / 562"},
            "sfv": {"title": "San Fernando Valley"},
            "sgv": {"title": "San Gabriel Valley"},
            "wst": {"title": "Westside-Southbay-310"},
        },
        "title": "Los Angeles",
    },
    "louisville": {"title": "Louisville, KY"},
    "loz": {"title": "Lake of The Ozarks"},
    "lubbock": {"title": "Lubbock, TX"},
    "lynchburg": {"title": "Lynchburg, VA"},
    "macon": {"title": "Macon / Warner Robins"},
    "madison": {"title": "Madison, WI"},
    "maine": {"title": "Maine"},
    "mankato": {"title": "Mankato, MN"},
    "mansfield": {"title": "Mansfield, OH"},
    "marshall": {"title": "Southwest Mn"},
    "martinsburg": {"title": "Eastern Panhandle"},
    "masoncity": {"title": "Mason City, IA"},
    "mattoon": {"title": "Mattoon-Charleston"},
    "mcallen": {"title": "Mcallen / Edinburg"},
    "meadville": {"title": "Meadville, PA"},
    "medford": {"title": "Medford-Ashland"},
    "memphis": {"title": "Memphis, TN"},
    "merced": {"title": "Merced, CA"},
    "meridian": {"title": "Meridian, MS"},
    "miami": {
        "scope": {
            "brw": {"title": "Broward County"},
            "mdc": {"title": "Miami / Dade County"},
        },
        "title": "South Florida",
    },
    "milwaukee": {"title": "Milwaukee, WI"},
    "minneapolis": {
        "scope": {
            "ank": {"title": "Anoka/Chisago/Isanti"},
            "csw": {"title": "Carver/Sherburne/Wright"},
            "dak": {"title": "Dakota / Scott"},
            "hnp": {"title": "Hennepin County"},
            "ram": {"title": "Ramsey County"},
            "wsh": {"title": "Washington Co / Wi"},
        },
        "title": "Minneapolis / St Paul",
    },
    "missoula": {"title": "Missoula, MT"},
    "mobile": {"title": "Mobile, AL"},
    "modesto": {"title": "Modesto, CA"},
    "mohave": {"title": "Mohave County"},
    "monroe": {"title": "Monroe, LA"},
    "monroemi": {"title": "Monroe, MI"},
    "montana": {"title": "Eastern Montana"},
    "monterey": {"title": "Monterey Bay"},
    "montgomery": {"title": "Montgomery, AL"},
    "morgantown": {"title": "Morgantown, WV"},
    "moseslake": {"title": "Moses Lake, WA"},
    "muncie": {"title": "Muncie / Anderson"},
    "muskegon": {"title": "Muskegon, MI"},
    "myrtlebeach": {"title": "Myrtle Beach, SC"},
    "nacogdoches": {"title": "Deep East Texas"},
    "nashville": {"title": "Nashville, TN"},
    "natchez": {"title": "Southwest Ms"},
    "nd": {"title": "North Dakota"},
    "nesd": {"title": "Northeast Sd"},
    "newhaven": {"title": "New Haven, CT"},
    "newjersey": {"title": "North Jersey"},
    "newlondon": {"title": "Eastern Ct"},
    "neworleans": {"title": "New Orleans"},
    "newyork": {
        "scope": {
            "brk": {"title": "Brooklyn"},
            "brx": {"title": "Bronx"},
            "fct": {"title": "Fairfield Co, CT"},
            "jsy": {"title": "New Jersey"},
            "lgi": {"title": "Long Island"},
            "mnh": {"title": "Manhattan"},
            "que": {"title": "Queens"},
            "stn": {"title": "Staten Island"},
            "wch": {"title": "Westchester"},
        },
        "title": "New York City",
    },
    "nh": {"title": "New Hampshire"},
    "nmi": {"title": "Northern Michigan"},
    "norfolk": {"title": "Norfolk / Hampton Roads"},
    "northernwi": {"title": "Northern Wi"},
    "northmiss": {"title": "North Mississippi"},
    "northplatte": {"title": "North Platte, NE"},
    "nwct": {"title": "Northwest Ct"},
    "nwga": {"title": "Northwest Ga"},
    "nwks": {"title": "Northwest Ks"},
    "odessa": {"title": "Odessa / Midland"},
    "ogden": {"title": "Ogden-Clearfield"},
    "okaloosa": {"title": "Okaloosa / Walton"},
    "oklahomacity": {"title": "Oklahoma City"},
    "olympic": {"title": "Olympic Peninsula"},
    "omaha": {"title": "Omaha / Council Bluffs"},
    "onslow": {"title": "Jacksonville, NC"},
    "orangecounty": {"title": "Orange County, CA"},
    "oregoncoast": {"title": "Oregon Coast"},
    "orlando": {"title": "Orlando, FL"},
    "ottumwa": {"title": "Southeast Ia"},
    "outerbanks": {"title": "Outer Banks"},
    "owensboro": {"title": "Owensboro, KY"},
    "palmsprings": {"title": "Palm Springs, CA"},
    "panamacity": {"title": "Panama City, FL"},
    "parkersburg": {"title": "Parkersburg-Marietta"},
    "pennstate": {"title": "State College, PA"},
    "pensacola": {"title": "Pensacola, FL"},
    "peoria": {"title": "Peoria, IL"},
    "philadelphia": {"title": "Philadelphia"},
    "phoenix": {
        "scope": {
            "cph": {"title": "Central/South Phx"},
            "evl": {"title": "East Valley"},
            "nph": {"title": "Phx North"},
            "wvl": {"title": "West Valley"},
        },
        "title": "Phoenix, AZ",
    },
    "pittsburgh": {"title": "Pittsburgh, PA"},
    "plattsburgh": {"title": "Plattsburgh-Adirondacks"},
    "poconos": {"title": "Poconos"},
    "porthuron": {"title": "Port Huron, MI"},
    "portland": {
        "scope": {
            "clc": {"title": "Clackamas County"},
            "clk": {"title": "Clark/Cowlitz, WA"},
            "grg": {"title": "Columbia Gorge"},
            "mlt": {"title": "Multnomah County"},
            "nco": {"title": "North Coast"},
            "wsc": {"title": "Washington County"},
            "yam": {"title": "Yamhill Co"},
        },
        "title": "Portland, OR",
    },
    "potsdam": {"title": "Potsdam-Canton-Massena"},
    "providence": {"title": "Rhode Island"},
    "provo": {"title": "Provo / Orem"},
    "pueblo": {"title": "Pueblo, CO"},
    "pullman": {"title": "Pullman / Moscow"},
    "quadcities": {"title": "Quad Cities, Ia/Il"},
    "quincy": {"title": "Western Il"},
    "racine": {"title": "Kenosha-Racine"},
    "raleigh": {"title": "Raleigh / Durham / Ch"},
    "rapidcity": {"title": "Rapid City / West Sd"},
    "reading": {"title": "Reading, PA"},
    "redding": {"title": "Redding, CA"},
    "reno": {"title": "Reno / Tahoe"},
    "richmond": {"title": "Richmond, VA"},
    "richmondin": {"title": "Richmond, IN"},
    "roanoke": {"title": "Roanoke, VA"},
    "rochester": {"title": "Rochester, NY"},
    "rockford": {"title": "Rockford, IL"},
    "rockies": {"title": "High Rockies"},
    "roswell": {"title": "Roswell / Carlsbad"},
    "sacramento": {"title": "Sacramento"},
    "saginaw": {"title": "Saginaw-Midland-Baycity"},
    "salem": {"title": "Salem, OR"},
    "salina": {"title": "Salina, KS"},
    "saltlakecity": {"title": "Salt Lake City"},
    "sanangelo": {"title": "San Angelo, TX"},
    "sanantonio": {"title": "San Antonio"},
    "sandiego": {
        "scope": {
            "csd": {"title": "City of San Diego"},
            "esd": {"title": "East San Diego County"},
            "nsd": {"title": "North San Diego County"},
            "ssd": {"title": "South San Diego County"},
        },
        "title": "San Diego",
    },
    "sandusky": {"title": "Sandusky, OH"},
    "sanmarcos": {"title": "San Marcos, TX"},
    "santafe": {"title": "Santa Fe / Taos"},
    "santamaria": {"title": "Santa Maria, CA"},
    "sarasota": {"title": "Sarasota-Bradenton"},
    "savannah": {"title": "Savannah / Hinesville"},
    "scottsbluff": {"title": "Scottsbluff / Panhandle"},
    "scranton": {"title": "Scranton / Wilkes-Barre"},
    "sd": {"title": "South Dakota"},
    "seattle": {
        "scope": {
            "est": {"title": "Eastside"},
            "kit": {"title": "Kitsap / West Puget"},
            "oly": {"title": "Olympia / Thurston"},
            "see": {"title": "Seattle"},
            "skc": {"title": "South King Co"},
            "sno": {"title": "Snohomish County"},
            "tac": {"title": "Tacoma / Pierce"},
        },
        "title": "Seattle-Tacoma",
    },
    "seks": {"title": "Southeast Ks"},
    "semo": {"title": "Southeast Missouri"},
    "sfbay": {
        "scope": {
            "eby": {"title": "East Bay Area"},
            "nby": {"title": "North Bay / Marin"},
            "pen": {"title": "Peninsula"},
            "sby": {"title": "South Bay Area"},
            "scz": {"title": "Santa Cruz Co"},
            "sfc": {"title": "City of San Francisco"},
        },
        "title": "Sf Bay Area",
    },
    "sheboygan": {"title": "Sheboygan, WI"},
    "shoals": {"title": "Florence / Muscle Shoals"},
    "showlow": {"title": "Show Low, AZ"},
    "shreveport": {"title": "Shreveport, LA"},
    "sierravista": {"title": "Sierra Vista, AZ"},
    "siouxcity": {"title": "Sioux City, IA"},
    "siouxfalls": {"title": "Sioux Falls / Se Sd"},
    "slo": {"title": "San Luis Obispo"},
    "smd": {"title": "Southern Maryland"},
    "southbend": {"title": "South Bend / Michiana"},
    "southcoast": {"title": "South Coast, MA"},
    "southjersey": {"title": "South Jersey"},
    "spacecoast": {"title": "Space Coast, FL"},
    "spokane": {"title": "Spokane / Coeur D'Alene"},
    "springfield": {"title": "Springfield, MO"},
    "springfieldil": {"title": "Springfield, IL"},
    "statesboro": {"title": "Statesboro, GA"},
    "staugustine": {"title": "St Augustine, FL"},
    "stcloud": {"title": "St Cloud, MN"},
    "stgeorge": {"title": "St George, UT"},
    "stillwater": {"title": "Stillwater, OK"},
    "stjoseph": {"title": "St Joseph"},
    "stlouis": {"title": "St Louis, MO"},
    "stockton": {"title": "Stockton, CA"},
    "susanville": {"title": "Susanville, CA"},
    "swks": {"title": "Southwest Ks"},
    "swmi": {"title": "Southwest Michigan"},
    "swv": {"title": "Southern Wv"},
    "swva": {"title": "Southwest Va"},
    "syracuse": {"title": "Syracuse, NY"},
    "tallahassee": {"title": "Tallahassee"},
    "tampa": {
        "scope": {
            "hdo": {"title": "Hernando Co"},
            "hil": {"title": "Hillsborough Co"},
            "pnl": {"title": "Pinellas Co"},
            "psc": {"title": "Pasco Co"},
        },
        "title": "Tampa Bay Area",
    },
    "terrehaute": {"title": "Terre Haute, IN"},
    "texarkana": {"title": "Texarkana"},
    "texoma": {"title": "Texoma"},
    "thumb": {"title": "The Thumb, MI"},
    "tippecanoe": {"title": "Lafayette / West Lafayette"},
    "toledo": {"title": "Toledo, OH"},
    "topeka": {"title": "Topeka, KS"},
    "tricities": {"title": "Tri-Cities, TN"},
    "tucson": {"title": "Tucson, AZ"},
    "tulsa": {"title": "Tulsa, OK"},
    "tuscaloosa": {"title": "Tuscaloosa"},
    "tuscarawas": {"title": "Tuscarawas Co"},
    "twinfalls": {"title": "Twin Falls, ID"},
    "twintiers": {"title": "Twin Tiers Ny/Pa"},
    "up": {"title": "Upper Peninsula, MI"},
    "utica": {"title": "Utica-Rome-Oneida"},
    "valdosta": {"title": "Valdosta, GA"},
    "ventura": {"title": "Ventura County"},
    "vermont": {"title": "Vermont"},
    "victoriatx": {"title": "Victoria, TX"},
    "visalia": {"title": "Visalia-Tulare"},
    "waco": {"title": "Waco, TX"},
    "washingtondc": {"title": "Washington, DC"},
    "waterloo": {"title": "Waterloo / Cedar Falls"},
    "watertown": {"title": "Watertown, NY"},
    "wausau": {"title": "Wausau, WI"},
    "wenatchee": {"title": "Wenatchee, WA"},
    "westernmass": {"title": "Western Massachusetts"},
    "westky": {"title": "Western Ky"},
    "westmd": {"title": "Western Maryland"},
    "westslope": {"title": "Western Slope"},
    "wheeling": {"title": "Northern Panhandle"},
    "wichita": {"title": "Wichita, KS"},
    "wichitafalls": {"title": "Wichita Falls, TX"},
    "williamsport": {"title": "Williamsport, PA"},
    "wilmington": {"title": "Wilmington, NC"},
    "winchester": {"title": "Winchester, VA"},
    "winstonsalem": {"title": "Winston-Salem, NC"},
    "worcester": {"title": "Worcester / Central Ma"},
    "wv": {"title": "West Virginia (Old)"},
    "wyoming": {"title": "Wyoming"},
    "yakima": {"title": "Yakima, WA"},
    "york": {"title": "York, PA"},
    "youngstown": {"title": "Youngstown, OH"},
    "yubasutter": {"title": "Yuba-Sutter, CA"},
    "yuma": {"title": "Yuma, AZ"},
    "zanesville": {"title": "Zanesville / Cambridge"},
    "montevideo": {"title": "Montevideo"},
    "caracas": {"title": "Venezuela"},
    "vietnam": {"title": "Vietnam"},
}
