# ipelago (in Python)

CLI personal microblog (命令行个人微博客)

纯命令行操作，包括两方面功能：1.写微博客并生成静态网站 (HTML 和 RSS); 2.订阅别人的 RSS。


## ipelago 之名

ipelago 之名源于群岛的英文 archipelago, 如果我们每一个人是一座孤岛，那么当我们搭建自己的微博客，大家的微博客聚在一起就可以形成群岛。


## 主要功能 (写微博客、订阅 RSS)

### 写微博客

- 多种方式方便写博文（包括命令行输入、获取剪贴板内容、获取文件内容、通过简陋的 GUI 窗口输入）。
- 可生成静态网站 (包括 HTML 和 RSS), 这些静态文件可通过 GitHub Pages 或类似服务搭建你的私人微博客供别人浏览、订阅。
- 可区分公开消息与隐私消息，只有公开消息才会对外发布，隐私消息只能本地浏览。
- 有简单的 #标签 功能与搜索功能 (井号前必须有空格，以空格结尾，长度上限 30 bytes，超过长度不能形成标签)。

### 订阅 RSS

- 可通过 RSS 订阅别人的微博客。
- 只支持微博客（一条消息只有一两句话），不支持正常博客（长文章），因此数据库体积不会爆涨，只会一直保持很小的体积。
- 有限订阅（意思是不保存全部订阅消息，看到特别喜欢的内容可执行收藏命令，收藏的消息才会永久保存）。
- 可设置 proxy, 方便与翻墙软件搭配使用。

### 减少烦躁和焦虑

一般通过 App 或网页浏览消息时，会一目十行，快速上下滑动消息列表，这种操作有可能加强烦躁和焦虑感。

ipelago 也可一次列举多条消息，但更提倡使用逐条浏览功能，每次只显示一条消息，并且可以记住位置，随时离开去做别的事情，回头继续从上次中断的地方接着阅读。

因此，有助于减少烦躁与焦虑。


## 安装与初始化

安装非常简单，只要 `pip install ipelago` 即可。

安装后，第一次正式使用前，必须执行 'ago init [name]' 进行初始化，其中 name 是你的微博客名称，对外发布时别人可以看到。（避免每次执行命令都要初始化）

## 密码

不做密码功能了，通过另外写脚本进行加密解密。

## publish (生成 html 与 atom.xml)

第一次发布时要求填写 feed-link, feed-title, author-name.

## 订阅源的 id

订阅一个 feed 时，系统会自动给一个唯一 ID, 以方便操作。用户可修改该 ID (只要不与现有 ID 冲突)。

## 每条订阅消息的 id

每条订阅消息会得到一个随机 ID, 方便操作。平时通过简化 id (例如 8Q4K) 来操作，当简化 id 有冲突时则提示完整 id (例如 8Q4K-R8THCY 与 8Q4K-R8THXU) 让用户选择。不分大小写。

## Post (写微博客)

- `ago post [message]` 发送一条公开消息（可通过 HTML 及 RSS 对外发布）。
- `ago post -pri [message]` 发送一条隐私消息（仅本地可见，不加密）。
- `ago post` 如果不输入 message, 则默认发送剪贴板内容。
- `ago post --gui` 弹出一个发送消息的 GUI 窗口。
- `ago post --file [filename]` 发送文件内容。
- `ago post -h` 帮助信息。

### 切换与删除

- `ago toggle [id]` 切换公开/隐私。
- `ago delete [id]` 删除一条消息。

但要注意，切换公开/隐私、或删除消息后，要重新 publish 发布消息，才能反映到静态网站中（关于发布静态网站，请看下面 Publish 章节）。


## Publish (发布到网上)

使用 'ago publish' 命令可生成 HTML 文件及 RSS 文件，通过 GitHub Pages 或类似的免费服务即可创建你的个人微博客网站。

第一次发布时，需要填写微博客名称、作者名称等信息。

- `ago publish -info` 显示微博客信息
- `ago publish -g` 打开 GUI 窗口填写微博客信息
- `ago publish --set-link` [必填] 设置 RSS 的链接（可先随便填一个，可随时更改）
- `ago publish --set-title` [必填] 设置微博客标题
- `ago publish --set-author` [必填] 设置作者名 (或作者email)
- `ago publish --set-website` [选填] 设置任意网址 (通常是你的个人网站或博客的网址)

link, title,  author 这三项信息都必须有内容，才能执行 `ago publish` 命令生成网站文件。但可以先随便填，生成后看看效果，以后可以随时修改这些信息。其中 link 是指别人通过 RSS 订阅这个微博客的网址，请务必后续发布到到网上后找到正确的网址，再回头修改。

`ago publish` 命令默认生成静态文件到当前目录的 'public' 文件夹，也可指定另一个文件夹 `ago publish --output [dir]`。生成文件后，双击其中的 'index.html' 即可预览效果（我用了很简单的样式，懂前端的朋友可自行修改样式）。

生成的 HTML 页面默认每页显示 50 条消息，也可自定义 `ago publish --page-n [number]`.


## Timeline (阅读自己微博客)

`ago tl` 系列命令专门阅读自己的微博客。关于订阅的 RSS 请看后文的 `ago news` 命令。

- `ago tl` 阅读下一条消息（完全等同于 `ago tl -next`）
- `ago tl -first` 阅读最新一条消息（同时 cursor 指向第二条消息）
- `ago tl -next` 阅读下一条消息（同时 cursor 移动一步）
- `ago tl --goto [YYYY-MM-DD]` 让 cursor 移动到指定日期附近

只有以上命令涉及 cursor 变化，并且不区分公开/隐私。  
以下命令不影响 cursor，并且可以区分公开/隐私/收藏 (-pub/-pri/-fav)。

- `ago tl -today` 阅读今天的全部消息 (包括公开与隐私，不包括收藏)
- `ago tl -today --public` 阅读今天的全部消息 (限定公开消息)
- `ago tl -today --private` 阅读今天的全部消息 (限定隐私消息)
- `ago tl -today --favorite` 阅读今天的全部消息 (限定收藏消息)
- `ago tl -yesterday` 阅读昨天的全部消息
- `ago tl -date [date]` 阅读指定日期的全部消息（可以指定一天、一个月或者一年）（有条数上限）
- `ago tl -count [date]` 统计指定日期的消息条数（可以按天/按月/按年统计）


## Proxy (代理)

- `ago --info` 查看当前 proxy 设定。
- `ago --set-proxy [url]` 设置代理地址（有些 rss feed 需要翻墙才能订阅）
- `ago --set-proxy true` 启用代理。
- `ago --set-proxy false` 不使用代理。

例如: `ago --set-proxy http://127.0.0.1:1081` (注意网址要以 http 开头)


## Subscribe (订阅 RSS)

- `ago news -follow [url]` 订阅 Atom/RSS
- `ago news --list` 查看已订阅的 RSS 列表
- `ago news -delete [id]` 删除指定的 RSS (取消订阅并删除消息)
- `ago news -feed [id] --set-id [new-id]` 修改指定 feed 的 id

默认采用 '--parser Base' 解析 RSS 内容，舍弃每篇博文的 title (因为有时 title 与正文重复)。

建议先看看 RSS 源文件，看 title 有没有必要显示，如果需要保留 title, 可使用以下命令订阅：

- `ago news -follow [url] --parser HasTitle`

也可在订阅后随时更改解析器：

- `ago news --update [id] --parser HasTitle`

有的 RSS 源文件在提供 `<content>` 的同时也提供 `<summary>`, 对于这种情况，建议采用 '--parser HasSuammry'。

### 真实的订阅例子

- `ago news -follow https://douchi.space/@mtfront.rss`
- `ago news -follow https://v2ex.com/index.xml -p HasTitle`
- `ago news -follow https://geeknote.net/Rei/feed.atom -p HasSummary`

### 更新消息

需要手动执行命令才会拉取新消息（注意，旧消息不会被保存，拉取新消息会覆盖旧消息，可以用命令 `ago like [id]` 永久保全指定消息）。

- `ago news --update all` 批量更新
- `ago news --update [id]` 只更新指定的源

默认每个源每 24 小时只能更新一次，可使用 '-force' 参数强制更新，比如 `ago news -force -u [id]`, 但为了节约资源及减少焦虑，建议不要频繁更新。

### News (阅读订阅的消息)

`ago news` 系列命令专门用来阅读别人的 RSS 消息。关于阅读自己的微博客请看上面的 `ago tl` 命令。

- `ago news` 阅读下一条消息（完全等同 `ago news --next`）
- `ago news -first` 阅读最新一条消息（同时 cursor 指向第二条消息）
- `ago news -next` 阅读下一条消息（同时 cursor 移动一步）
- `ago news --goto [YYYY-MM-DD]` 让 cursor 移动到指定日期附近
- `ago news -feed [id]` 阅读指定 feed 的消息（默认显示 9 条，可使用 --limit 参数指定条数）
- `ago news --toggle-link` 是否显示消息本身的链接 (默认不显示)
- `ago news -like [id]` 收藏消息。
- `ago copy [id] -link` 复制消的链接

### Like (收藏)

本软件的订阅 RSS 功能，是“有限订阅”，意思是: 1.不保存旧消息; 2.每条消息限制字数，超出部分会被截掉。

这样设计的原因是：

- ipelago 的定位是 “微博客”, 长篇文章不符合微博客的定位。
- ipelago 的主要操作界面是纯字符的终端，不适合阅读长篇文章。
- ipelago 对全文搜索没做优化，因此需要限制字数才能确保搜索功能好用。
- 限制字数有利于防止数据库体积膨胀，长年使用也可以保持一个很小的体积。

由于有限订阅不保存旧消息，因此提供一个 Like 功能，使用 `ago like [id]` 命令可收藏指定的消息，收藏的消息会永久保存在数据库中。

- `ago like [id]` 完全等同 `ago news -like [id]`, 收藏消息。
- `ago tl -fav` 阅读最近收藏的几条消息
- `ago tl -fav -today` 阅读今天的全部消息 (限定收藏消息)
- `ago tl -fav -yesterday` 阅读昨天的全部消息 (限定收藏消息)
- `ago tl -fav -date [date]` 阅读指定日期的全部消息 (限定收藏消息)
- `ago tl -fav -count [date]` 统计指定日期的消息条数 (限定收藏消息)


## Tags and Search (标签与搜索)

标签必须以“空格井号”开头，以空格结尾，并且不超过 TagSizeLimit  
(注意：并不是加了井号就一定能形成标签，必须以 " #" 开头，以空格结尾，并且不超过长度上限才能形成标签。)

`ago search [keyword]` 自动先采用 '-tag' 方式搜索，如果没有结果再自动改成 '-contain' 方式搜索。
`ago search -tag/--by-tag [tag]` 通过标签搜索消息，效率较高。
`ago search -contain [keyword]` 搜索内容包含 keyword 的消息，效率较低。
`ago search --all-tags` 列出全部标签
`ago search --all-tags [keyword]` 在全部标签中查找包含 keyword 的标签名
`ago search --all-feeds` 列出全部已订阅的源，等同 `ago news --list`
`ago search --all-feeds keyword` 查找源名称中包含 keyword 的源

以上命令默认包括 公开/隐私/收藏/订阅 四种消息，但都可以加 '-bucket' 参数限定只搜索其中一的消息，例如：

- `ago search [keyword] -bucket fav` 仅搜索收藏的消息。
- `ago search [keyword] -bucket public` 仅搜索我的公开消息。

以上命令默认最多列出 9 个结果，可加参数 '-limit' 更改上限，例如：

- `ago search [keyword] -limit 30`


## 特殊技巧

### 特殊的订阅方法

我遇到了一些 rss feed 受到 Cloudflare 的保护而无法通过 python requests 访问，但可以用浏览器直接访问，比如这个 https://mstdn.jp/@nekodayo.rss

对于这种情况，可以用浏览器访问，按 Ctrl+S 保存 rss 到本地，建议保存到一个固定的文件夹，比如我保存在 D:\rss_feeds 里。

然后就可以这样订阅 `ago news -follow D:\rss_feeds\@nekodayo.rss`

但问题也很明显，后续需要手动下载 rss 覆盖同名文件才能更新内容，先这样应付吧，以后再想别的办法。

### Zen Mode (专注模式)

我自己很喜欢这个模式，简单来说只是自动清屏而已，效果是减少浮躁，使人宁静。 'ago tl' 系列命令与 'ago news' 系列命令可使用专注模式，例如：

- `ago news -zen`
- `ago tl -zen`
- `ago tl -zen -today`

也可以设置为默认使用 zen mode:

- `ago --toggle-zen` 切换默认使用/不使用 zen mode

设置为默认使用 zen mode 后，不加 '-zen' 参数也会自动清屏。


## 备份

使用命令 `ago publish -info` 显示微博客信息，可以看到数据库位置。

