from _typeshed import Incomplete
from fwhunt_scan.uefi_analyzer import NvramVariable as NvramVariable, UefiAnalyzer as UefiAnalyzer, UefiGuid as UefiGuid, UefiProtocol as UefiProtocol, UefiService as UefiService
from typing import Any, Dict, List, Optional

class CodePattern:
    pattern: Incomplete
    place: Incomplete
    sw_smi_handlers: Incomplete
    child_sw_smi_handlers: Incomplete
    def __init__(self, pattern: str, place: Optional[str]) -> None: ...
    @property
    def __dict__(self): ...

class UefiRuleVariant:
    def __init__(self, rule_content: Dict[str, Any]) -> None: ...
    @property
    def code(self) -> Dict[str, List[CodePattern]]: ...
    @property
    def strings(self) -> Dict[str, List[str]]: ...
    @property
    def wide_strings(self) -> Dict[str, List[Dict[str, str]]]: ...
    @property
    def hex_strings(self) -> Dict[str, List[str]]: ...
    @property
    def nvram_vars(self) -> Dict[str, List[NvramVariable]]: ...
    @property
    def protocols(self) -> Dict[str, List[UefiProtocol]]: ...
    @property
    def ppi_list(self) -> Dict[str, List[UefiProtocol]]: ...
    @property
    def guids(self) -> Dict[str, List[UefiGuid]]: ...

class UefiRule:
    def __init__(self, rule_path: Optional[str] = ..., rule_content: Optional[str] = ...) -> None: ...
    @property
    def author(self) -> Optional[str]: ...
    @property
    def name(self) -> Optional[str]: ...
    @property
    def version(self) -> Optional[str]: ...
    @property
    def namespace(self) -> Optional[str]: ...
    @property
    def license(self) -> Optional[str]: ...
    @property
    def cve_number(self) -> Optional[str]: ...
    @property
    def volume_guids(self) -> Optional[List[str]]: ...
    @property
    def vendor_id(self) -> Optional[str]: ...
    @property
    def cvss_score(self) -> Optional[str]: ...
    @property
    def advisory(self) -> Optional[str]: ...
    @property
    def description(self) -> Optional[str]: ...
    @property
    def url(self) -> Optional[str]: ...
    @property
    def target(self) -> Optional[str]: ...
    @property
    def variants(self) -> Dict[str, UefiRuleVariant]: ...

class UefiScannerError(Exception):
    value: Incomplete
    def __init__(self, value: str) -> None: ...

class UefiScannerRes:
    rule: Incomplete
    variant_label: Incomplete
    res: Incomplete
    def __init__(self, rule: UefiRule, variant_label: str, res: bool) -> None: ...

class UefiScanner:
    PROTOCOL: int
    PPI: int
    def __init__(self, uefi_analyzer: UefiAnalyzer, uefi_rules: List[UefiRule]) -> None: ...
    @property
    def results(self) -> List[UefiScannerRes]: ...
