from _typeshed import Incomplete
from fwhunt_scan.uefi_protocols import GUID_FROM_BYTES as GUID_FROM_BYTES
from fwhunt_scan.uefi_tables import BS_PROTOCOLS_INFO_64_BIT as BS_PROTOCOLS_INFO_64_BIT, EFI_BOOT_SERVICES_64_BIT as EFI_BOOT_SERVICES_64_BIT, EFI_PEI_SERVICES_32_BIT as EFI_PEI_SERVICES_32_BIT, EFI_RUNTIME_SERVICES_64_BIT as EFI_RUNTIME_SERVICES_64_BIT, OFFSET_TO_SERVICE as OFFSET_TO_SERVICE
from fwhunt_scan.uefi_te import TerseExecutableError as TerseExecutableError, TerseExecutableParser as TerseExecutableParser
from fwhunt_scan.uefi_types import ChildSwSmiHandler as ChildSwSmiHandler, NvramVariable as NvramVariable, SwSmiHandler as SwSmiHandler, UefiGuid as UefiGuid, UefiProtocol as UefiProtocol, UefiProtocolGuid as UefiProtocolGuid, UefiService as UefiService
from fwhunt_scan.uefi_utils import get_int as get_int
from types import TracebackType
from typing import Any, Dict, List, Optional, Type

class UefiAnalyzerError(Exception):
    value: Incomplete
    def __init__(self, value: str) -> None: ...

class UefiAnalyzer:
    def __init__(self, image_path: Optional[str] = ..., blob: Optional[bytes] = ..., rizinhome: Optional[str] = ...) -> None: ...
    def __enter__(self): ...
    @property
    def info(self) -> Dict[Any, Any]: ...
    @property
    def strings(self) -> List[Any]: ...
    @property
    def sections(self) -> List[Any]: ...
    @property
    def functions(self) -> List[Any]: ...
    @property
    def insns(self) -> List[Any]: ...
    @property
    def g_bs(self) -> List[int]: ...
    @property
    def g_rt(self) -> List[int]: ...
    @property
    def boot_services(self) -> List[UefiService]: ...
    @property
    def boot_services_protocols(self) -> List[Any]: ...
    @property
    def runtime_services(self) -> List[UefiService]: ...
    @property
    def protocols(self) -> List[UefiProtocol]: ...
    @property
    def protocol_guids(self) -> List[UefiProtocolGuid]: ...
    def r2_get_nvram_vars_64bit(self) -> List[NvramVariable]: ...
    @property
    def nvram_vars(self) -> List[NvramVariable]: ...
    @property
    def pei_services(self) -> List[UefiService]: ...
    @property
    def ppi_list(self) -> List[UefiProtocol]: ...
    @property
    def swsmi_handlers(self) -> List[SwSmiHandler]: ...
    @property
    def child_swsmi_handlers(self) -> List[ChildSwSmiHandler]: ...
    @property
    def smst_list(self) -> List[int]: ...
    def get_summary(self) -> Dict[str, Any]: ...
    def get_protocols_info(self) -> Dict[str, Any]: ...
    def close(self) -> None: ...
    def __exit__(self, exc_type: Optional[Type[BaseException]], exc_value: Optional[BaseException], traceback: Optional[TracebackType]) -> None: ...
