"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codedeploy = require("@aws-cdk/aws-codedeploy");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const cpactions = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-codepipeline-codedeploy-ecs');
const application = codedeploy.EcsApplication.fromEcsApplicationName(stack, 'CodeDeployApplication', 'IntegTestDeployApp');
const deploymentGroup = codedeploy.EcsDeploymentGroup.fromEcsDeploymentGroupAttributes(stack, 'CodeDeployGroup', {
    application,
    deploymentGroupName: 'IntegTestDeploymentGroup'
});
const bucket = new s3.Bucket(stack, 'CodeDeployPipelineIntegTest', {
    versioned: true,
    removalPolicy: cdk.RemovalPolicy.DESTROY,
});
const pipeline = new codepipeline.Pipeline(stack, 'Pipeline', {
    artifactBucket: bucket,
});
const sourceStage = pipeline.addStage({ stageName: 'Source' });
const sourceOutput = new codepipeline.Artifact('SourceOutput');
const sourceAction = new cpactions.S3SourceAction({
    actionName: 'S3Source',
    bucketKey: 'application.zip',
    output: sourceOutput,
    bucket,
});
sourceStage.addAction(sourceAction);
const deployStage = pipeline.addStage({ stageName: 'Deploy' });
deployStage.addAction(new cpactions.CodeDeployEcsDeployAction({
    actionName: 'CodeDeploy',
    deploymentGroup,
    taskDefinitionTemplateFile: new codepipeline.ArtifactPath(sourceOutput, 'task-definition-test.json'),
    appSpecTemplateFile: new codepipeline.ArtifactPath(sourceOutput, 'appspec-test.json'),
    containerImageInputs: [
        {
            input: sourceOutput,
            taskDefinitionPlaceholder: 'PLACEHOLDER'
        }
    ]
}));
app.synth();
//# sourceMappingURL=data:application/json;base64,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