"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codebuild = require("@aws-cdk/aws-codebuild");
const codecommit = require("@aws-cdk/aws-codecommit");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const cpactions = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-codepipeline-codebuild-multiple-inputs-outputs');
const repository = new codecommit.Repository(stack, 'MyRepo', {
    repositoryName: 'MyIntegTestTempRepo',
});
const bucket = new s3.Bucket(stack, 'MyBucket', {
    versioned: true,
    removalPolicy: cdk.RemovalPolicy.DESTROY,
});
const pipeline = new codepipeline.Pipeline(stack, 'Pipeline', {
    artifactBucket: bucket,
});
const pipelineRole = pipeline.role;
const source1Output = new codepipeline.Artifact();
const sourceAction1 = new cpactions.CodeCommitSourceAction({
    actionName: 'Source1',
    repository,
    output: source1Output,
    role: pipelineRole,
});
const source2Output = new codepipeline.Artifact();
const sourceAction2 = new cpactions.S3SourceAction({
    actionName: 'Source2',
    bucketKey: 'some/path',
    bucket,
    output: source2Output,
    role: pipelineRole,
});
pipeline.addStage({
    stageName: 'Source',
    actions: [
        sourceAction1,
        sourceAction2,
    ],
});
const project = new codebuild.PipelineProject(stack, 'MyBuildProject');
const buildAction = new cpactions.CodeBuildAction({
    actionName: 'Build1',
    project,
    input: source1Output,
    extraInputs: [
        source2Output,
    ],
    outputs: [
        new codepipeline.Artifact(),
        new codepipeline.Artifact(),
    ],
    role: pipelineRole,
});
const testAction = new cpactions.CodeBuildAction({
    type: cpactions.CodeBuildActionType.TEST,
    actionName: 'Build2',
    project,
    input: source2Output,
    extraInputs: [
        source1Output,
    ],
    outputs: [
        new codepipeline.Artifact('CustomOutput2'),
    ],
    role: pipelineRole,
});
pipeline.addStage({
    stageName: 'Build',
    actions: [
        buildAction,
        testAction,
    ],
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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