"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const events = require("@aws-cdk/aws-events");
const core_1 = require("@aws-cdk/core");
/**
 * Low-level class for generic CodePipeline Actions.
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @experimental
 */
class Action {
    constructor(actionProperties) {
        this.variableReferenced = false;
        this.customerProvidedNamespace = actionProperties.variablesNamespace;
        this.namespaceOrToken = core_1.Lazy.stringValue({ produce: () => {
                // make sure the action was bound (= added to a pipeline)
                if (this.actualNamespace !== undefined) {
                    return this.customerProvidedNamespace !== undefined
                        // if a customer passed a namespace explicitly, always use that
                        ? this.customerProvidedNamespace
                        // otherwise, only return a namespace if any variable was referenced
                        : (this.variableReferenced ? this.actualNamespace : undefined);
                }
                else {
                    throw new Error(`Cannot reference variables of action '${this.actionProperties.actionName}', ` +
                        'as that action was never added to a pipeline');
                }
            } });
        this.actionProperties = {
            ...actionProperties,
            variablesNamespace: this.namespaceOrToken,
        };
    }
    bind(scope, stage, options) {
        this._pipeline = stage.pipeline;
        this._stage = stage;
        this._scope = scope;
        this.actualNamespace = this.customerProvidedNamespace === undefined
            // default a namespace name, based on the stage and action names
            ? `${stage.stageName}_${this.actionProperties.actionName}_NS`
            : this.customerProvidedNamespace;
        return this.bound(scope, stage, options);
    }
    onStateChange(name, target, options) {
        const rule = new events.Rule(this.scope, name, options);
        rule.addTarget(target);
        rule.addEventPattern({
            detailType: ['CodePipeline Action Execution State Change'],
            source: ['aws.codepipeline'],
            resources: [this.pipeline.pipelineArn],
            detail: {
                stage: [this.stage.stageName],
                action: [this.actionProperties.actionName],
            },
        });
        return rule;
    }
    variableExpression(variableName) {
        this.variableReferenced = true;
        return `#{${this.namespaceOrToken}.${variableName}}`;
    }
    get pipeline() {
        if (this._pipeline) {
            return this._pipeline;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    get stage() {
        if (this._stage) {
            return this._stage;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    /**
     * Retrieves the Construct scope of this Action.
     * Only available after the Action has been added to a Stage,
     * and that Stage to a Pipeline.
     */
    get scope() {
        if (this._scope) {
            return this._scope;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline first');
        }
    }
}
exports.Action = Action;
//# sourceMappingURL=data:application/json;base64,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