from maxoptics import MosLibrary
from maxoptics.utils.MosSubmodules import UserMaterials


p = cl.create_project_as("foo", project_type="passive")

cl.ensure_materials(
    [
        {
            "id": 1027,
            "name": "Background_5",
            "color": "BFBFBF",
            "users": [{"id": 6, "name": "hyl"}],
            "type": "List data",
            "project_type": "passive",
            "mesh_order": 0,
            "dispersionflag": 1,
            "public": False,
            "deleted": False,
            "temperature": 300,
            "data": {
                "epsilon": 1,
                "rel_permitivity": 1,
                "rel_permitivity_ref": 0,
                "rel_permeability": 1,
                "conductivity": 0,
            },
        }
    ],
    "passive",
)


cl = MosLibrary()
cl.ensure_waveforms(
    [
        {
            "name": "Waveform0",
            "data": {
                "bandwidth": 48.40399061458333,
                "center_frequency": 193.6159624583333,
                "center_wavelength": 1.55,
                "frequency_span": 12.491352416666643,
                "frequency_start": 187.37028625,
                "frequency_stop": 199.86163866666664,
                "offset": 21.9203431148254,
                "pulselength": 27.400428893531746,
                "wavelength_span": 0.1,
                "wavelength_start": 1.5,
                "wavelength_stop": 1.6,
            },
        }
    ]
)

materials = UserMaterials(cl, "active")

p.DOCUMENT.update(
    w=50,
    h=50,
    drawGrid={"dx": 1, "dy": 1},
    configGlobleParam=[{"globleParamKey": "", "globleParamExp": "", "globleParamValue": "0", "globleParamDes": ""}],
    exp_obj={},
    tarSrc={"type": "IndexMonitor", "id": "7acfbda9-2eb0-4262-b8d7-18bc8b1db466"},
)

p.add("GlobalMonitor", "GlobalMonitor").update(
    spatial={"x": 0, "y": 0, "z": 0, "rotateX": 0, "rotateY": 0, "rotateZ": 0},
    sample_spacing=0,
    frequency_points=5,
    use_wavelength_spacing=1,
    use_source_limits=0,
    spacing_type=0,
    spacing_limit=0,
    frequency_min=187.37,
    frequency_max=199.862,
    wavelength_min=1.5,
    wavelength_max=1.6,
    wavelength_center=1.55,
    wavelength_span=0.1,
    frequency_center=193.414,
    frequency_span=12.492,
    min_sampling_per_cycle=2,
    desired_sampling=1498.96,
    nyquist_limit=2662.59,
    actual_sampling=2694.53,
    down_sample_time=17,
    x=0,
    y=0,
    z=0,
)

p.add("Triangle", "Triangle").update(
    spatial={"x": 0, "y": 0, "z": 0, "rotateX": 0, "rotateY": 0, "rotateZ": 0},
    extrude={"h": 0.2},
    materialId=materials["Background_5"]["id"],
    meshOrder=1,
    overrideMeshOrder=1,
    index_union={"index": 1.4, "index_units": 1},
    x0=-2.0,
    expre_x0="",
    y0=-2.0,
    expre_y0="",
    x1=2,
    expre_x1="",
    y1=-2.0,
    expre_y1="",
    x2=0,
    expre_x2="",
    y2=2,
    expre_y2="",
    x=0,
    expre_x="",
    y=0,
    expre_y="",
    z=0,
    expre_z="",
    z_span=1,
    expre_z_span="",
    expre_z_max="",
    expre_z_min="",
    rotate_z=0,
    expre_rotate_z="",
)

p.add("Rectangle", "Rectangle").update(
    spatial={"x": 0, "y": 0, "z": 0, "rotateX": 0, "rotateY": 0, "rotateZ": 0},
    extrude={"h": 0.2},
    materialId=materials["Background_5"]["id"],
    meshOrder=1,
    overrideMeshOrder=1,
    index_union={"index": 1.4, "index_units": 1},
    z=0,
    expre_z="",
    z_span=1,
    expre_z_span="",
    expre_z_max="",
    expre_z_min="",
    x=0,
    expre_x="",
    x_span=4,
    expre_x_span="",
    expre_x_max="",
    expre_x_min="",
    y=0,
    expre_y="",
    y_span=4,
    expre_y_span="",
    expre_y_max="",
    expre_y_min="",
    rotate_z=0,
    expre_rotate_z="",
)

p.add("FDTD", "FDTD").update(
    spatial={"x": 0, "y": 0, "z": 0, "rotateX": 0, "rotateY": 0, "rotateZ": 0},
    dimension=1,
    polarized_type=0,
    simulation_time=1000,
    simulation_temperature=300,
    background_material=materials["Background_5"]["id"],
    index=1.4,
    x=0,
    expre_x="",
    x_span=24,
    expre_x_span="",
    expre_x_min="",
    expre_x_max="",
    y=0,
    expre_y="",
    y_span=16,
    expre_y_span="",
    expre_y_min="",
    expre_y_max="",
    z=0,
    expre_z="",
    z_span=10,
    expre_z_span="",
    expre_z_min="",
    expre_z_max="",
    mesh_type=0,
    cells_per_wavelength=15,
    time_stop=0,
    refinement_type=0,
    dx=0.1,
    dy=0.1,
    dz=0.1,
    meshing_refinement=1,
    min_mesh_step=0.0001,
    grading=1,
    grading_factor=1.2,
    x_min_bc=0,
    x_max_bc=0,
    y_min_bc=0,
    y_max_bc=0,
    z_min_bc=0,
    z_max_bc=0,
    pml_same_settings=1,
    extend_structure_through_pml=1,
    pml_config={
        "profile": "Standard",
        "layers": 8,
        "kappa": 2,
        "sigma": 1,
        "polynomial": 3,
        "alpha": 0,
        "alpha_polynomial": 1,
        "min_layers": 8,
        "max_layers": 64,
    },
    x_min_pml_config={
        "profile": "Standard",
        "layers": 8,
        "kappa": 2,
        "sigma": 1,
        "polynomial": 3,
        "alpha": 0,
        "alpha_polynomial": 1,
        "min_layers": 8,
        "max_layers": 64,
    },
    x_max_pml_config={
        "profile": "Standard",
        "layers": 8,
        "kappa": 2,
        "sigma": 1,
        "polynomial": 3,
        "alpha": 0,
        "alpha_polynomial": 1,
        "min_layers": 8,
        "max_layers": 64,
    },
    y_min_pml_config={
        "profile": "Standard",
        "layers": 8,
        "kappa": 2,
        "sigma": 1,
        "polynomial": 3,
        "alpha": 0,
        "alpha_polynomial": 1,
        "min_layers": 8,
        "max_layers": 64,
    },
    y_max_pml_config={
        "profile": "Standard",
        "layers": 8,
        "kappa": 2,
        "sigma": 1,
        "polynomial": 3,
        "alpha": 0,
        "alpha_polynomial": 1,
        "min_layers": 8,
        "max_layers": 64,
    },
    z_min_pml_config={
        "profile": "Standard",
        "layers": 8,
        "kappa": 2,
        "sigma": 1,
        "polynomial": 3,
        "alpha": 0,
        "alpha_polynomial": 1,
        "min_layers": 8,
        "max_layers": 64,
    },
    z_max_pml_config={
        "profile": "Standard",
        "layers": 8,
        "kappa": 2,
        "sigma": 1,
        "polynomial": 3,
        "alpha": 0,
        "alpha_polynomial": 1,
        "min_layers": 8,
        "max_layers": 64,
    },
    set_bandwidth=0,
    bandwidth_config={
        "type": 0,
        "range_type": 0,
        "wavelength_start": 0,
        "wavelength_stop": 0,
        "center_wavelength": 0,
        "wavelength_span": 0,
        "frequency_start": 0,
        "frequency_stop": 0,
        "center_frequency": 0,
        "frequency_span": 0,
    },
    use_early_shutoff=1,
    auto_shutoff_min=0.0001,
    use_divergence_checking=0,
    auto_shutoff_max=100000,
    down_sample_time=100,
    thread=4,
    amp="amplitude",
    component="E",
    scale=0.0,
    frequency_scale=0.0,
    plot=0,
    horizontalt=0,
    plot_with=0,
)

p.add("ModeSource", "ModeSource").update(
    spatial={"x": 0, "y": 0, "z": 0, "rotateX": 0, "rotateY": 0, "rotateZ": 0},
    wavelength=1.55,
    number_of_trial_modes=20,
    search=0,
    use_max_index=1,
    n=1,
    x_min_bc=1,
    x_max_bc=1,
    y_min_bc=1,
    y_max_bc=1,
    z_min_bc=1,
    z_max_bc=1,
    pml_kappa=2,
    pml_sigma=5,
    pml_layers=12,
    pml_polynomial=3,
    bent_waveguide=0,
    bend_radius=0,
    bend_orientation=0,
    bend_location=0,
    calculate_group_index=0,
    injection_axis=0,
    direction=0,
    amplitude=1,
    temperature=300,
    phase=0,
    mode_selection=3,
    mode_index=1,
    number_of_field_profile_samples=1,
    set_maximum_convolution_time_window=0,
    maximum_convolution_time_window=1,
    bend_location_x=0,
    bend_location_y=0,
    bend_location_z=0,
    theta=0,
    phi=0,
    rotation_offset=0,
    x=0,
    expre_x="",
    x_span=0,
    expre_x_span="",
    expre_x_min="",
    expre_x_max="",
    y=0,
    expre_y="",
    y_span=3,
    expre_y_span="",
    expre_y_min="",
    expre_y_max="",
    z=0,
    expre_z="",
    z_span=3,
    expre_z_span="",
    expre_z_min="",
    expre_z_max="",
    use_relative_coordinates=1,
    override=0,
    set_type=0,
    set_fw={
        "type": 0,
        "range_type": 0,
        "wavelength_start": 0,
        "wavelength_stop": 0,
        "center_wavelength": 0,
        "wavelength_span": 0,
        "frequency_start": 0,
        "frequency_stop": 0,
        "center_frequency": 0,
        "frequency_span": 0,
    },
    set_time_domain={"pulse_type": 0, "frequency": 0, "pulselength": 0, "offset": 0, "bandwidth": 0},
    advanced_options={"eliminate_discontinuities": 0, "optimize_for_short_pulse": 1},
    spectrum_vs_wavelength=[],
    spectrum_vs_frequency=[],
    signal_vs_time=[],
    record_local_field=0,
    cell_group=[{"span": 1, "cell_num": 5}],
    globalSettings=0.0,
    span={"normal": 0, "length": 3, "width": 2},
    waveform_id=7,
)

p.add("IndexMonitor", "IndexMonitor").update(
    spatial={"x": 0, "y": 0, "z": 0, "rotateX": 0, "rotateY": 0, "rotateZ": 0},
    monitor_setting={
        "sample_spacing": 0,
        "use_wavelength_spacing": 1,
        "use_source_limits": 0,
        "spacing_type": 0,
        "spacing_limit": 0,
        "frequency_min": 187.37,
        "frequency_max": 199.862,
        "wavelength_min": 1.5,
        "wavelength_max": 1.6,
        "wavelength_center": 1.55,
        "wavelength_span": 0.10000000000000009,
        "frequency_center": 193.61599999999999,
        "frequency_span": 12.49199999999999,
        "frequency_points": 5,
        "min_sampling_per_cycle": 2,
        "desired_sampling": 1498.96,
        "nyquist_limit": 2662.59,
        "actual_sampling": 2694.53,
        "down_sample_time": 17,
    },
    override_global_options=0,
    simulation_type=0,
    monitor_type=5,
    x=0,
    x_span=0,
    y=0,
    y_span=0,
    z=0,
    z_span=0,
    use_relative_coordinates=1,
    down_sample_x=1,
    down_sample_y=1,
    down_sample_z=1,
)

p.add("TimeMonitor", "TimeMonitor").update(
    spatial={"x": 0, "y": 0, "z": 0, "rotateX": 0, "rotateY": 0, "rotateZ": 0},
    simulation_type=0,
    set_time_domain={"stop_method": 0, "start_time": 0, "stop_time": 1000, "number_of_snapshots": 0},
    monitor_type=1,
    x=0,
    expre_x="",
    expre_x_min="",
    x_span=0,
    expre_x_span="",
    expre_x_max="",
    y=0,
    expre_y="",
    expre_y_min="",
    y_span=0,
    expre_y_span="",
    expre_y_max="",
    z=0,
    expre_z="",
    expre_z_min="",
    z_span=0,
    expre_z_span="",
    expre_z_max="",
    use_relative_coordinates=1,
    down_sample_x=1,
    down_sample_y=1,
    down_sample_z=1,
    output_ex=1,
    output_hx=1,
    output_ey=1,
    output_hy=1,
    output_ez=1,
    output_hz=1,
    output_px=1.0,
    output_py=1.0,
    output_pz=1.0,
    output_power=1.0,
    plugin_material=0,
    spatial_interpolation=0,
    record_data_in_pml=1.0,
    min_sampling_per_cycle=10,
    sampling_rate=0,
    down_sample_time=0,
    span={"normal": 0, "length": 3, "width": 2},
)

p.add("ModeExpansion", "ModeExpansion").update(
    spatial={"x": 0, "y": 0, "z": 0, "rotateX": 0, "rotateY": 0, "rotateZ": 0},
    wavelength=1.55,
    number_of_trial_modes=20,
    search=0,
    use_max_index=1.0,
    n=1,
    x_min_bc=1,
    x_max_bc=1,
    y_min_bc=1,
    y_max_bc=1,
    z_min_bc=1,
    z_max_bc=1,
    pml_kappa=2,
    pml_sigma=5,
    pml_layers=12,
    pml_polynomial=3,
    bent_waveguide=0,
    bend_radius=0,
    bend_orientation=0,
    bend_location=0,
    calculate_group_index=0,
    monitor_type=0,
    x=0,
    expre_x="",
    expre_x_min="",
    x_span=0,
    expre_x_span="",
    expre_x_max="",
    y=0,
    expre_y="",
    expre_y_min="",
    y_span=3,
    expre_y_span="",
    expre_y_max="",
    z=0,
    expre_z="",
    expre_z_min="",
    z_span=3,
    expre_z_span="",
    expre_z_max="",
    direction=0,
    mode_selection=0,
    monitor_setting={
        "sample_spacing": 0,
        "use_wavelength_spacing": 1,
        "use_source_limits": 0,
        "spacing_type": 0,
        "spacing_limit": 0,
        "frequency_min": 187.37,
        "frequency_max": 199.862,
        "wavelength_min": 1.5,
        "wavelength_max": 1.6,
        "wavelength_center": 1.55,
        "wavelength_span": 0.1,
        "frequency_center": 193.414,
        "frequency_span": 12.492,
        "frequency_points": 5,
        "min_sampling_per_cycle": 2,
        "desired_sampling": 1498.96,
        "nyquist_limit": 2662.59,
        "actual_sampling": 2694.53,
        "down_sample_time": 17,
    },
    override_global_options=0,
    mode_list=[1],
    bent_waveguide_settings={"bent_waveguide": 0, "bend_radius": 1000000, "bend_orientation": 0, "bend_location": 0},
    monitors_for_expansion=[{"name": "", "id": "", "index": 0}],
    frequency=193.414,
    amp="amplitude",
    component="E",
    scale=0.0,
    start_frequency=193.414,
    stop_frequency=200,
    start_wavelength=1.55,
    stop_wavelength=1.49896,
    number_of_points=10,
    number_of_test_modes=3,
    effective_index=1,
    details_dispersion_calculation=1.0,
    tableData=[],
    modePlotsResult="None",
    frequencyPlotResult="None",
    modeIndex=0,
    taskId=0,
)

p.add("PowerMonitor", "PowerMonitor").update(
    spatial={"x": 0, "y": 0, "z": 0, "rotateX": 0, "rotateY": 0, "rotateZ": 0},
    monitor_setting={
        "sample_spacing": 0,
        "use_wavelength_spacing": 1,
        "use_source_limits": 0,
        "spacing_type": 0,
        "spacing_limit": 0,
        "frequency_min": 187.37,
        "frequency_max": 199.862,
        "wavelength_min": 1.5,
        "wavelength_max": 1.6,
        "wavelength_center": 1.55,
        "wavelength_span": 0.10000000000000009,
        "frequency_center": 193.61599999999999,
        "frequency_span": 12.49199999999999,
        "frequency_points": 5,
        "min_sampling_per_cycle": 2,
        "desired_sampling": 1498.96,
        "nyquist_limit": 2662.59,
        "actual_sampling": 2694.53,
        "down_sample_time": 17,
    },
    override_global_options=0,
    simulation_type=0,
    monitor_type=5,
    x=0,
    expre_x="",
    expre_x_min="",
    x_span=0,
    expre_x_span="",
    expre_x_max="",
    y=0,
    expre_y="",
    expre_y_min="",
    y_span=3,
    expre_y_span="",
    expre_y_max="",
    z=0,
    expre_z="",
    expre_z_min="",
    z_span=3,
    expre_z_span="",
    expre_z_max="",
    use_relative_coordinates=1,
    down_sample_x=1,
    down_sample_y=1,
    down_sample_z=1,
    standard_fourier_transform=1,
    partial_spectral_average=0,
    total_spectral_average=0,
    output_ex=1,
    output_hx=1,
    output_ey=1,
    output_hy=1,
    output_ez=1,
    output_hz=1,
    output_px=0,
    output_py=0,
    output_pz=0,
    output_power=1,
    data=10,
    apodization_center=500,
    apodization_time_width=100,
    apodization_freq_width=4.41271,
    spatial_interpolation=0,
    record_data_in_pml=0.0,
    span={"normal": 0, "length": 3, "width": 2},
)

p.add("PowerMonitor", "PowerMonitor_1").update(
    spatial={"x": 0, "y": 0, "z": 0, "rotateX": 0, "rotateY": 0, "rotateZ": 0},
    monitor_setting={
        "sample_spacing": 0,
        "use_wavelength_spacing": 1,
        "use_source_limits": 0,
        "spacing_type": 0,
        "spacing_limit": 0,
        "frequency_min": 187.37,
        "frequency_max": 199.862,
        "wavelength_min": 1.5,
        "wavelength_max": 1.6,
        "wavelength_center": 1.55,
        "wavelength_span": 0.10000000000000009,
        "frequency_center": 193.61599999999999,
        "frequency_span": 12.49199999999999,
        "frequency_points": 5,
        "min_sampling_per_cycle": 2,
        "desired_sampling": 1498.96,
        "nyquist_limit": 2662.59,
        "actual_sampling": 2694.53,
        "down_sample_time": 17,
    },
    override_global_options=0,
    simulation_type=0,
    monitor_type=5,
    x=0,
    expre_x="",
    expre_x_min="",
    x_span=0,
    expre_x_span="",
    expre_x_max="",
    y=0,
    expre_y="",
    expre_y_min="",
    y_span=3,
    expre_y_span="",
    expre_y_max="",
    z=0,
    expre_z="",
    expre_z_min="",
    z_span=3,
    expre_z_span="",
    expre_z_max="",
    use_relative_coordinates=1,
    down_sample_x=1,
    down_sample_y=1,
    down_sample_z=1,
    standard_fourier_transform=1,
    partial_spectral_average=0,
    total_spectral_average=0,
    output_ex=1,
    output_hx=1,
    output_ey=1,
    output_hy=1,
    output_ez=1,
    output_hz=1,
    output_px=0,
    output_py=0,
    output_pz=0,
    output_power=1,
    data=10,
    apodization_center=500,
    apodization_time_width=100,
    apodization_freq_width=4.41271,
    spatial_interpolation=0,
    record_data_in_pml=0.0,
    span={"normal": 0, "length": 3, "width": 2},
)

p.add("ModeExpansion", "ModeExpansion_1").update(
    spatial={"x": 0, "y": 0, "z": 0, "rotateX": 0, "rotateY": 0, "rotateZ": 0},
    wavelength=1.55,
    number_of_trial_modes=20,
    search=0,
    use_max_index=1.0,
    n=1,
    x_min_bc=1,
    x_max_bc=1,
    y_min_bc=1,
    y_max_bc=1,
    z_min_bc=1,
    z_max_bc=1,
    pml_kappa=2,
    pml_sigma=5,
    pml_layers=12,
    pml_polynomial=3,
    bent_waveguide=0,
    bend_radius=0,
    bend_orientation=0,
    bend_location=0,
    calculate_group_index=0,
    monitor_type=0,
    x=0,
    expre_x="",
    expre_x_min="",
    x_span=0,
    expre_x_span="",
    expre_x_max="",
    y=0,
    expre_y="",
    expre_y_min="",
    y_span=3,
    expre_y_span="",
    expre_y_max="",
    z=0,
    expre_z="",
    expre_z_min="",
    z_span=3,
    expre_z_span="",
    expre_z_max="",
    direction=0,
    mode_selection=0,
    monitor_setting={
        "sample_spacing": 0,
        "use_wavelength_spacing": 1,
        "use_source_limits": 0,
        "spacing_type": 0,
        "spacing_limit": 0,
        "frequency_min": 187.37,
        "frequency_max": 199.862,
        "wavelength_min": 1.5,
        "wavelength_max": 1.6,
        "wavelength_center": 1.55,
        "wavelength_span": 0.1,
        "frequency_center": 193.414,
        "frequency_span": 12.492,
        "frequency_points": 5,
        "min_sampling_per_cycle": 2,
        "desired_sampling": 1498.96,
        "nyquist_limit": 2662.59,
        "actual_sampling": 2694.53,
        "down_sample_time": 17,
    },
    override_global_options=0,
    mode_list=[1],
    bent_waveguide_settings={"bent_waveguide": 0, "bend_radius": 1000000, "bend_orientation": 0, "bend_location": 0},
    monitors_for_expansion=[{"name": "", "id": "", "index": 0}],
    frequency=193.414,
    amp="amplitude",
    component="E",
    scale=0.0,
    start_frequency=193.414,
    stop_frequency=200,
    start_wavelength=1.55,
    stop_wavelength=1.49896,
    number_of_points=10,
    number_of_test_modes=3,
    effective_index=1,
    details_dispersion_calculation=1.0,
    tableData=[],
    modePlotsResult="None",
    frequencyPlotResult="None",
    modeIndex=0,
    taskId=0,
)

p.save()
