# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['src2prod']

package_data = \
{'': ['*']}

install_requires = \
['click>=7.1.2,<8.0.0',
 'multimd>=0.0.0-beta.0,<0.0.1',
 'spkpb>=0.0.10-beta.0,<0.0.11']

entry_points = \
{'console_scripts': ['src2prod = src2prod.cmdline:update']}

setup_kwargs = {
    'name': 'src2prod',
    'version': '0.0.8b0',
    'description': 'This module allows to develop a project within a source folder and to publish the final product in another folder, this last directory being a "thin" version of the source one.',
    'long_description': 'The `Python` module `src2prod`\n==============================\n\n> **I beg your pardon for my english...**\n>\n> English is not my native language, so be nice if you notice misunderstandings, misspellings, or grammatical errors in my documents and codes.\n\n\nAbout `src2prod`\n----------------\n\nThis module allows to develop a project within a source folder and to publish the final product in another folder, this last directory being a "thin" version of the source one. If you use `git`, this module can talk with it to do a better job.\n\n\nThe example used for a short tutorial\n-------------------------------------\n\nLet\'s consider [`TeXitEasy`](https://github.com/projetmbc/tools-for-latex/tree/master/TeXitEasy) which had merly the following tree structure on August 9, 2021 (this was the very begining of this project that used a single small `README.md` file).\n\n~~~\n+ TeXitEasy\n    + changes\n        + 2021\n            * 08.txt\n        * LICENSE.txt\n        * x-todo-x.txt\n\n    + src\n        * __init__.py\n        * escape.py\n        * LICENSE.txt\n        + tool_config\n            * escape.peuf\n        * tool_debug.py\n        * tool_escape.py\n\n    + tests\n        + escape\n            * escape.peuf\n            * fstringit.peuf\n            * test_fstringit.py\n            * test_escape.py\n        * about.peuf\n        * pyproject.toml\n        * README.md\n~~~\n\n\nBuilding a thin copy of the source folder\n-----------------------------------------\n\n### What we want...\n\nIn our project above, there are some files only useful for the development of the code.\n\n  1. Names using the pattern `x-...-x` indicate files or folders to be ignored by `git` (there are no such file or folder in the `src` folder but we could imagine using some of them).\n\n  1. Names using the pattern `tool_...` are for files and folders to not copy into the final product, but at the same time to be kept by `git`.\n\n  1. The `README.md` file used for `git` servers must also be used for the final product.\n\n\nThe final product built from the `src` folder must have the following name and structure.\n\n~~~\n+ texiteasy\n    * __init__.py\n    * escape.py\n    * LICENSE.txt\n    * README.md\n~~~\n\n\n### How to do that?\n\nHere is how to acheive a selective copy of the `src` folder to the `texiteasy` one. We will suppose the use of the `cd` command to go inside the parent folder of `TeXitEasy` before launching the following script where we use instances of `Path` from `pathlib`.\n\n~~~python\nfrom src2prod import *\n\nproject = Project(\n    project = Path(\'TeXitEasy\'),\n    source  = Path(\'src\'),\n    target  = Path(\'texiteasy\'),\n    ignore  = \'\'\'\n        tool_*/\n        tool_*.*\n    \'\'\',\n    usegit = True,\n    readme = Path(\'README.md\')\n)\n\nproject.update()\n~~~\n\nHere are some important points about the code above.\n\n  1. `project`, `source`, `target` and `readme` follows the rules below.\n\n      * The values of this arguments can also be strings (that will be converted to instances of `Path`).\n\n      * The argument `readme` is optional contrary to `project`, `source` and `target`.\n\n      * `project` is a complete path regarding the working directory when launching the file, but `source`, `target` and `readme` are relative to `project`.\n\n  1. The argument `ignore` can be used even if the project doesn\'t use `git`. It can be either a string containing rules, or an absolute `Path` to a file containg rules (an absolute path allows to use the same rules for several projects). Let\'s see now how to define rules.\n\n      * Empty lines are ignored (this allows a basic formatting of rules).\n\n      * Each none empty line is internally stripped. This will indicate one rule for either a file or a folder.\n\n      * A rule finishing by `/` is for a folder: internally the last `/` is removed such as to store the rule only for folders.\n\n      * Each rule will be used with the method `match` of `pathlib.Path` (this is very basic).\n\n  1. `usegit = True` asks also to ignore files and folders as `git` does (this action completes the rules defined in `ignore`). This setting implies that there isn\'t any uncommited file in the `src` folder (even if that files must be ignored).\n\n  1. Errors and warnings are printed in the terminal and written verbosely in the file `TeXitEasy.src2prod.log` where `TeXitEasy` is the name extracted from the path `project`.\n\n\nOnly the source files to copy\n-----------------------------\n\nSometimes the final product is not just a "selective clone" of the `src` folder: for example, it can be a melting of several source files in a single final one (the author of `src2prod` uses this technic to develop his `LaTeX` projects). In such a case, you can use the following method and attribut.\n\n  1. The method `build` just looks for the files to keep for the `texiteasy` folder.\n\n  1. The attribut `lof` is the list of all files to keep in the `src` folder (`lof` is for `list of files`).\n\nHere is an example of code printing the list of only the source files to keep.\n\n~~~python\nfrom src2prod import *\n\nproject = Project(\n    name   = \'TeXitEasy\',\n    source = Path(\'src\'),\n    target = Path(\'texiteasy\'),\n    ignore = \'\'\'\n        tool_*/\n        tool_*.*\n    \'\'\',\n    usegit = True,\n    readme = Path(\'README.md\')\n)\n\nproject.build()\n\nfor f in project.lof:\n    print(f)\n~~~\n\nThis script gives the following output in a terminal. Note that the list doesn\'t contain the path of the `README` file, this last one must be manage by hand (see the methods `check_readme` and `copy_readme` of the class `Project`).\n\n~~~\n/full/path/to/TeXitEasy/src/__init__.py\n/full/path/to/TeXitEasy/src/escape.py\n/full/path/to/TeXitEasy/src/LICENSE.txt\n~~~\n\n\n`README.md` part by part\n------------------------\n\nYou can write you `README.md` typing small section like parts as it is the case for the `README.md` you are reading (that is both in the repository and the final project to be distributed). The `src2prod` project had merly the following partial tree structure on August 22, 2021.\n\n~~~\n+ src2prod\n    + changes\n        * ...\n\n    + readme\n        * about.peuf\n        * build.md\n        * cli.md\n        * example-used.md\n        * only-files.md\n        * prologue.md\n        * readme-splitted.md\n\n    + src\n        * ...\n\n    * README.md\n    * ...\n~~~\n\nThis section has been written inside the file `readme-splitted.md`. The special file `about.peuf` allows to indicate the order to use to merge the different `MD` files. Its content was the following one.\n\n~~~\ntoc::\n    + prologue\n    + example-used\n    + build\n    + only-files\n    + readme-splitted\n    + cli\n~~~\n\nThe way used to build the source of `src2prod` is very simple: we just indicate the folder `readme` instead of a file for the argument `readme`. That\'s all! See the code below.\n\n~~~python\nfrom src2prod import *\n\nproject = Project(\n    project = Path(\'TeXitEasy\'),\n    source  = Path(\'src\'),\n    target  = Path(\'texiteasy\'),\n    ignore  = \'\'\'\n        tool_*/\n        tool_*.*\n    \'\'\',\n    usegit = True,\n    readme = Path(\'readme\')\n)\n\nproject.update()\n~~~\n\n\nUsing a `CLI`\n-------------\n\nThe project proposes one `CLI`, aka one "Command Line Interface", to update a project. Let\'s consider the following script `mycli.py`.\n\n~~~python\nfrom src2prod import cmdline\n\ncmdline.update()\n~~~\n\nThe following `Unix` terminal session shows how to use this basic script to update a project.\n\n\n### What we have before\n\n~~~\n> ls\nspkpb         src2prod\nignore.txt    mycli.py\n\n> cat ignore.txt\ntool_*/\ntool_*.*\n\n> ls spkpb\nREADME.md     src\nchanges       tools\n~~~\n\n\n### How to use the tiny script\n\n~~~\n> python mycli.py --usegit --notsafe --readme=\'README.md\' --ignore=\'ignore.txt\' spkpb\n---------------\n"spkpb": UPDATE\n---------------\n\n1) The log file used will be :\n   "spkpb/spkpb.src2prod.log".\n2) External "README" file to use:\n   "spkpb/README.md".\n3) Ignore rules in the file:\n   "ignore.txt"\n4) Checking "git".\n5) Working in the branch "master".\n6) Starting the analysis of the source folder:\n   "spkpb/src".\n7) 21 files found using the rules from "ignore".\n8) Removing unwanted files using "git".\n9) 10 files found using "git". 11 new files ignored thanks to "git".\n10) Target folder has been created:\n    "spkpb/spkpb".\n11) Copying 10 files from source to target.\n12) "README.md" added to the target.\n13) Target folder updated.\n~~~\n\n\n### What we obtain after\n\n~~~\n> ls spkpb\nREADME.md     spkpb.src2prod.log\nsrc           changes\nspkpb         tools\n\n> ls spkpb/spkpb/*\nspkpb/spkpb/LICENSE.txt        spkpb/spkpb/__init__.py\nspkpb/spkpb/problems.py        spkpb/spkpb/README.md\nspkpb/spkpb/base.py            spkpb/spkpb/timer.py\n\nspkpb/spkpb/speaker:\n__init__.py         log.py\nterm.py             allinone.py\nspk_interface.py\n~~~\n\n\n### Help\n\nYou can have an help as usual in the `Unix` command line world.\n\n\n~~~\n> python mycli.py --help\nUsage: cmdline.py [OPTIONS] PROJECT\n\n  Update your "source-to-product" like projects using the Python module\n  src2prod.\n\n  PROJECT: the path of the project to update.\n\nOptions:\n  --src TEXT     Relative path of the source folder of the project. The\n                 default value is "src".\n\n  --target TEXT  Relative path of the targer folder of the project. The\n                 default value "", an empty string, indicates to use the name,\n                 in lower case, of the project.\n\n  --ignore TEXT  Path to a file with the rules for ignoring files in addition\n                 to what git does. The default value "", an empty string,\n                 indicates to not use any rule.\n\n  --usegit       This flag is to use git.\n  --readme TEXT  Relative path of an external "README" file or "readme"\n                 folder. The default value "", an empty string, indicates to\n                 not use any external "README" file.\n\n  --notsafe      This flag allows to remove a none empty target folder.\n  --help         Show this message and exit.\n~~~',
    'author': 'Christophe BAL',
    'author_email': None,
    'maintainer': 'Christophe BAL',
    'maintainer_email': None,
    'url': 'https://github.com/projetmbc/tools-for-dev/tree/master/src2prod',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
