#!/usr/bin/env python3
"""Script to set up the CurrencyLayer API wrapper."""
import os
import sys

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

here = os.path.abspath(os.path.dirname(__file__))

with open(os.path.join(here, 'README.rst'), encoding='utf-8') as f:
    long_description = f.read()

if sys.argv[-1] == 'publish':
    os.system('python3 setup.py sdist upload')
    sys.exit()

setup(
    name='aiocurrencylayer',
    version='0.1.3',
    description='Python Wrapper for interacting with the CurrencyLayer API.',
    long_description=long_description,
    url='https://github.com/home-assistant-ecosystem/python-currencylayer',
    download_url='https://github.com/home-assistant-ecosystem/python-currencylayer/releases',
    author='Fabian Affolter',
    author_email='fabian@affolter-engineering.ch',
    license='MIT',
    install_requires=['aiohttp<4', 'async_timeout<4'],
    packages=['aiocurrencylayer'],
    zip_safe=True,
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Environment :: Console',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: MacOS :: MacOS X',
        'Operating System :: Microsoft :: Windows',
        'Operating System :: POSIX',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.6',
        'Topic :: Utilities',
    ],
)
