"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeGroup = exports.CapacityType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const provider_aws_1 = require("@cdktf/provider-aws");
const constructs_1 = require("constructs");
/**
 * @stability stable
 */
var CapacityType;
(function (CapacityType) {
    CapacityType["SPOT"] = "SPOT";
    CapacityType["ON_DEMAND"] = "ON_DEMAND";
})(CapacityType = exports.CapacityType || (exports.CapacityType = {}));
/**
 * @stability stable
 */
class NodeGroup extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k;
        super(scope, id);
        this.minCapacity = (_c = (_b = props.scalingConfig) === null || _b === void 0 ? void 0 : _b.minCapacity) !== null && _c !== void 0 ? _c : 0;
        this.desiredCapacity = (_e = (_d = props.scalingConfig) === null || _d === void 0 ? void 0 : _d.desiredCapacity) !== null && _e !== void 0 ? _e : this.minCapacity;
        this.maxCapacity = ((_g = (_f = props.scalingConfig) === null || _f === void 0 ? void 0 : _f.maxCapacity) !== null && _g !== void 0 ? _g : (this.desiredCapacity > 0)) ?
            this.desiredCapacity : 1;
        this.nodeGroupRoleArn = (_h = props.nodeRole) !== null && _h !== void 0 ? _h : this._createNodeGroupRole().arn;
        new provider_aws_1.EksNodeGroup(this, 'NodeGroup', {
            clusterName: props.clusterName,
            nodeRoleArn: this.nodeGroupRoleArn,
            subnetIds: props.subnets,
            scalingConfig: [
                {
                    desiredSize: this.desiredCapacity,
                    minSize: this.minCapacity,
                    maxSize: this.maxCapacity,
                },
            ],
            capacityType: (_j = props.capacityType) !== null && _j !== void 0 ? _j : CapacityType.ON_DEMAND,
            instanceTypes: (_k = props.instanceTypes) !== null && _k !== void 0 ? _k : ['t3.large'],
            dependsOn: props.dependsOn,
        });
    }
    _createNodeGroupRole() {
        const role = new provider_aws_1.IamRole(this, 'MNGRole', {
            assumeRolePolicy: JSON.stringify({
                Version: '2012-10-17',
                Statement: [
                    {
                        Action: 'sts:AssumeRole',
                        Effect: 'Allow',
                        Sid: '',
                        Principal: {
                            Service: 'ec2.amazonaws.com',
                        },
                    },
                ],
            }),
        });
        new provider_aws_1.IamPolicyAttachment(this, 'AmazonEKSWorkerNodePolicyAttachment', {
            name: 'AmazonEKSWorkerNodePolicyAttachment',
            policyArn: 'arn:aws:iam::aws:policy/AmazonEKSWorkerNodePolicy',
            roles: [role.name],
        });
        new provider_aws_1.IamPolicyAttachment(this, 'AmazonEKS_CNI_PolicyAttachment', {
            name: 'AmazonEKS_CNI_PolicyAttachment',
            policyArn: 'arn:aws:iam::aws:policy/AmazonEKS_CNI_Policy',
            roles: [role.name],
        });
        new provider_aws_1.IamPolicyAttachment(this, 'AmazonEC2ContainerRegistryReadOnlyAttachment', {
            name: 'AmazonEC2ContainerRegistryReadOnlyAttachment',
            policyArn: 'arn:aws:iam::aws:policy/AmazonEC2ContainerRegistryReadOnly',
            roles: [role.name],
        });
        return role;
    }
}
exports.NodeGroup = NodeGroup;
_a = JSII_RTTI_SYMBOL_1;
NodeGroup[_a] = { fqn: "@pahud/cdktf-aws-eks.NodeGroup", version: "0.2.20" };
//# sourceMappingURL=data:application/json;base64,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