"use strict";
/**
 * @upsetjs/jupyter_widget
 * https://github.com/upsetjs/upsetjs_jupyter_widget
 *
 * Copyright (c) 2020 Samuel Gratzl <sam@sgratzl.com>
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const base_1 = require("@jupyter-widgets/base");
const widgetExports = tslib_1.__importStar(require("./widget"));
const version_1 = require("./version");
const EXTENSION_ID = '@upsetjs/jupyter_widget:plugin';
/**
 * The example plugin.
 */
const upsetjsPlugin = {
    id: EXTENSION_ID,
    requires: [base_1.IJupyterWidgetRegistry],
    activate: activateWidgetExtension,
    autoStart: true,
};
exports.default = upsetjsPlugin;
/**
 * Activate the widget extension.
 */
function activateWidgetExtension(_app, registry) {
    registry.registerWidget({
        name: version_1.MODULE_NAME,
        version: version_1.MODULE_VERSION,
        exports: widgetExports,
    });
}
//# sourceMappingURL=plugin.js.map