### THIS FILE IS AUTOGENERATED. DO NOT EDIT THIS FILE DIRECTLY ###
import minknow_api
from minknow_api.manager_pb2_grpc import *
import minknow_api.manager_pb2 as manager_pb2
from minknow_api.manager_pb2 import *
from minknow_api._support import MessageWrapper, ArgumentError
import time
import logging
import sys

__all__ = [
    "ManagerService",
    "DescribeHostRequest",
    "DescribeHostResponse",
    "FlowCellPosition",
    "FlowCellPositionsRequest",
    "FlowCellPositionsResponse",
    "WatchFlowCellPositionsRequest",
    "WatchFlowCellPositionsResponse",
    "ResetPositionRequest",
    "ResetPositionResponse",
    "BasecallerApiRequest",
    "BasecallerApiResponse",
    "GetGuppyInfoRequest",
    "GetGuppyInfoResponse",
    "GetVersionInfoRequest",
    "ListProtocolOutputDirFilesRequest",
    "ListProtocolOutputDirFilesResponse",
    "CreateDirectoryRequest",
    "CreateDirectoryResponse",
    "FilesystemDiskSpaceInfo",
    "GetDiskSpaceInfoRequest",
    "StreamDiskSpaceInfoRequest",
    "GetDiskSpaceInfoResponse",
    "GetBarcodeKitInfoRequest",
    "GetBarcodeKitInfoResponse",
    "GetLampKitInfoRequest",
    "GetLampKitInfoResponse",
    "GetBarcodeKeysRequest",
    "GetBarcodeKeysResponse",
    "GetFlowCellTypesRequest",
    "GetFlowCellTypesResponse",
    "GetSequencingKitsRequest",
    "GetSequencingKitsResponse",
    "AddSimulatedDeviceRequest",
    "AddSimulatedDeviceResponse",
    "RemoveSimulatedDeviceRequest",
    "RemoveSimulatedDeviceResponse",
    "LocalAuthenticationTokenPathRequest",
    "LocalAuthenticationTokenPathResponse",
    "GetAlignmentReferenceInformationRequest",
    "GetAlignmentReferenceInformationResponse",
    "AssociationDeviceCodeRequest",
    "AssociationDeviceCodeResponse",
    "ApplyOfflineAssociationUnlockCodeRequest",
    "ApplyOfflineAssociationUnlockCodeResponse",
    "ListDeveloperApiTokensRequest",
    "ListDeveloperApiTokensResponse",
    "CreateDeveloperApiTokenRequest",
    "CreateDeveloperApiTokenResponse",
    "RevokeDeveloperApiTokenRequest",
    "RevokeDeveloperApiTokensResponse",
    "FindProtocolsRequest",
    "FindProtocolsResponse",
    "ListSettingsForProtocolRequest",
    "ListSettingsForProtocolResponse",
    "Feature",
    "FeatureList",
    "GetFeaturesRequest",
    "GetFeaturesResponse",
    "SetFeaturesRequest",
    "SetFeaturesResponse",
    "SimpleProtocolState",
    "NO_PROTOCOL_STATE",
    "PROTOCOL_RUNNING",
    "PROTOCOL_FINISHED_SUCCESSFULLY",
    "PROTOCOL_FINISHED_WITH_ERROR",
    "SimulatedDeviceType",
    "SIMULATED_AUTO",
    "SIMULATED_MINION",
    "SIMULATED_TRAXION",
    "SIMULATED_PROMETHION",
    "SIMULATED_P2",
    "ExperimentType",
    "SEQUENCING",
    "CONTROL",
    "CUSTOM",
    "ALL_EXCEPT_HIDDEN",
    "ALL_INCLUDING_HIDDEN",
]

def run_with_retry(method, message, timeout, unwraps, full_name):
    retry_count = 20
    error = None
    for i in range(retry_count):
        try:
            result = MessageWrapper(method(message, timeout=timeout), unwraps=unwraps)
            return result
        except grpc.RpcError as e:
            # Retrying unidentified grpc errors to keep clients from crashing
            retryable_error = (e.code() == grpc.StatusCode.UNKNOWN and "Stream removed" in e.details() or \
                                (e.code() == grpc.StatusCode.INTERNAL and "RST_STREAM" in e.details()))
            if retryable_error:
                logging.info('Bypassed ({}: {}) error for grpc: {}. Attempt {}.'.format(e.code(), e.details(), full_name, i))
            else:
                raise
            error = e
        time.sleep(1)
    raise error


class ManagerService(object):
    def __init__(self, channel):
        self._stub = ManagerServiceStub(channel)
        self._pb = manager_pb2
    def describe_host(self, _message=None, _timeout=None, **kwargs):
        """Get information about the machine running MinKNOW.

        This RPC can be called without providing any authentication tokens.

        Since 3.6

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.DescribeHostRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.DescribeHostResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.describe_host,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = DescribeHostRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to describe_host: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.describe_host,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def flow_cell_positions(self, _message=None, _timeout=None, **kwargs):
        """List all known positions where flow cells can be inserted.

        Provides a snapshot of places where users can insert flow cells. It has a streamed response
        in case there are too many positions to fit into a single response, but normally there should
        only be a single response.

        This RPC can be called without providing any authentication tokens.

        Since 3.6

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.FlowCellPositionsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.

        Returns:
            iter of minknow_api.manager_pb2.FlowCellPositionsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.flow_cell_positions,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = FlowCellPositionsRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to flow_cell_positions: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.flow_cell_positions,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def watch_flow_cell_positions(self, _message=None, _timeout=None, **kwargs):
        """Watch for changes in flow cell position availability and state.

        This is like flow_cell_positions, but updates are streamed as positions come and go (eg:
        MinIONs being plugged or unplugged), or their status otherwise changes.

        This RPC can be called without providing any authentication tokens.

        Since 3.6

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.WatchFlowCellPositionsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.

        Returns:
            iter of minknow_api.manager_pb2.WatchFlowCellPositionsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.watch_flow_cell_positions,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = WatchFlowCellPositionsRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to watch_flow_cell_positions: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.watch_flow_cell_positions,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def reset_position(self, _message=None, _timeout=None, **kwargs):
        """Reset a flow cell position.

        If the hardware is in an error state or has been removed and the software is running, it will
        stop the software (causing the position to be forgotten if the hardware was removed).

        If the hardware is not in an error state

        

        Args:
            _message (minknow_api.manager_pb2.ResetPositionRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            positions (str, optional): The names of positions to restart.
            force (bool, optional): Force the software to be restarted even when it appears to be in a healthy state (ie:
                STATE_RUNNING).

        Returns:
            minknow_api.manager_pb2.ResetPositionResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.reset_position,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = ResetPositionRequest()

        if "positions" in kwargs:
            unused_args.remove("positions")
            _message.positions.extend(kwargs['positions'])

        if "force" in kwargs:
            unused_args.remove("force")
            _message.force = kwargs['force']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to reset_position: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.reset_position,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def basecaller_api(self, _message=None, _timeout=None, **kwargs):
        """Get the connection information for the basecaller API.

        This is the service that implements the minknow_api.basecaller interface for basecalling
        reads files.

        This RPC can be called without providing any authentication tokens.

        Since 3.5

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.BasecallerApiRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.BasecallerApiResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.basecaller_api,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = BasecallerApiRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to basecaller_api: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.basecaller_api,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_guppy_info(self, _message=None, _timeout=None, **kwargs):
        """Get information about Guppy, including the port to connect to it on.

        Since 4.1

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.GetGuppyInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.GetGuppyInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_guppy_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetGuppyInfoRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_guppy_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_guppy_info,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_version_info(self, _message=None, _timeout=None, **kwargs):
        """Current version information includes:
        - Minknow version
        - Protocols version (i.e. Bream-4 version)
        - Configuration version (i.e. Wanda version)
        - Distribution version
        - Guppy version

        This RPC can be called without providing any authentication tokens.

        See also: instance.get_version_info which provides some similar information on a per instance basis.
        Since 3.3

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.GetVersionInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.instance_pb2.GetVersionInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_version_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetVersionInfoRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_version_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_version_info,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def list_protocol_output_dir_files(self, _message=None, _timeout=None, **kwargs):
        """Returns all the files that are within the protocol output dir specified in the user_conf - or a descendant of that directory
        if `path` is supplied in the request.

        INVALID_ARGUMENT will be returned if the `path` argument in the request is not a descendant of the protocol output directory

        NOT_FOUND will be returned if the path does not exist. 'The path' being either the protocol output directory if the `path` argument is not specified
        or a valid `path` argument is specified but does not exist.

        Since 3.5

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.ListProtocolOutputDirFilesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            path (str, optional): Specify the root path to list files from. If the path is left empty, then the base protocol output directory
                will be used.

                Note that the path specified HAS to be a descendant of the protocol output directory, otherwise a INVALID_ARGUMENT
                error will be returned

                If the path is left empty, and the path specified in the user config doesn't exist, then the NOT_FOUND error code
                will be returned

        Returns:
            iter of minknow_api.manager_pb2.ListProtocolOutputDirFilesResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.list_protocol_output_dir_files,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = ListProtocolOutputDirFilesRequest()

        if "path" in kwargs:
            unused_args.remove("path")
            _message.path = kwargs['path']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to list_protocol_output_dir_files: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.list_protocol_output_dir_files,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def create_directory(self, _message=None, _timeout=None, **kwargs):
        """Create a directory within the protocol output directory tree.

        Errors:
            INVALID_ARGUMENT will be returned if the parent path (where the directory is requested to
                be created) is not within the protocol output directory, or if invalid characters are
                in the requested directory name.

            FAILED_PRECONDITION will be returned if the parent path is not a directory.

            NOT_FOUND will be returned if the parent path does not exist.

            ALREADY_EXISTS will be returned if the directory exists and is not a directory (if the
                directory already exists, this is treated as success).

        The possible valid parent paths can be determined using list_protocol_output_dir_files().

        Since 3.6

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.manager_pb2.CreateDirectoryRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            parent_path (str, optional): The path at which to create the directory.

                This must exist, be a directory, and be within the protocol output directory. This can be
                determined via calls to list_protocol_output_dir_files().
            name (str, optional): The name of the directory to create.

                This must be a single path component (ie: it cannot contain '/' or '\'). There may be other
                restrictions on valid characters, depending on the operating system.

        Returns:
            minknow_api.manager_pb2.CreateDirectoryResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.create_directory,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = CreateDirectoryRequest()

        if "parent_path" in kwargs:
            unused_args.remove("parent_path")
            _message.parent_path = kwargs['parent_path']

        if "name" in kwargs:
            unused_args.remove("name")
            _message.name = kwargs['name']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to create_directory: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.create_directory,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_disk_space_info(self, _message=None, _timeout=None, **kwargs):
        """Returns information about the amount of disk space available, how much
        space is needed to stop an experiment cleanly and if MinKNOW thinks
        that the free disk-space is approaching or past this limit

        Since 3.7

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.GetDiskSpaceInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.GetDiskSpaceInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_disk_space_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetDiskSpaceInfoRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_disk_space_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_disk_space_info,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_default_output_directories(self, _message=None, _timeout=None, **kwargs):
        """As with `instance.get_default_output_directories`, this will return the
        paths that are defined in the config used when an instance of minknow
        is started.

        Since 4.3

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.instance_pb2.GetDefaultOutputDirectoriesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.instance_pb2.OutputDirectories

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_default_output_directories,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = minknow_api.instance_pb2.GetDefaultOutputDirectoriesRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_default_output_directories: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_default_output_directories,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def stream_disk_space_info(self, _message=None, _timeout=None, **kwargs):
        """Stream information about the amount of disk space available, how quickly
        it is being used, how much space is needed to stop an experiment cleanly
        and if MinKNOW thinks that the free disk-space is approaching or past
        this limit

        Since 4.0

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.StreamDiskSpaceInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
                Note that this is the time until the call ends, not the time between returned
                messages.
            period (int, optional): Disk space information will be streamed with this value determining the
                period in seconds between updates.
                A period of 0 is invalid

        Returns:
            iter of minknow_api.manager_pb2.GetDiskSpaceInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.stream_disk_space_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = StreamDiskSpaceInfoRequest()

        if "period" in kwargs:
            unused_args.remove("period")
            _message.period = kwargs['period']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to stream_disk_space_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.stream_disk_space_info,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_barcode_kit_info(self, _message=None, _timeout=None, **kwargs):
        """Get info about all available barcoding kits

        Since 4.1

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.GetBarcodeKitInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.GetBarcodeKitInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_barcode_kit_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetBarcodeKitInfoRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_barcode_kit_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_barcode_kit_info,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_lamp_kit_info(self, _message=None, _timeout=None, **kwargs):
        """Get info about all available lamp kits

        Since 4.1

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.GetLampKitInfoRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.GetLampKitInfoResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_lamp_kit_info,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetLampKitInfoRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_lamp_kit_info: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_lamp_kit_info,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_barcode_keys(self, _message=None, _timeout=None, **kwargs):
        """List all barcode keys associated with the specified barcoding kits

        Since 4.1

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.GetBarcodeKeysRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            barcode_kit_names (str, optional): Names of barcode kits to obtain barcode names for

                Fails with INVALID_ARGUMENT if any of the requested `barcode_kit_names` are unavailable
            lamp_kit_name (str, optional): Name of lamp kit to obtain barcode names for.

                Fails with INVALID_ARGUMENT if the requested `lamp_kit_name` is unavailable.

        Returns:
            minknow_api.manager_pb2.GetBarcodeKeysResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_barcode_keys,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetBarcodeKeysRequest()

        if "barcode_kit_names" in kwargs:
            unused_args.remove("barcode_kit_names")
            _message.barcode_kit_names.extend(kwargs['barcode_kit_names'])

        if "lamp_kit_name" in kwargs:
            unused_args.remove("lamp_kit_name")
            _message.lamp_kit_name = kwargs['lamp_kit_name']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_barcode_keys: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_barcode_keys,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_flow_cell_types(self, _message=None, _timeout=None, **kwargs):
        """List all known types of flow cell.

        The primary purpose of this RPC is to provide a list of flow cell types for a user to select
        from (although most flow cells are capable of telling MinKNOW their product code, making user
        selection unnecessary).

        A secondary benefit of this call is it allows extra information about flow cell types to be
        given.

        Since 4.1

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Note this API is experimental - it may be changed, revised or removed in future minor versions.

        Args:
            _message (minknow_api.manager_pb2.GetFlowCellTypesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.GetFlowCellTypesResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        print("Warning: Method ManagerService.get_flow_cell_types is experimental and may be changed, revised or removed in future minor versions.", file=sys.stderr)
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_flow_cell_types,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetFlowCellTypesRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_flow_cell_types: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_flow_cell_types,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_sequencing_kits(self, _message=None, _timeout=None, **kwargs):
        """List all known sequencing kits.

        The intention is to provide a list of sequencing kits for a user to select from, plus extra
        information that can be used to filter that list.

        Since 4.1

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Note this API is experimental - it may be changed, revised or removed in future minor versions.

        Args:
            _message (minknow_api.manager_pb2.GetSequencingKitsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            flow_cell_product_code (str, optional): The product code of the flow cell that will be used for sequencing.

                Only kits compatible with this flow cell type will be returned (currently, this means that
                there is at least one (sequencing or control) protocol that is compatible with both the kit
                and this flow cell product code).

                This may also affect the returned information about the kit. For example, if it isn't
                possible to basecall on the flow cell, none of the kits will claim to be barcoding capable
                (or compatible with any barcoding expansion kits).

        Returns:
            minknow_api.manager_pb2.GetSequencingKitsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        print("Warning: Method ManagerService.get_sequencing_kits is experimental and may be changed, revised or removed in future minor versions.", file=sys.stderr)
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_sequencing_kits,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetSequencingKitsRequest()

        if "flow_cell_product_code" in kwargs:
            unused_args.remove("flow_cell_product_code")
            _message.flow_cell_product_code = kwargs['flow_cell_product_code']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_sequencing_kits: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_sequencing_kits,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def add_simulated_device(self, _message=None, _timeout=None, **kwargs):
        """Creates a simulated device of the type your system is configured for

        Since 4.3

        

        Args:
            _message (minknow_api.manager_pb2.AddSimulatedDeviceRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            name (str): The name of the position, this must be unique and the correct format:

                For MinIONs and MinION-mk1Cs, "MS" followed by five digits, eg: "MS12345".
                For GridIONs, "GS" followed by five digits, eg: "GS12345".
                For P2Solos, "P2S" followed by four digits, eg: "P2S1234".

                PromethIONs position-names have no format restriction, but must be unique
            type (minknow_api.manager_pb2.SimulatedDeviceType): The type of the simulated device to create.

                If left at default (AUTO), then a sensible default device type is selected.

        Returns:
            minknow_api.manager_pb2.AddSimulatedDeviceResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.add_simulated_device,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = AddSimulatedDeviceRequest()

        if "name" in kwargs:
            unused_args.remove("name")
            _message.name = kwargs['name']
        else:
            raise ArgumentError("add_simulated_device requires a 'name' argument")

        if "type" in kwargs:
            unused_args.remove("type")
            _message.type = kwargs['type']
        else:
            raise ArgumentError("add_simulated_device requires a 'type' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to add_simulated_device: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.add_simulated_device,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def remove_simulated_device(self, _message=None, _timeout=None, **kwargs):
        """Removes a simulated device

        Since 4.3

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.manager_pb2.RemoveSimulatedDeviceRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            name (str): The name of the simulated device to be removed

        Returns:
            minknow_api.manager_pb2.RemoveSimulatedDeviceResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.remove_simulated_device,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = RemoveSimulatedDeviceRequest()

        if "name" in kwargs:
            unused_args.remove("name")
            _message.name = kwargs['name']
        else:
            raise ArgumentError("remove_simulated_device requires a 'name' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to remove_simulated_device: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.remove_simulated_device,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def local_authentication_token_path(self, _message=None, _timeout=None, **kwargs):
        """Get the path for the local authentication token.

        This RPC is only useful when connecting to MinKNOW from the same computer that MinKNOW is
        running on (ie: connecting to "localhost"). If this file exists (which it should if MinKNOW's
        guest mode is not completely disabled), it contains a description of a token that can be used
        to connect to MinKNOW. This is most useful when MinKNOW's guest mode is set to "local_only",
        as it certifies that the client is connecting from the local machine. If the guest mode is
        set to "enabled", no token is required to connect.

        The contents of the file is a json object with two fields, "token" and "expires". "token" is
        the string that can be passed in a "local-auth" gRPC authentication metadata field, while
        "expires" gives the time the token will expire (in RFC3339 format). Note that a new token
        will be written out shortly before this time (and, in fact, the token will be accepted a
        short time after).


        An example token file is::

         {
           "token": "30fe5214-a7c5-4cb3-b521-b1ec8a49592a",
           "expires": "2020-12-18T14:26:12.021934+00:00"
         }

        To connect before 14:26:12.021934 on 2020-12-18, a client would set the metadata field
        "local-auth" to "30fe5214-a7c5-4cb3-b521-b1ec8a49592a". At around 14:26:12, the client should
        re-read the file and update the metadata field with the newly-read value.

        This RPC can be called without providing any authentication tokens.

        Since 4.2

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.LocalAuthenticationTokenPathRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.LocalAuthenticationTokenPathResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.local_authentication_token_path,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = LocalAuthenticationTokenPathRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to local_authentication_token_path: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.local_authentication_token_path,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_alignment_reference_information(self, _message=None, _timeout=None, **kwargs):
        """Query information about a reference file.

        Reference file types are picked up by extension:
        for fasta: .fasta, .fna, .ffn, .faa, .frn
        for mmi: .mmi

        Since 4.4

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.GetAlignmentReferenceInformationRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            path (str, optional): The full path of the alignment reference.

                Should be a .fasta, or .mmi file.

        Returns:
            minknow_api.manager_pb2.GetAlignmentReferenceInformationResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_alignment_reference_information,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetAlignmentReferenceInformationRequest()

        if "path" in kwargs:
            unused_args.remove("path")
            _message.path = kwargs['path']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_alignment_reference_information: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_alignment_reference_information,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def association_device_code(self, _message=None, _timeout=None, **kwargs):
        """Get the device code/key for association.

        This can be used to either get the code that the user must enter into the customer support
        portal to associate the device with their account, or the key used for online association.

        Errors:
            INVALID_ARGUMENT: The requested flow cell position does not exist.

        Since 4.4

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Args:
            _message (minknow_api.manager_pb2.AssociationDeviceCodeRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            position_name (str, optional): The flow cell position to get the association code/key for.

                If this is omitted, the code/key for the sequencing device as a whole is returned.

                Note that this cannot be omitted if MinKNOW is installed on a PC (as opposed to a sequencing
                device). It should be omitted if (and only if) the data returned from `describe_host` has
                its ``needs_association`` field set to true.

                Passing a integrated flow cell position will return the code/key for the whole sequencing
                device.

        Returns:
            minknow_api.manager_pb2.AssociationDeviceCodeResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.association_device_code,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = AssociationDeviceCodeRequest()

        if "position_name" in kwargs:
            unused_args.remove("position_name")
            _message.position_name = kwargs['position_name']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to association_device_code: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.association_device_code,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def apply_offline_association_unlock_code(self, _message=None, _timeout=None, **kwargs):
        """Apply the unlock code for offline association.

        This is the code that the user receives from the customer support portal after entering the
        device code for this device (see `offline_association_device_code`).

        This is only required if either `describe_host` indicates that the device as a whole needs
        association, or `flow_cell_positions` indicates that a particular positions needs it.

        Errors:
            INVALID_ARGUMENT: The requested flow cell position does not exist, or no unlock code
                was provided.

        Note that you will need to check the result to see if the association was successful. Calling
        this on an already-associated device with a valid unlock code will succeed, but have no
        effect.

        Since 4.4

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.manager_pb2.ApplyOfflineAssociationUnlockCodeRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            position_name (str, optional): The flow cell position to unlock.

                This should be set (or not set) to match the corresponding call to
                `offline_association_device_code`.
            unlock_code (str, optional): The unlock code provided by the user.

                This the code given by the customer support portal when the corresponding device code is
                entered into the device association page.

        Returns:
            minknow_api.manager_pb2.ApplyOfflineAssociationUnlockCodeResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.apply_offline_association_unlock_code,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = ApplyOfflineAssociationUnlockCodeRequest()

        if "position_name" in kwargs:
            unused_args.remove("position_name")
            _message.position_name = kwargs['position_name']

        if "unlock_code" in kwargs:
            unused_args.remove("unlock_code")
            _message.unlock_code = kwargs['unlock_code']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to apply_offline_association_unlock_code: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.apply_offline_association_unlock_code,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def list_developer_api_tokens(self, _message=None, _timeout=None, **kwargs):
        """List all developer API tokens.

        List all developer tokens, and their expiry times. Note this does not return the actual token value - this is only available at creation time.

        Since 4.4

        This RPC is idempotent. It may change the state of the system, but if the requested
        change has already happened, it will not fail because of this, make any additional
        changes or return a different value.

        Args:
            _message (minknow_api.manager_pb2.ListDeveloperApiTokensRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.ListDeveloperApiTokensResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.list_developer_api_tokens,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = ListDeveloperApiTokensRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to list_developer_api_tokens: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.list_developer_api_tokens,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def create_developer_api_token(self, _message=None, _timeout=None, **kwargs):
        """Create a new developer API token, with a user facing name, and optional expiry time.

        The response contains the requested token, which will be valid until provided expiry time.

        The token cannot be obtained a second time, once the CreateDeveloperApiTokenResponse is destroyed.

        Since 4.4

        

        Args:
            _message (minknow_api.manager_pb2.CreateDeveloperApiTokenRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            name (str, optional): User facing name describing the token.
            expiry (google.protobuf.timestamp_pb2.Timestamp, optional): Optional expiry time for the token.

        Returns:
            minknow_api.manager_pb2.CreateDeveloperApiTokenResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.create_developer_api_token,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = CreateDeveloperApiTokenRequest()

        if "name" in kwargs:
            unused_args.remove("name")
            _message.name = kwargs['name']

        if "expiry" in kwargs:
            unused_args.remove("expiry")
            _message.expiry.CopyFrom(kwargs['expiry'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to create_developer_api_token: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.create_developer_api_token,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def revoke_developer_api_token(self, _message=None, _timeout=None, **kwargs):
        """Remove a developer api token.

        Since 4.4

        

        Args:
            _message (minknow_api.manager_pb2.RevokeDeveloperApiTokenRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            id (str, optional): The id passed back from [CreateDeveloperApiTokenRequest] or [DeveloperApiToken].

        Returns:
            minknow_api.manager_pb2.RevokeDeveloperApiTokensResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.revoke_developer_api_token,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = RevokeDeveloperApiTokenRequest()

        if "id" in kwargs:
            unused_args.remove("id")
            _message.id = kwargs['id']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to revoke_developer_api_token: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.revoke_developer_api_token,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def find_protocols(self, _message=None, _timeout=None, **kwargs):
        """Find protocols which can be run based on the current device + flowcell.

        Throws an error if there is no flow cell connected.

        Since 4.5

        

        Note this API is experimental - it may be changed, revised or removed in future minor versions.

        Args:
            _message (minknow_api.manager_pb2.FindProtocolsRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            flow_cell_product_code (str, optional): Find protocols that are compatible with this flow cell product code.

                Set to empty string to find protocols matching all flow cell product codes.
            sequencing_kit (str, optional): Limit to protocols that are compatible with this sequencing kit.

                Set to empty string to find protocols matching all kits.
            experiment_type (minknow_api.manager_pb2.ExperimentType, optional): Limit response to certain protocol types.

        Returns:
            minknow_api.manager_pb2.FindProtocolsResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        print("Warning: Method ManagerService.find_protocols is experimental and may be changed, revised or removed in future minor versions.", file=sys.stderr)
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.find_protocols,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = FindProtocolsRequest()

        if "flow_cell_product_code" in kwargs:
            unused_args.remove("flow_cell_product_code")
            _message.flow_cell_product_code = kwargs['flow_cell_product_code']

        if "sequencing_kit" in kwargs:
            unused_args.remove("sequencing_kit")
            _message.sequencing_kit = kwargs['sequencing_kit']

        if "experiment_type" in kwargs:
            unused_args.remove("experiment_type")
            _message.experiment_type = kwargs['experiment_type']

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to find_protocols: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.find_protocols,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def list_settings_for_protocol(self, _message=None, _timeout=None, **kwargs):
        """Given a protocol and some information about the flow-cell and kits will provide a list
        of settings required by the protocol, their defaults and dependencies.

        Since 4.5 (moved from ProtocolService)

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Note this API is experimental - it may be changed, revised or removed in future minor versions.

        Args:
            _message (minknow_api.manager_pb2.ListSettingsForProtocolRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            identifier (str, optional): specify the protocol with a string containing all the protocol's identifying components, eg:
                "sequencing/sequencing_MIN106_DNA:FLO-MIN106:SQK-RPB004"
            components (minknow_api.protocol_settings_pb2.ProtocolIdentifierComponents, optional): specify the protocol providing the identifying components individually. All components are optional, if more
                than one protocol matches given strings, information about the first will be returned.
            flow_cell_connector (minknow_api.device_pb2.FlowCellConnectorType): The flow-cell connector type identifies the type of hardware and is used
                to identify the correct protocol.
                The flow-cell connector types applicable to the device are listed by
                the get_flow_cell_types rpc in this service and the get_device_state rpc
                in the device service.

        Returns:
            minknow_api.manager_pb2.ListSettingsForProtocolResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        print("Warning: Method ManagerService.list_settings_for_protocol is experimental and may be changed, revised or removed in future minor versions.", file=sys.stderr)
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.list_settings_for_protocol,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        # check oneof group 'protocol_identifier'
        oneof_fields = set([
            "identifier",
            "components",
        ])

        if len(unused_args & oneof_fields) > 1:
            raise ArgumentError("list_settings_for_protocol given multiple conflicting arguments: '{}'".format(", ".join(unused_args & oneof_fields)))

        _message = ListSettingsForProtocolRequest()

        if "identifier" in kwargs:
            unused_args.remove("identifier")
            _message.identifier = kwargs['identifier']

        if "components" in kwargs:
            unused_args.remove("components")
            _message.components.CopyFrom(kwargs['components'])

        if "flow_cell_connector" in kwargs:
            unused_args.remove("flow_cell_connector")
            _message.flow_cell_connector = kwargs['flow_cell_connector']
        else:
            raise ArgumentError("list_settings_for_protocol requires a 'flow_cell_connector' argument")

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to list_settings_for_protocol: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.list_settings_for_protocol,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def get_features(self, _message=None, _timeout=None, **kwargs):
        """Get the status of BETA/experimental features

        This RPC has no side effects. Calling it will have no effect on the state of the
        system. It is safe to call repeatedly, or to retry on failure, although there is no
        guarantee it will return the same information each time.

        Note this API is experimental - it may be changed, revised or removed in future minor versions.

        Args:
            _message (minknow_api.manager_pb2.GetFeaturesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.

        Returns:
            minknow_api.manager_pb2.GetFeaturesResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        print("Warning: Method ManagerService.get_features is experimental and may be changed, revised or removed in future minor versions.", file=sys.stderr)
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.get_features,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = GetFeaturesRequest()

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to get_features: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.get_features,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
    def set_features(self, _message=None, _timeout=None, **kwargs):
        """Change whether features are enabled or disabled

        

        Note this API is experimental - it may be changed, revised or removed in future minor versions.

        Args:
            _message (minknow_api.manager_pb2.SetFeaturesRequest, optional): The message to send.
                This can be passed instead of the keyword arguments.
            _timeout (float, optional): The call will be cancelled after this number of seconds
                if it has not been completed.
            features (minknow_api.manager_pb2.FeatureList, optional): 

        Returns:
            minknow_api.manager_pb2.SetFeaturesResponse

        Note that the returned messages are actually wrapped in a type that collapses
        submessages for fields marked with ``[rpc_unwrap]``.
        """
        print("Warning: Method ManagerService.set_features is experimental and may be changed, revised or removed in future minor versions.", file=sys.stderr)
        if _message is not None:
            if isinstance(_message, MessageWrapper):
                _message = _message._message
            return run_with_retry(self._stub.set_features,
                                  _message, _timeout,
                                  [],
                                  "minknow_api.manager.ManagerService")

        unused_args = set(kwargs.keys())

        _message = SetFeaturesRequest()

        if "features" in kwargs:
            unused_args.remove("features")
            _message.features.CopyFrom(kwargs['features'])

        if len(unused_args) > 0:
            raise ArgumentError("Unexpected keyword arguments to set_features: '{}'".format(", ".join(unused_args)))

        return run_with_retry(self._stub.set_features,
                              _message, _timeout,
                              [],
                              "minknow_api.manager.ManagerService")
