# haveibeenpwned-asyncio

v0.0.1

Library to query and check haveibeenpwned with the aiohttp library.

NB: I have added async to sync methods if you are not writing async code. Every query function has an
corresponding synchronous call -> example query_account_sync()

## Install
```bash
pip install haveibeenpwned-asyncio
# or
poetry add haveibeenpwned-asyncio
```

## Usage
See example.py for more uses

Ex:
```python
import os
from haveibeenpwned_asyncio import haveIbeenPwnedPasswords, haveIbeenPwnedAccount
import asyncio

if __name__ == "__main__":
    # Validation Class, inherits from Indentity Class
    loop = asyncio.get_event_loop()
    passwords = ['test@1234', 'test$1234']
    accounts = ['admin@gmail.com', 'test@test.com']

    print(
        loop.run_until_complete(haveIbeenPwnedPasswords(
            passwords=passwords, semaphore_max=10
        ).query_passwords()
                                )
    )

    test_acc = haveIbeenPwnedAccount(
            accounts=accounts,
            semaphore_max=10,
            api_key=os.getenv("HAVEIBEENPWNED_API_KEY", None)
                              )
    print(loop.run_until_complete(test_acc.query_accounts()))
    print(test_acc.query_accounts_sync())

```

## API Key
Some of the endpoints (breachedAccount) require authentication in the v3 of the API.
This is to prevent script kiddies and abuse of the api, see blog post: 
https://www.troyhunt.com/authentication-and-the-have-i-been-pwned-api/

To get an API key follow: https://haveibeenpwned.com/API/Key

Usage:
```python
# Could use env variables
haveIbeenPwnedAccount(
            accounts=accounts,
            semaphore_max=10,
            api_key=os.getenv("HAVEIBEENPWNED_API_KEY", None))

# or 

haveIbeenPwnedAccount(
            accounts=accounts,
            semaphore_max=10,
            api_key='xxxxxxxxx')
```

## TODO:
* Add API key to github actions for pytest to pass on breachedAccount

## Donations
Please feel free to buy me a cup of coffee as I pay a monthly $3 to test the library against haveibeenpwned's 
monthly billed API key

