#  Copyright (c) 2005-2020, Enthought, Inc.
#  All rights reserved.
#
#  This software is provided without warranty under the terms of the BSD
#  license included in LICENSE.txt and may be redistributed only
#  under the conditions described in the aforementioned license.  The license
#  is also available online at http://www.enthought.com/licenses/BSD.txt
#
#  Thanks for using Enthought open source!
#

from traitsui.testing.api import TargetRegistry
from traitsui.testing.tester._ui_tester_registry.wx._traitsui import (
    boolean_editor,
    button_editor,
    check_list_editor,
    editor_factory,
    enum_editor,
    font_editor,
    instance_editor,
    list_editor,
    range_editor,
    text_editor,
    ui_base,
)


def get_default_registry():
    """ Creates a default registry for UITester that is wx specific.

    Returns
    -------
    registry : TargetRegistry
        The default registry containing implementations for TraitsUI editors
        that is wx specific.
    """
    registry = TargetRegistry()

    # BooleanEditor
    boolean_editor.register(registry)

    # ButtonEditor
    button_editor.register(registry)

    # CheckListEditor
    check_list_editor.register(registry)

    # EnumEditor
    enum_editor.register(registry)

    # FontEditor
    font_editor.register(registry)

    # TextEditor
    text_editor.register(registry)

    # ListEditor
    list_editor.register(registry)

    # RangeEditor
    range_editor.register(registry)

    # ui_base
    ui_base.register(registry)

    # InstanceEditor
    instance_editor.register(registry)

    # Editor Factory
    editor_factory.register(registry)

    return registry
